/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.simple;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.JackrabbitSecurityManager;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.AuthContextProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.apache.jackrabbit.core.security.principal.ProviderRegistryImpl;
import org.apache.jackrabbit.core.security.simple.SimpleAccessManager;
import org.apache.jackrabbit.core.security.simple.SimpleWorkspaceAccessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSecurityManager
implements JackrabbitSecurityManager {
    private static Logger log = LoggerFactory.getLogger(SimpleSecurityManager.class);
    private boolean initialized;
    private SecurityConfig config;
    private Session systemSession;
    private PrincipalProviderRegistry principalProviderRegistry;
    private WorkspaceAccessManager workspaceAccessManager;
    private AuthContextProvider authCtxProvider;
    private String adminID;
    private String anonymID;

    protected AccessControlProvider getAccessControlProvider(Session systemSession, String workspaceName) {
        return null;
    }

    public void init(Repository repository, Session systemSession) throws RepositoryException {
        Properties[] moduleConfig;
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        if (!(repository instanceof RepositoryImpl)) {
            throw new RepositoryException("RepositoryImpl expected");
        }
        this.systemSession = systemSession;
        this.config = ((RepositoryImpl)repository).getConfig().getSecurityConfig();
        LoginModuleConfig loginModConf = this.config.getLoginModuleConfig();
        this.authCtxProvider = new AuthContextProvider(this.config.getAppName(), loginModConf);
        if (this.authCtxProvider.isLocal()) {
            log.info("init: using Repository LoginModule configuration for " + this.config.getAppName());
        } else if (this.authCtxProvider.isJAAS()) {
            log.info("init: using JAAS LoginModule configuration for " + this.config.getAppName());
        } else {
            String msg = "No valid LoginModule configuriation for " + this.config.getAppName();
            log.error(msg);
            throw new RepositoryException(msg);
        }
        for (Properties aModuleConfig1 : moduleConfig = this.authCtxProvider.getModuleConfig()) {
            if (aModuleConfig1.containsKey("adminId")) {
                this.adminID = aModuleConfig1.getProperty("adminId");
            }
            if (!aModuleConfig1.containsKey("anonymousId")) continue;
            this.anonymID = aModuleConfig1.getProperty("anonymousId");
        }
        if (this.adminID == null) {
            log.debug("No adminID defined in LoginModule/JAAS config -> using default.");
            this.adminID = "admin";
        }
        if (this.anonymID == null) {
            log.debug("No anonymousID defined in LoginModule/JAAS config -> using default.");
            this.anonymID = "anonymous";
        }
        SimplePrincipalProvider principalProvider = new SimplePrincipalProvider();
        this.principalProviderRegistry = new ProviderRegistryImpl(principalProvider);
        for (Properties aModuleConfig : moduleConfig) {
            this.principalProviderRegistry.registerProvider(aModuleConfig);
        }
        SecurityManagerConfig smc = this.config.getSecurityManagerConfig();
        if (smc != null && smc.getWorkspaceAccessConfig() != null) {
            this.workspaceAccessManager = smc.getWorkspaceAccessConfig().newInstance(WorkspaceAccessManager.class);
        } else {
            log.debug("No WorkspaceAccessManager configured; using default.");
            this.workspaceAccessManager = new SimpleWorkspaceAccessManager();
        }
        this.workspaceAccessManager.init(systemSession);
        this.initialized = true;
    }

    public void dispose(String workspaceName) {
        this.checkInitialized();
    }

    public void close() {
        this.checkInitialized();
    }

    public AccessManager getAccessManager(Session session, AMContext amContext) throws RepositoryException {
        this.checkInitialized();
        try {
            String wspName = session.getWorkspace().getName();
            AccessControlProvider acP = this.getAccessControlProvider(this.systemSession, wspName);
            AccessManagerConfig amc = this.config.getAccessManagerConfig();
            AccessManager accessMgr = amc == null ? new SimpleAccessManager() : amc.newInstance(AccessManager.class);
            accessMgr.init(amContext, acP, this.workspaceAccessManager);
            return accessMgr;
        }
        catch (AccessDeniedException ade) {
            throw ade;
        }
        catch (Exception e) {
            String msg = "failed to instantiate AccessManager implementation: " + SimpleAccessManager.class.getName();
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public synchronized PrincipalManager getPrincipalManager(Session session) throws RepositoryException {
        this.checkInitialized();
        if (session instanceof SessionImpl) {
            SessionImpl sImpl = (SessionImpl)session;
            return new PrincipalManagerImpl((Session)sImpl, this.principalProviderRegistry.getProviders());
        }
        throw new RepositoryException("Internal error: SessionImpl expected.");
    }

    public UserManager getUserManager(Session session) throws RepositoryException {
        this.checkInitialized();
        throw new UnsupportedRepositoryOperationException("UserManager not supported.");
    }

    public String getUserID(Subject subject, String workspaceName) throws RepositoryException {
        String uid = null;
        Iterator<SimpleCredentials> creds = subject.getPublicCredentials(SimpleCredentials.class).iterator();
        if (creds.hasNext()) {
            SimpleCredentials sc = creds.next();
            uid = sc.getUserID();
        } else if (this.anonymID != null && !subject.getPrincipals(AnonymousPrincipal.class).isEmpty()) {
            uid = this.anonymID;
        } else {
            for (Principal p : subject.getPrincipals()) {
                if (p instanceof Group) continue;
                uid = p.getName();
                break;
            }
        }
        return uid;
    }

    public AuthContext getAuthContext(Credentials creds, Subject subject, String workspaceName) throws RepositoryException {
        this.checkInitialized();
        return this.authCtxProvider.getAuthContext(creds, subject, this.systemSession, this.principalProviderRegistry, this.adminID, this.anonymID);
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    private class SimplePrincipalProvider
    implements PrincipalProvider {
        private final Map<String, Principal> principals = new HashMap<String, Principal>();

        private SimplePrincipalProvider() {
            if (SimpleSecurityManager.this.adminID != null) {
                this.principals.put(SimpleSecurityManager.this.adminID, (Principal)((Object)new AdminPrincipal(SimpleSecurityManager.this.adminID)));
            }
            if (SimpleSecurityManager.this.anonymID != null) {
                this.principals.put(SimpleSecurityManager.this.anonymID, new AnonymousPrincipal());
            }
            EveryonePrincipal everyone = EveryonePrincipal.getInstance();
            this.principals.put(everyone.getName(), (Principal)((Object)everyone));
        }

        public Principal getPrincipal(String principalName) {
            if (this.principals.containsKey(principalName)) {
                return this.principals.get(principalName);
            }
            return new UserPrincipal(principalName);
        }

        public PrincipalIterator findPrincipals(String simpleFilter) {
            return this.findPrincipals(simpleFilter, 3);
        }

        public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
            Principal p = this.getPrincipal(simpleFilter);
            if (p == null) {
                return PrincipalIteratorAdapter.EMPTY;
            }
            if (p instanceof Group && searchType == 1 || !(p instanceof Group) && searchType == 2) {
                return PrincipalIteratorAdapter.EMPTY;
            }
            return new PrincipalIteratorAdapter(Collections.singletonList(p));
        }

        public PrincipalIterator getPrincipals(int searchType) {
            PrincipalIteratorAdapter it;
            switch (searchType) {
                case 2: {
                    it = new PrincipalIteratorAdapter(Collections.singletonList(EveryonePrincipal.getInstance()));
                    break;
                }
                case 1: {
                    HashSet<Principal> set = new HashSet<Principal>(this.principals.values());
                    set.remove(EveryonePrincipal.getInstance());
                    it = new PrincipalIteratorAdapter(set);
                    break;
                }
                case 3: {
                    it = new PrincipalIteratorAdapter(this.principals.values());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown search type " + searchType);
                }
            }
            return it;
        }

        public PrincipalIterator getGroupMembership(Principal principal) {
            if (principal instanceof EveryonePrincipal) {
                return PrincipalIteratorAdapter.EMPTY;
            }
            return new PrincipalIteratorAdapter(Collections.singletonList(EveryonePrincipal.getInstance()));
        }

        public void init(Properties options) {
        }

        public void close() {
        }

        public boolean canReadPrincipal(Session session, Principal principal) {
            return true;
        }
    }
}

