/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.security.auth.Subject;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.principal.AbstractPrincipalIterator;
import org.apache.jackrabbit.core.security.principal.AbstractPrincipalProvider;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPrincipalProvider
extends AbstractPrincipalProvider
implements SynchronousEventListener {
    private static Logger log = LoggerFactory.getLogger(DefaultPrincipalProvider.class);
    private final UserManagerImpl userManager;
    private final EveryonePrincipal everyonePrincipal;
    private final String pPrincipalName;

    public DefaultPrincipalProvider(Session systemSession, UserManagerImpl systemUserManager) throws RepositoryException {
        this.userManager = systemUserManager;
        this.everyonePrincipal = EveryonePrincipal.getInstance();
        String[] ntNames = new String[1];
        if (systemSession instanceof SessionImpl) {
            NameResolver resolver = (NameResolver)systemSession;
            ntNames[0] = resolver.getJCRName(UserManagerImpl.NT_REP_AUTHORIZABLE_FOLDER);
            this.pPrincipalName = resolver.getJCRName(UserManagerImpl.P_PRINCIPAL_NAME);
        } else {
            ntNames[0] = "rep:AuthorizableFolder";
            this.pPrincipalName = "rep:principalName";
        }
        String groupPath = this.userManager.getGroupsPath();
        String userPath = this.userManager.getUsersPath();
        String targetPath = groupPath;
        while (!Text.isDescendantOrEqual((String)targetPath, (String)userPath)) {
            targetPath = Text.getRelativeParent((String)targetPath, (int)1);
        }
        systemSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 3, targetPath, true, null, ntNames, false);
    }

    @Override
    protected Principal providePrincipal(String principalName) {
        if (this.everyonePrincipal.getName().equals(principalName)) {
            return this.everyonePrincipal;
        }
        try {
            PrincipalImpl principal = new PrincipalImpl(principalName);
            Authorizable ath = this.userManager.getAuthorizable((Principal)((Object)principal));
            if (ath != null) {
                return ath.getPrincipal();
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to access Authorizable for Principal " + principalName, (Throwable)e);
        }
        return null;
    }

    @Override
    public void init(Properties options) {
        if (!options.containsKey("cacheIncludesNegative")) {
            options.put("cacheIncludesNegative", "true");
        }
        super.init(options);
    }

    @Override
    public PrincipalIterator findPrincipals(String simpleFilter) {
        return this.findPrincipals(simpleFilter, 3);
    }

    @Override
    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        this.checkInitialized();
        switch (searchType) {
            case 2: {
                return this.findGroupPrincipals(simpleFilter);
            }
            case 1: {
                return this.findUserPrincipals(simpleFilter);
            }
            case 3: {
                PrincipalIterator[] its = new PrincipalIterator[]{this.findUserPrincipals(simpleFilter), this.findGroupPrincipals(simpleFilter)};
                return new PrincipalIteratorAdapter((Iterator<? extends Principal>)new IteratorChain((Iterator[])its));
            }
        }
        throw new IllegalArgumentException("Invalid searchType");
    }

    @Override
    public PrincipalIterator getPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    @Override
    public PrincipalIterator getGroupMembership(Principal userPrincipal) {
        this.checkInitialized();
        Set<Principal> mship = this.collectGroupMembership(userPrincipal);
        if (!mship.contains(this.everyonePrincipal) && this.everyonePrincipal.isMember(userPrincipal)) {
            mship.add((Principal)((Object)this.everyonePrincipal));
        }
        return new PrincipalIteratorAdapter(mship);
    }

    @Override
    public synchronized void close() {
        super.close();
    }

    @Override
    public boolean canReadPrincipal(Session session, Principal principal) {
        this.checkInitialized();
        if (session instanceof SessionImpl) {
            SessionImpl sImpl = (SessionImpl)session;
            Subject subject = sImpl.getSubject();
            if (!subject.getPrincipals(SystemPrincipal.class).isEmpty() || !subject.getPrincipals(AdminPrincipal.class).isEmpty()) {
                return true;
            }
            try {
                UserManager umgr = sImpl.getUserManager();
                return umgr.getAuthorizable(principal) != null;
            }
            catch (RepositoryException e) {
                log.error("Failed to determine accessibility of Principal {}", (Object)principal, (Object)e);
            }
        }
        return false;
    }

    public void onEvent(EventIterator eventIterator) {
        this.clearCache();
    }

    private Set<Principal> collectGroupMembership(Principal princ) {
        LinkedHashSet<Principal> membership = new LinkedHashSet<Principal>();
        try {
            Authorizable auth = this.userManager.getAuthorizable(princ);
            if (auth != null) {
                this.addToCache(auth.getPrincipal());
                Iterator itr = auth.memberOf();
                while (itr.hasNext()) {
                    Group group = (Group)itr.next();
                    Principal gp = group.getPrincipal();
                    this.addToCache(gp);
                    membership.add(gp);
                }
            } else {
                log.debug("Cannot find authorizable for principal " + princ.getName());
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to determine membership for " + princ.getName(), (Object)e.getMessage());
        }
        return membership;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalIterator findUserPrincipals(String simpleFilter) {
        UserManagerImpl userManagerImpl = this.userManager;
        synchronized (userManagerImpl) {
            try {
                Iterator<Authorizable> itr = this.userManager.findAuthorizables(this.pPrincipalName, simpleFilter, 1);
                return new PrincipalIteratorImpl(itr, false);
            }
            catch (RepositoryException e) {
                log.error("Error while searching user principals.", (Throwable)e);
                return PrincipalIteratorAdapter.EMPTY;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalIterator findGroupPrincipals(String simpleFilter) {
        UserManagerImpl userManagerImpl = this.userManager;
        synchronized (userManagerImpl) {
            try {
                Iterator<Authorizable> itr = this.userManager.findAuthorizables(this.pPrincipalName, simpleFilter, 2);
                boolean addEveryone = this.everyonePrincipal.getName().matches(".*" + simpleFilter + ".*");
                return new PrincipalIteratorImpl(itr, addEveryone);
            }
            catch (RepositoryException e) {
                log.error("Error while searching group principals.", (Throwable)e);
                return PrincipalIteratorAdapter.EMPTY;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrincipalIteratorImpl
    extends AbstractPrincipalIterator {
        private final Iterator<Authorizable> authorizableItr;
        private boolean addEveryone;

        private PrincipalIteratorImpl(Iterator<Authorizable> authorizableItr, boolean addEveryone) {
            this.authorizableItr = authorizableItr;
            this.addEveryone = addEveryone;
            this.next = this.seekNext();
        }

        @Override
        protected Principal seekNext() {
            while (this.authorizableItr.hasNext()) {
                try {
                    Principal p = this.authorizableItr.next().getPrincipal();
                    DefaultPrincipalProvider.this.addToCache(p);
                    return p;
                }
                catch (RepositoryException e) {
                    log.warn("Error while retrieving principal from group -> skip.");
                }
            }
            if (this.addEveryone) {
                this.addEveryone = false;
                return DefaultPrincipalProvider.this.everyonePrincipal;
            }
            return null;
        }
    }
}

