/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.importer;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import java.util.List;

public final class ImportedPackage {
    private Application application;
    private DeploymentPackage deploymentPackage;
    private List<Deployable> deployables = Lists.newArrayList();
    private final PackageInfo packageInfo;

    public ImportedPackage(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
        this.createApplicationEntity(packageInfo);
        this.createDeploymentPackageEntity(packageInfo);
    }

    public ImportedPackage(PackageInfo packageInfo, Application applicationEntity, DeploymentPackage deploymentPackageEntity) {
        this.packageInfo = packageInfo;
        this.application = applicationEntity;
        this.deploymentPackage = deploymentPackageEntity;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public Application getApplication() {
        return this.application;
    }

    public DeploymentPackage getDeploymentPackage() {
        return this.deploymentPackage;
    }

    public List<Deployable> getDeployables() {
        return this.deployables;
    }

    public void setDeployables(List<Deployable> deployables) {
        this.deployables = deployables;
    }

    public void addDeployable(Deployable deployable) {
        this.deployables.add(deployable);
    }

    private void createApplicationEntity(PackageInfo packageInfo) {
        this.application = new Application();
        this.application.setId(IdGenerator.generateId(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName(), packageInfo.applicationName));
    }

    private void createDeploymentPackageEntity(PackageInfo packageInfo) {
        this.deploymentPackage = new DeploymentPackage();
        this.deploymentPackage.setId(IdGenerator.generateId((ConfigurationItem)this.application, packageInfo.applicationVersion));
        this.deploymentPackage.setApplication(this.application);
    }
}

