/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.mustache;

import com.samskivert.mustache.MustacheException;
import com.samskivert.mustache.MustacheParseException;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Mustache {
    protected static final int TEXT = 0;
    protected static final int MATCHING_START = 1;
    protected static final int MATCHING_END = 2;
    protected static final int TAG = 3;
    protected static final String[][] ATTR_ESCAPES = new String[][]{{"&", "&amp;"}, {"'", "&apos;"}, {"\"", "&quot;"}, {"<", "&lt;"}, {">", "&gt;"}};
    protected static final char NO_CHAR = '\u0000';
    protected static final TemplateLoader FAILING_LOADER = new TemplateLoader(){

        public Reader getTemplate(String name) {
            throw new UnsupportedOperationException("Template loading not configured");
        }
    };

    public static Compiler compiler() {
        return new Compiler(true, false, null, true, FAILING_LOADER);
    }

    protected static Template compile(Reader source, Compiler compiler) {
        Accumulator accum = new Accumulator(compiler);
        Delims delims = new Delims();
        int state = 0;
        StringBuilder text = new StringBuilder();
        int line = 1;
        boolean skipNewline = false;
        while (true) {
            char c;
            try {
                int v = source.read();
                if (v == -1) break;
                c = (char)v;
            }
            catch (IOException e) {
                throw new MustacheException(e);
            }
            if (c == '\n') {
                ++line;
                if (skipNewline) {
                    skipNewline = false;
                    continue;
                }
            } else {
                skipNewline = false;
            }
            switch (state) {
                case 0: {
                    if (c == delims.start1) {
                        if (delims.start2 == '\u0000') {
                            accum.addTextSegment(text);
                            state = 3;
                            break;
                        }
                        state = 1;
                        break;
                    }
                    text.append(c);
                    break;
                }
                case 1: {
                    if (c == delims.start2) {
                        accum.addTextSegment(text);
                        state = 3;
                        break;
                    }
                    text.append(delims.start1);
                    if (c == delims.start1) break;
                    text.append(c);
                    state = 0;
                    break;
                }
                case 3: {
                    if (c == delims.end1) {
                        if (delims.end2 == '\u0000') {
                            if (text.charAt(0) == '=') {
                                delims.updateDelims(text.substring(1, text.length() - 1));
                                text.setLength(0);
                            } else {
                                Mustache.sanityCheckTag(text, line, delims.start1, delims.start2);
                                accum = accum.addTagSegment(text, line);
                                skipNewline = accum.skipNewline();
                            }
                            state = 0;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    text.append(c);
                    break;
                }
                case 2: {
                    if (c == delims.end2) {
                        if (text.charAt(0) == '=') {
                            delims.updateDelims(text.substring(1, text.length() - 1));
                            text.setLength(0);
                        } else {
                            if (delims.isDefault() && text.charAt(0) == delims.start1) {
                                try {
                                    char end3 = (char)source.read();
                                    if (end3 != '}') {
                                        throw new MustacheParseException("Invalid triple-mustache tag: {{{" + text + "}}", line);
                                    }
                                }
                                catch (IOException e) {
                                    throw new MustacheException(e);
                                }
                                text.replace(0, 1, "&");
                            }
                            Mustache.sanityCheckTag(text, line, delims.start1, delims.start2);
                            accum = accum.addTagSegment(text, line);
                            skipNewline = accum.skipNewline();
                        }
                        state = 0;
                        break;
                    }
                    text.append(delims.end1);
                    if (c == delims.end1) break;
                    text.append(c);
                    state = 3;
                }
            }
        }
        switch (state) {
            case 0: {
                accum.addTextSegment(text);
                break;
            }
            case 1: {
                text.append(delims.start1);
                accum.addTextSegment(text);
                break;
            }
            case 2: {
                text.append(delims.end1);
                accum.addTextSegment(text);
                break;
            }
            case 3: {
                throw new MustacheParseException("Template ended while parsing a tag: " + text);
            }
        }
        return new Template(accum.finish(), compiler);
    }

    private Mustache() {
    }

    protected static void sanityCheckTag(StringBuilder accum, int line, char start1, char start2) {
        int ll = accum.length();
        for (int ii = 0; ii < ll; ++ii) {
            if (accum.charAt(ii) != start1 || start2 != '\u0000' && (ii >= ll - 1 || accum.charAt(ii + 1) != start2)) continue;
            throw new MustacheParseException("Tag contains start tag delimiter, probably missing close delimiter '" + accum + "'", line);
        }
    }

    protected static String escapeHTML(String text) {
        for (String[] escape : ATTR_ESCAPES) {
            text = text.replace(escape[0], escape[1]);
        }
        return text;
    }

    protected static class InvertedSectionSegment
    extends CompoundSegment {
        public InvertedSectionSegment(String name, Template.Segment[] segs, int line) {
            super(name, segs, line);
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Iterator iter;
            Object value = tmpl.getSectionValue(ctx, this._name, this._line);
            if (value instanceof Iterable) {
                Iterable iable = (Iterable)value;
                if (!iable.iterator().hasNext()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof Boolean) {
                if (!((Boolean)value).booleanValue()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value.getClass().isArray()) {
                if (Array.getLength(value) == 0) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof Iterator && !(iter = (Iterator)value).hasNext()) {
                this.executeSegs(tmpl, ctx, out);
            }
        }
    }

    protected static class SectionSegment
    extends CompoundSegment {
        public SectionSegment(String name, Template.Segment[] segs, int line) {
            super(name, segs, line);
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Iterator value = tmpl.getSectionValue(ctx, this._name, this._line);
            if (value instanceof Iterable) {
                value = ((Iterable)((Object)value)).iterator();
            }
            if (value instanceof Iterator) {
                Template.Mode mode = null;
                int index = 0;
                Iterator iter = value;
                while (iter.hasNext()) {
                    Object elem = iter.next();
                    mode = mode == null ? Template.Mode.FIRST : (iter.hasNext() ? Template.Mode.OTHER : Template.Mode.LAST);
                    this.executeSegs(tmpl, ctx.nest(elem, ++index, mode), out);
                }
            } else if (value instanceof Boolean) {
                if (((Boolean)((Object)value)).booleanValue()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value.getClass().isArray()) {
                int ll = Array.getLength(value);
                for (int ii = 0; ii < ll; ++ii) {
                    Template.Mode mode = ii == 0 ? Template.Mode.FIRST : (ii == ll - 1 ? Template.Mode.LAST : Template.Mode.OTHER);
                    this.executeSegs(tmpl, ctx.nest(Array.get(value, ii), ii + 1, mode), out);
                }
            } else {
                this.executeSegs(tmpl, ctx.nest(value, 0, Template.Mode.OTHER), out);
            }
        }
    }

    protected static abstract class CompoundSegment
    extends NamedSegment {
        protected final Template.Segment[] _segs;

        protected CompoundSegment(String name, Template.Segment[] segs, int line) {
            super(name, line);
            this._segs = segs;
        }

        protected void executeSegs(Template tmpl, Template.Context ctx, Writer out) {
            for (Template.Segment seg : this._segs) {
                seg.execute(tmpl, ctx, out);
            }
        }
    }

    protected static class VariableSegment
    extends NamedSegment {
        protected boolean _escapeHTML;

        public VariableSegment(String name, boolean escapeHTML, int line) {
            super(name, line);
            this._escapeHTML = escapeHTML;
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Object value = tmpl.getValueOrDefault(ctx, this._name, this._line);
            if (value == null) {
                throw new MustacheException("No key, method or field with name '" + this._name + "' on line " + this._line);
            }
            String text = String.valueOf(value);
            VariableSegment.write(out, this._escapeHTML ? Mustache.escapeHTML(text) : text);
        }
    }

    protected static abstract class NamedSegment
    extends Template.Segment {
        protected final String _name;
        protected final int _line;

        protected NamedSegment(String name, int line) {
            this._name = name.intern();
            this._line = line;
        }
    }

    protected static class IncludedTemplateSegment
    extends Template.Segment {
        protected final Template _template;

        public IncludedTemplateSegment(String templateName, Compiler compiler) {
            Reader r;
            try {
                r = compiler.loader.getTemplate(templateName);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MustacheException("Unable to load template: " + templateName, e);
            }
            this._template = compiler.compile(r);
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            this._template.executeSegs(ctx, out);
        }
    }

    protected static class StringSegment
    extends Template.Segment {
        protected final String _text;

        public StringSegment(String text) {
            this._text = text;
        }

        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            StringSegment.write(out, this._text);
        }
    }

    protected static class Accumulator {
        protected Compiler _compiler;
        protected final List<Template.Segment> _segs = new ArrayList<Template.Segment>();

        public Accumulator(Compiler compiler) {
            this._compiler = compiler;
        }

        public boolean skipNewline() {
            return this._segs.size() > 0 && this._segs.get(this._segs.size() - 1) instanceof CompoundSegment;
        }

        public void addTextSegment(StringBuilder text) {
            if (text.length() > 0) {
                this._segs.add(new StringSegment(text.toString()));
                text.setLength(0);
            }
        }

        public Accumulator addTagSegment(StringBuilder accum, final int tagLine) {
            final Accumulator outer = this;
            String tag = accum.toString().trim();
            final String tag1 = tag.substring(1).trim();
            accum.setLength(0);
            switch (tag.charAt(0)) {
                case '#': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._compiler){

                        public boolean skipNewline() {
                            return this._segs.size() == 0 || super.skipNewline();
                        }

                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Section missing close tag '" + tag1 + "'", tagLine);
                        }

                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            1.requireSameName(tag1, itag, line);
                            outer._segs.add(new SectionSegment(itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '>': {
                    this._segs.add(new IncludedTemplateSegment(tag1, this._compiler));
                    return this;
                }
                case '^': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._compiler){

                        public boolean skipNewline() {
                            return this._segs.size() == 0 || super.skipNewline();
                        }

                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Inverted section missing close tag '" + tag1 + "'", tagLine);
                        }

                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            2.requireSameName(tag1, itag, line);
                            outer._segs.add(new InvertedSectionSegment(itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '/': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return this.addCloseSectionSegment(tag1, tagLine);
                }
                case '!': {
                    return this;
                }
                case '&': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    this._segs.add(new VariableSegment(tag1, false, tagLine));
                    return this;
                }
            }
            Accumulator.requireNoNewlines(tag, tagLine);
            this._segs.add(new VariableSegment(tag, this._compiler.escapeHTML, tagLine));
            return this;
        }

        public Template.Segment[] finish() {
            return this._segs.toArray(new Template.Segment[this._segs.size()]);
        }

        protected Accumulator addCloseSectionSegment(String tag, int line) {
            throw new MustacheParseException("Section close tag with no open tag '" + tag + "'", line);
        }

        protected static void requireNoNewlines(String tag, int line) {
            if (tag.indexOf("\n") != -1 || tag.indexOf("\r") != -1) {
                throw new MustacheParseException("Invalid tag name: contains newline '" + tag + "'", line);
            }
        }

        protected static void requireSameName(String name1, String name2, int line) {
            if (!name1.equals(name2)) {
                throw new MustacheParseException("Section close tag with mismatched open tag '" + name2 + "' != '" + name1 + "'", line);
            }
        }
    }

    protected static class Delims {
        public char start1 = (char)123;
        public char start2 = (char)123;
        public char end1 = (char)125;
        public char end2 = (char)125;

        protected Delims() {
        }

        public boolean isDefault() {
            return this.start1 == '{' && this.start2 == '{' && this.end1 == '}' && this.end2 == '}';
        }

        public void updateDelims(String dtext) {
            String errmsg = "Invalid delimiter configuration '" + dtext + "'. Must be of the " + "form {{=1 2=}} or {{=12 34=}} where 1, 2, 3 and 4 are delimiter chars.";
            String[] delims = dtext.split(" ");
            if (delims.length != 2) {
                throw new MustacheException(errmsg);
            }
            switch (delims[0].length()) {
                case 1: {
                    this.start1 = delims[0].charAt(0);
                    this.start2 = '\u0000';
                    break;
                }
                case 2: {
                    this.start1 = delims[0].charAt(0);
                    this.start2 = delims[0].charAt(1);
                    break;
                }
                default: {
                    throw new MustacheException(errmsg);
                }
            }
            switch (delims[1].length()) {
                case 1: {
                    this.end1 = delims[1].charAt(0);
                    this.end2 = '\u0000';
                    break;
                }
                case 2: {
                    this.end1 = delims[1].charAt(0);
                    this.end2 = delims[1].charAt(1);
                    break;
                }
                default: {
                    throw new MustacheException(errmsg);
                }
            }
        }
    }

    public static interface TemplateLoader {
        public Reader getTemplate(String var1) throws Exception;
    }

    public static class Compiler {
        public final boolean escapeHTML;
        public final boolean standardsMode;
        public final String nullValue;
        public final boolean missingIsNull;
        public final TemplateLoader loader;

        public Template compile(String template) {
            return this.compile(new StringReader(template));
        }

        public Template compile(Reader source) {
            return Mustache.compile(source, this);
        }

        public Compiler escapeHTML(boolean escapeHTML) {
            return new Compiler(escapeHTML, this.standardsMode, this.nullValue, this.missingIsNull, this.loader);
        }

        public Compiler standardsMode(boolean standardsMode) {
            return new Compiler(this.escapeHTML, standardsMode, this.nullValue, this.missingIsNull, this.loader);
        }

        public Compiler defaultValue(String defaultValue) {
            return new Compiler(this.escapeHTML, this.standardsMode, defaultValue, true, this.loader);
        }

        public Compiler nullValue(String nullValue) {
            return new Compiler(this.escapeHTML, this.standardsMode, nullValue, false, this.loader);
        }

        public Compiler withLoader(TemplateLoader loader) {
            return new Compiler(this.escapeHTML, this.standardsMode, this.nullValue, this.missingIsNull, loader);
        }

        protected Compiler(boolean escapeHTML, boolean standardsMode, String nullValue, boolean missingIsNull, TemplateLoader loader) {
            this.escapeHTML = escapeHTML;
            this.standardsMode = standardsMode;
            this.nullValue = nullValue;
            this.missingIsNull = missingIsNull;
            this.loader = loader;
        }
    }
}

