/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public abstract class AbstractPreAuthenticatedProcessingFilter
extends GenericFilterBean
implements InitializingBean,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher eventPublisher = null;
    private AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationManager authenticationManager = null;
    private boolean continueFilterChainOnUnsuccessfulAuthentication = true;
    private boolean checkForPrincipalChanges;
    private boolean invalidateSessionOnPrincipalChange = true;

    public void afterPropertiesSet() {
        Assert.notNull(this.authenticationManager, "An AuthenticationManager must be set");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking secure context token: " + SecurityContextHolder.getContext().getAuthentication());
        }
        if (this.requiresAuthentication((HttpServletRequest)request)) {
            this.doAuthenticate((HttpServletRequest)request, (HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    private void doAuthenticate(HttpServletRequest request, HttpServletResponse response) {
        block5: {
            Authentication authResult = null;
            Object principal = this.getPreAuthenticatedPrincipal(request);
            Object credentials = this.getPreAuthenticatedCredentials(request);
            if (principal == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No pre-authenticated principal found in request");
                }
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("preAuthenticatedPrincipal = " + principal + ", trying to authenticate");
            }
            try {
                PreAuthenticatedAuthenticationToken authRequest = new PreAuthenticatedAuthenticationToken(principal, credentials);
                authRequest.setDetails(this.authenticationDetailsSource.buildDetails(request));
                authResult = this.authenticationManager.authenticate(authRequest);
                this.successfulAuthentication(request, response, authResult);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(request, response, failed);
                if (this.continueFilterChainOnUnsuccessfulAuthentication) break block5;
                throw failed;
            }
        }
    }

    private boolean requiresAuthentication(HttpServletRequest request) {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser == null) {
            return true;
        }
        Object principal = this.getPreAuthenticatedPrincipal(request);
        if (this.checkForPrincipalChanges && !currentUser.getName().equals(principal)) {
            HttpSession session;
            this.logger.debug("Pre-authenticated principal has changed to " + principal + " and will be reauthenticated");
            if (this.invalidateSessionOnPrincipalChange && (session = request.getSession(false)) != null) {
                this.logger.debug("Invalidating existing session");
                session.invalidate();
            }
            return true;
        }
        return false;
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Authentication success: " + authResult);
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(new InteractiveAuthenticationSuccessEvent(authResult, this.getClass()));
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        SecurityContextHolder.clearContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cleared security context due to exception", failed);
        }
        request.getSession().setAttribute("SPRING_SECURITY_LAST_EXCEPTION", failed);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher anApplicationEventPublisher) {
        this.eventPublisher = anApplicationEventPublisher;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, "AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setContinueFilterChainOnUnsuccessfulAuthentication(boolean shouldContinue) {
        this.continueFilterChainOnUnsuccessfulAuthentication = shouldContinue;
    }

    public void setCheckForPrincipalChanges(boolean checkForPrincipalChanges) {
        this.checkForPrincipalChanges = checkForPrincipalChanges;
    }

    public void setInvalidateSessionOnPrincipalChange(boolean invalidateSessionOnPrincipalChange) {
        this.invalidateSessionOnPrincipalChange = invalidateSessionOnPrincipalChange;
    }

    protected abstract Object getPreAuthenticatedPrincipal(HttpServletRequest var1);

    protected abstract Object getPreAuthenticatedCredentials(HttpServletRequest var1);
}

