/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthenticationManagerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_ALIAS = "alias";
    private static final String ATT_REF = "ref";
    private static final String ATT_ERASE_CREDENTIALS = "erase-credentials";

    public BeanDefinition parse(Element element, ParserContext pc) {
        Assert.state(!pc.getRegistry().containsBeanDefinition("org.springframework.security.authenticationManager"), "AuthenticationManager has already been registered!");
        pc.pushContainingComponent(new CompositeComponentDefinition(element.getTagName(), pc.extractSource(element)));
        BeanDefinitionBuilder providerManagerBldr = BeanDefinitionBuilder.rootBeanDefinition(ProviderManager.class);
        String alias = element.getAttribute(ATT_ALIAS);
        this.checkForDeprecatedSessionControllerRef(element, pc);
        ManagedList<BeanMetadataElement> providers = new ManagedList<BeanMetadataElement>();
        NamespaceHandlerResolver resolver = pc.getReaderContext().getNamespaceHandlerResolver();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element providerElt = (Element)node;
            if (StringUtils.hasText(providerElt.getAttribute(ATT_REF))) {
                providers.add(new RuntimeBeanReference(providerElt.getAttribute(ATT_REF)));
                continue;
            }
            BeanDefinition provider = resolver.resolve(providerElt.getNamespaceURI()).parse(providerElt, pc);
            Assert.notNull(provider, "Parser for " + providerElt.getNodeName() + " returned a null bean definition");
            String id = pc.getReaderContext().generateBeanName(provider);
            pc.registerBeanComponent(new BeanComponentDefinition(provider, id));
            providers.add(new RuntimeBeanReference(id));
        }
        if (providers.isEmpty()) {
            providers.add(new RootBeanDefinition(NullAuthenticationProvider.class));
        }
        providerManagerBldr.addPropertyValue("providers", providers);
        if ("true".equals(element.getAttribute(ATT_ERASE_CREDENTIALS))) {
            providerManagerBldr.addPropertyValue("eraseCredentialsAfterAuthentication", true);
        }
        RootBeanDefinition publisher = new RootBeanDefinition(DefaultAuthenticationEventPublisher.class);
        String id = pc.getReaderContext().generateBeanName(publisher);
        pc.registerBeanComponent(new BeanComponentDefinition(publisher, id));
        providerManagerBldr.addPropertyReference("authenticationEventPublisher", id);
        pc.registerBeanComponent(new BeanComponentDefinition(providerManagerBldr.getBeanDefinition(), "org.springframework.security.authenticationManager"));
        if (StringUtils.hasText(alias)) {
            pc.getRegistry().registerAlias("org.springframework.security.authenticationManager", alias);
            pc.getReaderContext().fireAliasRegistered("org.springframework.security.authenticationManager", alias, pc.extractSource(element));
        }
        pc.popAndRegisterContainingComponent();
        return null;
    }

    private void checkForDeprecatedSessionControllerRef(Element element, ParserContext pc) {
        String ATT_SESSION_CONTROLLER_REF = "session-controller-ref";
        if (StringUtils.hasText(element.getAttribute("session-controller-ref"))) {
            pc.getReaderContext().warning("session-controller-ref is not supported in Spring Security  3.0 and will be ignored. Use the attribute on the <concurrent-session-control> element instead.", pc.extractSource(element));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NullAuthenticationProvider
    implements AuthenticationProvider {
        @Override
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            return null;
        }

        @Override
        public boolean supports(Class<? extends Object> authentication) {
            return false;
        }
    }
}

