/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.method;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.util.StringUtils;

public class MethodSecurityMetadataSourceEditor
extends PropertyEditorSupport {
    public void setAsText(String s) throws IllegalArgumentException {
        if (s == null || "".equals(s)) {
            this.setValue(new MapBasedMethodSecurityMetadataSource());
            return;
        }
        PropertiesEditor propertiesEditor = new PropertiesEditor();
        propertiesEditor.setAsText(s);
        Properties props = (Properties)propertiesEditor.getValue();
        LinkedHashMap<String, List<ConfigAttribute>> mappings = new LinkedHashMap<String, List<ConfigAttribute>>();
        for (String string : props.keySet()) {
            String value = props.getProperty(string);
            String[] tokens = StringUtils.commaDelimitedListToStringArray(value);
            ArrayList<SecurityConfig> attributes = new ArrayList<SecurityConfig>(tokens.length);
            for (String token : tokens) {
                attributes.add(new SecurityConfig(token));
            }
            mappings.put(string, attributes);
        }
        this.setValue(new MapBasedMethodSecurityMetadataSource(mappings));
    }
}

