/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.access.method.AbstractFallbackMethodSecurityMetadataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredAnnotationSecurityMetadataSource
extends AbstractFallbackMethodSecurityMetadataSource {
    @Override
    protected Collection<ConfigAttribute> findAttributes(Class<?> clazz) {
        return this.processAnnotation(clazz.getAnnotation(Secured.class));
    }

    @Override
    protected Collection<ConfigAttribute> findAttributes(Method method, Class<?> targetClass) {
        return this.processAnnotation(AnnotationUtils.findAnnotation(method, Secured.class));
    }

    @Override
    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    private List<ConfigAttribute> processAnnotation(Annotation a) {
        if (a == null || !(a instanceof Secured)) {
            return null;
        }
        String[] attributeTokens = ((Secured)a).value();
        ArrayList<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>(attributeTokens.length);
        for (String token : attributeTokens) {
            attributes.add(new SecurityConfig(token));
        }
        return attributes;
    }
}

