/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.util.Assert;

public class CronTriggerBean
extends CronTrigger
implements JobDetailAwareTrigger,
BeanNameAware,
InitializingBean {
    private static final Constants constants = new Constants(CronTrigger.class);
    private JobDetail jobDetail;
    private String beanName;
    private long startDelay;

    public void setJobDataAsMap(Map jobDataAsMap) {
        this.getJobDataMap().putAll(jobDataAsMap);
    }

    public void setMisfireInstructionName(String constantName) {
        this.setMisfireInstruction(constants.asNumber(constantName).intValue());
    }

    public void setTriggerListenerNames(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.addTriggerListener(names[i]);
            ++i;
        }
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void setStartDelay(long startDelay) {
        Assert.state(startDelay >= 0L, "Start delay cannot be negative.");
        this.startDelay = startDelay;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.startDelay > 0L) {
            this.setStartTime(new Date(System.currentTimeMillis() + this.startDelay));
        }
        if (this.getName() == null) {
            this.setName(this.beanName);
        }
        if (this.getGroup() == null) {
            this.setGroup("DEFAULT");
        }
        if (this.getStartTime() == null) {
            this.setStartTime(new Date());
        }
        if (this.getTimeZone() == null) {
            this.setTimeZone(TimeZone.getDefault());
        }
        if (this.jobDetail != null) {
            this.setJobName(this.jobDetail.getName());
            this.setJobGroup(this.jobDetail.getGroup());
        }
    }
}

