/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.support;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingConversionService
extends GenericConversionService
implements FormatterRegistry,
EmbeddedValueResolverAware {
    private StringValueResolver embeddedValueResolver;
    private final Map<FieldFormatterKey, GenericConverter> cachedPrinters = new ConcurrentHashMap<FieldFormatterKey, GenericConverter>();
    private final Map<FieldFormatterKey, GenericConverter> cachedParsers = new ConcurrentHashMap<FieldFormatterKey, GenericConverter>();

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Formatter<?> formatter) {
        this.addConverter(new PrinterConverter(fieldType, formatter, this));
        this.addConverter(new ParserConverter(fieldType, formatter, this));
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Printer<?> printer, Parser<?> parser) {
        this.addConverter(new PrinterConverter(fieldType, printer, this));
        this.addConverter(new ParserConverter(fieldType, parser, this));
    }

    public void addFormatterForFieldAnnotation(final AnnotationFormatterFactory annotationFormatterFactory) {
        final Class<?> annotationType = GenericTypeResolver.resolveTypeArgument(annotationFormatterFactory.getClass(), AnnotationFormatterFactory.class);
        if (annotationType == null) {
            throw new IllegalArgumentException("Unable to extract parameterized Annotation type argument from AnnotationFormatterFactory [" + annotationFormatterFactory.getClass().getName() + "]; does the factory parameterize the <A extends Annotation> generic type?");
        }
        if (this.embeddedValueResolver != null && annotationFormatterFactory instanceof EmbeddedValueResolverAware) {
            ((EmbeddedValueResolverAware)((Object)annotationFormatterFactory)).setEmbeddedValueResolver(this.embeddedValueResolver);
        }
        Set<Class<?>> fieldTypes = annotationFormatterFactory.getFieldTypes();
        for (final Class<?> fieldType : fieldTypes) {
            this.addConverter(new ConditionalGenericConverter(){

                @Override
                public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                    return Collections.singleton(new GenericConverter.ConvertiblePair(fieldType, String.class));
                }

                @Override
                public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                    return sourceType.getAnnotation(annotationType) != null;
                }

                @Override
                public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
                    FieldFormatterKey key = new FieldFormatterKey(sourceType.getAnnotation(annotationType), fieldType);
                    GenericConverter converter = (GenericConverter)FormattingConversionService.this.cachedPrinters.get(key);
                    if (converter == null) {
                        Printer<?> printer = annotationFormatterFactory.getPrinter(key.getAnnotation(), key.getFieldType());
                        converter = new PrinterConverter(fieldType, printer, FormattingConversionService.this);
                        FormattingConversionService.this.cachedPrinters.put(key, converter);
                    }
                    return converter.convert(source, sourceType, targetType);
                }

                public String toString() {
                    return "@" + annotationType.getName() + " " + fieldType.getName() + " -> " + String.class.getName() + ": " + annotationFormatterFactory;
                }
            });
            this.addConverter(new ConditionalGenericConverter(){

                @Override
                public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                    return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, fieldType));
                }

                @Override
                public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                    return targetType.getAnnotation(annotationType) != null;
                }

                @Override
                public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
                    FieldFormatterKey key = new FieldFormatterKey(targetType.getAnnotation(annotationType), fieldType);
                    GenericConverter converter = (GenericConverter)FormattingConversionService.this.cachedParsers.get(key);
                    if (converter == null) {
                        Parser<?> printer = annotationFormatterFactory.getParser(key.getAnnotation(), key.getFieldType());
                        converter = new ParserConverter(fieldType, printer, FormattingConversionService.this);
                        FormattingConversionService.this.cachedParsers.put(key, converter);
                    }
                    return converter.convert(source, sourceType, targetType);
                }

                public String toString() {
                    return String.valueOf(String.class.getName()) + " -> @" + annotationType.getName() + " " + fieldType.getName() + ": " + annotationFormatterFactory;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FieldFormatterKey {
        private final Annotation annotation;
        private final Class<?> fieldType;

        public FieldFormatterKey(Annotation annotation, Class<?> fieldType) {
            this.annotation = annotation;
            this.fieldType = fieldType;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldFormatterKey)) {
                return false;
            }
            FieldFormatterKey key = (FieldFormatterKey)o;
            return this.annotation.equals(key.annotation) && this.fieldType.equals(key.fieldType);
        }

        public int hashCode() {
            return this.annotation.hashCode() + 29 * this.fieldType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParserConverter
    implements GenericConverter {
        private Class<?> fieldType;
        private Parser<?> parser;
        private ConversionService conversionService;

        public ParserConverter(Class<?> fieldType, Parser<?> parser, ConversionService conversionService) {
            this.fieldType = fieldType;
            this.parser = parser;
            this.conversionService = conversionService;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, this.fieldType));
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            Object result;
            String text = (String)source;
            if (text == null || text.length() == 0) {
                return null;
            }
            try {
                result = this.parser.parse(text, LocaleContextHolder.getLocale());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Unable to parse '" + text + "'", e);
            }
            TypeDescriptor resultType = TypeDescriptor.valueOf(result.getClass());
            if (!resultType.isAssignableTo(targetType)) {
                result = this.conversionService.convert(result, resultType, targetType);
            }
            return result;
        }

        public String toString() {
            return String.valueOf(String.class.getName()) + " -> " + this.fieldType.getName() + ": " + this.parser;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrinterConverter
    implements GenericConverter {
        private Class<?> fieldType;
        private TypeDescriptor printerObjectType;
        private Printer printer;
        private ConversionService conversionService;

        public PrinterConverter(Class<?> fieldType, Printer<?> printer, ConversionService conversionService) {
            this.fieldType = fieldType;
            this.printerObjectType = TypeDescriptor.valueOf(this.resolvePrinterObjectType(printer));
            this.printer = printer;
            this.conversionService = conversionService;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(this.fieldType, String.class));
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!sourceType.isAssignableTo(this.printerObjectType)) {
                source = this.conversionService.convert(source, sourceType, this.printerObjectType);
            }
            return source != null ? this.printer.print(source, LocaleContextHolder.getLocale()) : "";
        }

        private Class<?> resolvePrinterObjectType(Printer<?> printer) {
            return GenericTypeResolver.resolveTypeArgument(printer.getClass(), Printer.class);
        }

        public String toString() {
            return String.valueOf(this.fieldType.getName()) + " -> " + String.class.getName() + " : " + this.printer;
        }
    }
}

