/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projection
extends SpelNodeImpl {
    private final boolean nullSafe;

    public Projection(boolean nullSafe, int pos, SpelNodeImpl expression) {
        super(pos, expression);
        this.nullSafe = nullSafe;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue op = state.getActiveContextObject();
        Object operand = op.getValue();
        boolean operandIsArray = ObjectUtils.isArray(operand);
        if (operand instanceof Map) {
            Map mapdata = (Map)operand;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Map.Entry entry : mapdata.entrySet()) {
                try {
                    state.pushActiveContextObject(new TypedValue(entry, TypeDescriptor.valueOf(Map.Entry.class)));
                    result.add(this.children[0].getValueInternal(state).getValue());
                }
                finally {
                    state.popActiveContextObject();
                }
            }
            return new TypedValue(result, TypeDescriptor.valueOf(List.class));
        }
        if (operand instanceof List || operandIsArray) {
            ArrayList data = new ArrayList();
            Collection c = operand instanceof List ? (Collection)operand : (Collection)Arrays.asList(ObjectUtils.toObjectArray(operand));
            data.addAll(c);
            ArrayList<Object> result = new ArrayList<Object>();
            int idx = 0;
            Class arrayElementType = null;
            for (Object element : data) {
                try {
                    state.pushActiveContextObject(new TypedValue(element, TypeDescriptor.valueOf(op.getTypeDescriptor().getType())));
                    state.enterScope("index", idx);
                    Object value = this.children[0].getValueInternal(state).getValue();
                    if (value != null && operandIsArray) {
                        arrayElementType = this.determineCommonType(arrayElementType, value.getClass());
                    }
                    result.add(value);
                }
                finally {
                    state.exitScope();
                    state.popActiveContextObject();
                }
                ++idx;
            }
            if (operandIsArray) {
                if (arrayElementType == null) {
                    arrayElementType = Object.class;
                }
                Object resultArray = Array.newInstance(arrayElementType, result.size());
                System.arraycopy(result.toArray(), 0, resultArray, 0, result.size());
                return new TypedValue(resultArray, op.getTypeDescriptor());
            }
            return new TypedValue(result, op.getTypeDescriptor());
        }
        if (operand == null) {
            if (this.nullSafe) {
                return TypedValue.NULL;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, operand.getClass().getName());
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        return sb.append("![").append(this.getChild(0).toStringAST()).append("]").toString();
    }

    private Class<?> determineCommonType(Class<?> oldType, Class<?> newType) {
        Class<?>[] interfaces;
        if (oldType == null) {
            return newType;
        }
        if (oldType.isAssignableFrom(newType)) {
            return oldType;
        }
        Class<?> nextType = newType;
        while (nextType != Object.class) {
            if (nextType.isAssignableFrom(oldType)) {
                return nextType;
            }
            nextType = nextType.getSuperclass();
        }
        Class<?>[] classArray = interfaces = ClassUtils.getAllInterfacesForClass(newType);
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> nextInterface = classArray[n2];
            if (nextInterface.isAssignableFrom(oldType)) {
                return nextInterface;
            }
            ++n2;
        }
        return Object.class;
    }
}

