/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.UnsupportedEncodingException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URIUtil;
import org.mortbay.util.UrlEncoded;

public class HttpURI {
    private static byte[] __empty = new byte[0];
    private static final int START = 0;
    private static final int AUTH_OR_PATH = 1;
    private static final int SCHEME_OR_PATH = 2;
    private static final int AUTH = 4;
    private static final int PORT = 5;
    private static final int PATH = 6;
    private static final int PARAM = 7;
    private static final int QUERY = 8;
    boolean _partial = false;
    byte[] _raw = __empty;
    String _rawString;
    int _scheme;
    int _authority;
    int _host;
    int _port;
    int _path;
    int _param;
    int _query;
    int _fragment;
    int _end;

    public HttpURI() {
    }

    public HttpURI(boolean parsePartialAuth) {
        this._partial = parsePartialAuth;
    }

    public HttpURI(String raw) {
        this._rawString = raw;
        byte[] b = raw.getBytes();
        this.parse(b, 0, b.length);
    }

    public HttpURI(byte[] raw, int offset, int length) {
        this.parse2(raw, offset, length);
    }

    public void parse(String raw) {
        byte[] b = raw.getBytes();
        this.parse2(b, 0, b.length);
        this._rawString = raw;
    }

    public void parse(byte[] raw, int offset, int length) {
        this._rawString = null;
        this.parse2(raw, offset, length);
    }

    private void parse2(byte[] raw, int offset, int length) {
        this._raw = raw;
        int i = offset;
        int e = offset + length;
        int state = 0;
        int m = offset;
        this._end = offset + length;
        this._scheme = offset;
        this._authority = offset;
        this._host = offset;
        this._port = offset;
        this._path = offset;
        this._param = this._end;
        this._query = this._end;
        this._fragment = this._end;
        while (i < e) {
            int c = 0xFF & this._raw[i];
            int s = i++;
            switch (state) {
                case 0: {
                    m = s;
                    if (c == 47) {
                        state = 1;
                        break;
                    }
                    if (Character.isLetterOrDigit((char)c)) {
                        state = 2;
                        break;
                    }
                    if (c == 59) {
                        this._param = s;
                        state = 7;
                        break;
                    }
                    if (c == 63) {
                        this._param = s;
                        this._query = s;
                        state = 8;
                        break;
                    }
                    if (c == 35) {
                        this._param = s;
                        this._query = s;
                        this._fragment = s;
                        break;
                    }
                    throw new IllegalArgumentException(StringUtil.toString(this._raw, offset, length, URIUtil.__CHARSET));
                }
                case 1: {
                    if ((this._partial || this._scheme != this._authority) && c == 47) {
                        this._host = i;
                        this._port = this._end;
                        this._path = this._end;
                        state = 4;
                        break;
                    }
                    if (c == 59 || c == 63 || c == 35) {
                        --i;
                        state = 6;
                        break;
                    }
                    this._host = m;
                    this._port = m;
                    state = 6;
                    break;
                }
                case 2: {
                    if (length > 6 && c == 116) {
                        if (this._raw[offset + 3] == 58) {
                            s = offset + 3;
                            i = offset + 4;
                            c = 58;
                        } else if (this._raw[offset + 4] == 58) {
                            s = offset + 4;
                            i = offset + 5;
                            c = 58;
                        } else if (this._raw[offset + 5] == 58) {
                            s = offset + 5;
                            i = offset + 6;
                            c = 58;
                        }
                    }
                    if (c == 58) {
                        this._authority = m = i++;
                        this._path = m;
                        c = (char)(0xFF & this._raw[i]);
                        if (c == 47) {
                            state = 1;
                            break;
                        }
                        this._host = m;
                        this._port = m;
                        state = 6;
                        break;
                    }
                    if (c == 47) {
                        state = 6;
                        break;
                    }
                    if (c == 59) {
                        this._param = s;
                        state = 7;
                        break;
                    }
                    if (c == 63) {
                        this._param = s;
                        this._query = s;
                        state = 8;
                        break;
                    }
                    if (c != 35) break;
                    this._param = s;
                    this._query = s;
                    this._fragment = s;
                    break;
                }
                case 4: {
                    if (c == 47) {
                        this._port = this._path = (m = s);
                        state = 6;
                        break;
                    }
                    if (c == 64) {
                        this._host = i;
                        break;
                    }
                    if (c != 58) break;
                    this._port = s;
                    state = 5;
                    break;
                }
                case 5: {
                    if (c != 47) break;
                    this._path = m = s;
                    if (this._port <= this._authority) {
                        this._port = this._path;
                    }
                    state = 6;
                    break;
                }
                case 6: {
                    if (c == 59) {
                        this._param = s;
                        state = 7;
                        break;
                    }
                    if (c == 63) {
                        this._param = s;
                        this._query = s;
                        state = 8;
                        break;
                    }
                    if (c != 35) break;
                    this._param = s;
                    this._query = s;
                    this._fragment = s;
                    break;
                }
                case 7: {
                    if (c == 63) {
                        this._query = s;
                        state = 8;
                        break;
                    }
                    if (c != 35) break;
                    this._query = s;
                    this._fragment = s;
                    break;
                }
                case 8: {
                    if (c != 35) break;
                    this._fragment = s;
                }
            }
        }
    }

    public String getScheme() {
        if (this._scheme == this._authority) {
            return null;
        }
        int l = this._authority - this._scheme;
        if (l == 5 && this._raw[this._scheme] == 104 && this._raw[this._scheme + 1] == 116 && this._raw[this._scheme + 2] == 116 && this._raw[this._scheme + 3] == 112) {
            return "http";
        }
        if (l == 6 && this._raw[this._scheme] == 104 && this._raw[this._scheme + 1] == 116 && this._raw[this._scheme + 2] == 116 && this._raw[this._scheme + 3] == 112 && this._raw[this._scheme + 4] == 115) {
            return "https";
        }
        return StringUtil.toString(this._raw, this._scheme, this._authority - this._scheme - 1, URIUtil.__CHARSET);
    }

    public String getAuthority() {
        if (this._authority == this._path) {
            return null;
        }
        return StringUtil.toString(this._raw, this._authority, this._path - this._authority, URIUtil.__CHARSET);
    }

    public String getHost() {
        if (this._host == this._port) {
            return null;
        }
        return StringUtil.toString(this._raw, this._host, this._port - this._host, URIUtil.__CHARSET);
    }

    public int getPort() {
        if (this._port == this._path) {
            return -1;
        }
        return TypeUtil.parseInt(this._raw, this._port + 1, this._path - this._port - 1, 10);
    }

    public String getPath() {
        if (this._path == this._param) {
            return null;
        }
        return StringUtil.toString(this._raw, this._path, this._param - this._path, URIUtil.__CHARSET);
    }

    public String getDecodedPath() {
        if (this._path == this._param) {
            return null;
        }
        return URIUtil.decodePath(this._raw, this._path, this._param - this._path);
    }

    public String getPathAndParam() {
        if (this._path == this._query) {
            return null;
        }
        return StringUtil.toString(this._raw, this._path, this._query - this._path, URIUtil.__CHARSET);
    }

    public String getCompletePath() {
        if (this._path == this._end) {
            return null;
        }
        return StringUtil.toString(this._raw, this._path, this._end - this._path, URIUtil.__CHARSET);
    }

    public String getParam() {
        if (this._param == this._query) {
            return null;
        }
        return StringUtil.toString(this._raw, this._param + 1, this._query - this._param - 1, URIUtil.__CHARSET);
    }

    public String getQuery() {
        if (this._query == this._fragment) {
            return null;
        }
        return StringUtil.toString(this._raw, this._query + 1, this._fragment - this._query - 1, URIUtil.__CHARSET);
    }

    public String getQuery(String encoding) {
        if (this._query == this._fragment) {
            return null;
        }
        return StringUtil.toString(this._raw, this._query + 1, this._fragment - this._query - 1, encoding == null ? URIUtil.__CHARSET : encoding);
    }

    public String getFragment() {
        if (this._fragment == this._end) {
            return null;
        }
        return StringUtil.toString(this._raw, this._fragment + 1, this._end - this._fragment - 1, URIUtil.__CHARSET);
    }

    public void decodeQueryTo(MultiMap parameters, String encoding) throws UnsupportedEncodingException {
        if (this._query == this._fragment) {
            return;
        }
        if (encoding == null) {
            encoding = URIUtil.__CHARSET;
        }
        if (StringUtil.isUTF8(encoding)) {
            UrlEncoded.decodeUtf8To(this._raw, this._query + 1, this._fragment - this._query - 1, parameters);
        } else {
            UrlEncoded.decodeTo(StringUtil.toString(this._raw, this._query + 1, this._fragment - this._query - 1, encoding), parameters, encoding);
        }
    }

    public void clear() {
        this._end = 0;
        this._fragment = 0;
        this._query = 0;
        this._param = 0;
        this._path = 0;
        this._port = 0;
        this._host = 0;
        this._authority = 0;
        this._scheme = 0;
        this._raw = __empty;
        this._rawString = "";
    }

    public String toString() {
        if (this._rawString == null) {
            this._rawString = StringUtil.toString(this._raw, this._scheme, this._end - this._scheme, URIUtil.__CHARSET);
        }
        return this._rawString;
    }
}

