/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.jboss.resteasy.springmvc.ResteasyView;
import org.jboss.resteasy.springmvc.ResteasyWebHandlerTemplate;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyHandlerAdapter
extends ResteasyWebHandlerTemplate<ModelAndView>
implements HandlerAdapter {
    protected SynchronousDispatcher dispatcher;

    public ResteasyHandlerAdapter(SynchronousDispatcher dispatcher) {
        super(dispatcher.getProviderFactory());
        this.dispatcher = dispatcher;
    }

    @Override
    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    @Override
    public ModelAndView handle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler) throws Exception {
        ResteasyRequestWrapper requestWrapper = (ResteasyRequestWrapper)handler;
        return (ModelAndView)super.handle(requestWrapper, servletResponse);
    }

    @Override
    protected ModelAndView handle(ResteasyRequestWrapper requestWrapper, HttpResponse response) throws IOException {
        AsynchronousDispatcher asyncDispatcher;
        if (requestWrapper.getErrorCode() != null) {
            try {
                response.sendError(requestWrapper.getErrorCode(), requestWrapper.getErrorMessage());
            }
            catch (Exception e) {
                throw new UnhandledException(e);
            }
            return null;
        }
        HttpRequest request = requestWrapper.getHttpRequest();
        if (this.dispatcher instanceof AsynchronousDispatcher && (asyncDispatcher = (AsynchronousDispatcher)this.dispatcher).isAsynchrnousRequest(request)) {
            asyncDispatcher.invoke(request, response);
            return null;
        }
        return this.createModelAndView(requestWrapper, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView createModelAndView(ResteasyRequestWrapper requestWrapper, HttpResponse response) {
        HttpRequest request = requestWrapper.getHttpRequest();
        this.dispatcher.pushContextObjects(request, response);
        try {
            ServerResponse jaxrsResponse = null;
            try {
                jaxrsResponse = requestWrapper.getInvoker().invoke(request, response);
            }
            catch (Exception e) {
                this.dispatcher.handleInvokerException(request, response, e);
            }
            if (jaxrsResponse == null) {
                ModelAndView e = null;
                return e;
            }
            Object entity = jaxrsResponse.getEntity();
            if (entity instanceof ModelAndView) {
                jaxrsResponse.outputHeaders(response);
                ModelAndView modelAndView = (ModelAndView)entity;
                return modelAndView;
            }
            ModelAndView modelAndView = this.createModelAndView(jaxrsResponse);
            return modelAndView;
        }
        finally {
            this.dispatcher.clearContextData();
        }
    }

    protected ModelAndView createModelAndView(ServerResponse serverResponse) {
        View view = this.createView(serverResponse);
        return new ModelAndView(view, "responseInvoker", (Object)serverResponse);
    }

    protected View createView(ServerResponse serverResponse) {
        String contentType = serverResponse.resolveContentType().toString();
        return new ResteasyView(contentType, this.dispatcher);
    }

    @Override
    public boolean supports(Object handler) {
        return handler instanceof ResteasyRequestWrapper;
    }
}

