/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.Encoded;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.core.interception.InterceptorRegistry;
import org.jboss.resteasy.core.interception.InterceptorRegistryListener;
import org.jboss.resteasy.core.messagebody.ReaderUtility;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.ThreadLocalStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBodyParameterInjector
implements ValueInjector,
InterceptorRegistryListener {
    private static ThreadLocalStack<Object> bodyStack = new ThreadLocalStack();
    private Class type;
    private Type genericType;
    private Annotation[] annotations;
    private ReaderUtility readerUtility;
    private ResteasyProviderFactory factory;
    private Class declaringClass;
    private AccessibleObject target;

    public static void pushBody(Object o) {
        bodyStack.push(o);
    }

    public static Object getBody() {
        return bodyStack.get();
    }

    public static Object popBody() {
        return bodyStack.pop();
    }

    public static int bodyCount() {
        return bodyStack.size();
    }

    public static void clearBodies() {
        bodyStack.clear();
    }

    public MessageBodyParameterInjector(Class declaringClass, AccessibleObject target, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.factory = factory;
        this.declaringClass = declaringClass;
        this.target = target;
        this.type = type;
        this.genericType = genericType;
        this.annotations = annotations;
        MessageBodyReaderInterceptor[] interceptors = factory.getServerMessageBodyReaderInterceptorRegistry().bind(declaringClass, target);
        this.readerUtility = new ReaderUtilityImpl(factory, interceptors);
        factory.getServerMessageBodyReaderInterceptorRegistry().getListeners().add(this);
    }

    @Override
    public void registryUpdated(InterceptorRegistry registry) {
        MessageBodyReaderInterceptor[] interceptors = this.factory.getServerMessageBodyReaderInterceptorRegistry().bind(this.declaringClass, this.target);
        this.readerUtility = new ReaderUtilityImpl(this.factory, interceptors);
    }

    public boolean isFormData(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!mediaType.equals(MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            return false;
        }
        if (!MultivaluedMap.class.isAssignableFrom(type)) {
            return false;
        }
        if (genericType == null) {
            return true;
        }
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType params = (ParameterizedType)genericType;
        if (params.getActualTypeArguments().length != 2) {
            return false;
        }
        return params.getActualTypeArguments()[0].equals(String.class) && params.getActualTypeArguments()[1].equals(String.class);
    }

    @Override
    public Object inject(HttpRequest request, HttpResponse response) {
        try {
            Object o = MessageBodyParameterInjector.getBody();
            if (o != null) {
                return o;
            }
            MediaType mediaType = request.getHttpHeaders().getMediaType();
            if (mediaType == null) {
                throw new BadRequestException("content-type was null and expecting to extract a body into " + this.target);
            }
            if (this.isFormData(this.type, this.genericType, this.annotations, mediaType)) {
                boolean encoded;
                boolean bl = encoded = FindAnnotation.findAnnotation(this.annotations, Encoded.class) != null;
                if (encoded) {
                    return request.getFormParameters();
                }
                return request.getDecodedFormParameters();
            }
            return this.readerUtility.doRead(request, this.type, this.genericType, this.annotations, mediaType);
        }
        catch (IOException e) {
            throw new BadRequestException("Failure extracting body into " + this.target, e);
        }
    }

    @Override
    public Object inject() {
        throw new RuntimeException("Illegal to inject a message body into a singleton into " + this.target);
    }

    private class ReaderUtilityImpl
    extends ReaderUtility {
        private ReaderUtilityImpl(ResteasyProviderFactory factory, MessageBodyReaderInterceptor[] interceptors) {
            super(factory, interceptors);
        }

        public RuntimeException createReaderNotFound(Type genericType, MediaType mediaType) {
            return new BadRequestException("Could not find message body reader for type: " + genericType + " of content type: " + mediaType);
        }
    }
}

