/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.core.messagebody.ReaderUtility;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.spi.Link;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.util.GenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClientResponse<T>
extends ClientResponse<T> {
    protected ResteasyProviderFactory providerFactory;
    protected String attributeExceptionsTo;
    protected MultivaluedMap<String, String> headers;
    protected String alternateMediaType;
    protected Class<?> returnType;
    protected Type genericReturnType;
    protected Annotation[] annotations = new Annotation[0];
    protected int status;
    protected boolean wasReleased = false;
    protected boolean streamWasRead = false;
    protected Object unmarshaledEntity;
    protected MessageBodyReaderInterceptor[] messageBodyReaderInterceptors;
    protected Exception exception;
    protected boolean cacheInputStream;
    protected BaseClientResponseStreamFactory streamFactory;
    protected LinkHeader linkHeader;
    protected Link location;
    protected ClientExecutor executor;

    public BaseClientResponse(BaseClientResponseStreamFactory streamFactory, ClientExecutor executor) {
        this.streamFactory = streamFactory;
        this.executor = executor;
    }

    public BaseClientResponse(BaseClientResponseStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public void setMessageBodyReaderInterceptors(MessageBodyReaderInterceptor[] messageBodyReaderInterceptors) {
        this.messageBodyReaderInterceptors = messageBodyReaderInterceptors;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setReturnType(Class<T> returnType) {
        this.returnType = returnType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setGenericReturnType(Type genericReturnType) {
        this.genericReturnType = genericReturnType;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public String getAttributeExceptionsTo() {
        return this.attributeExceptionsTo;
    }

    public void setAttributeExceptionsTo(String attributeExceptionsTo) {
        this.attributeExceptionsTo = attributeExceptionsTo;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String getResponseHeader(String headerKey) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getFirst(headerKey);
    }

    @Override
    public LinkHeader getLinkHeader() {
        if (this.linkHeader != null) {
            return this.linkHeader;
        }
        this.linkHeader = new LinkHeader();
        if (!this.headers.containsKey("Link")) {
            return this.linkHeader;
        }
        List links = (List)this.headers.get("Link");
        LinkHeaderDelegate delegate = new LinkHeaderDelegate();
        for (String string : links) {
            LinkHeader tmp = delegate.fromString(string);
            this.linkHeader.getLinks().addAll(tmp.getLinks());
            this.linkHeader.getLinksByRelationship().putAll(tmp.getLinksByRelationship());
            this.linkHeader.getLinksByTitle().putAll(tmp.getLinksByTitle());
        }
        for (Link link : this.linkHeader.getLinks()) {
            link.setExecutor(this.executor);
        }
        return this.linkHeader;
    }

    @Override
    public Link getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (!this.headers.containsKey("Location")) {
            return null;
        }
        String header = this.headers.getFirst("Location");
        this.location = new Link();
        this.location.setHref(header);
        this.location.setExecutor(this.executor);
        return this.location;
    }

    @Override
    public Link getHeaderAsLink(String headerName) {
        String value = this.headers.getFirst(headerName);
        if (value == null) {
            return null;
        }
        String type = this.headers.getFirst(headerName + "-type");
        Link link = new Link();
        link.setHref(value);
        link.setType(type);
        link.setExecutor(this.executor);
        return link;
    }

    public void setAlternateMediaType(String alternateMediaType) {
        this.alternateMediaType = alternateMediaType;
    }

    public BaseClientResponseStreamFactory getStreamFactory() {
        return this.streamFactory;
    }

    public void setStreamFactory(BaseClientResponseStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Override
    public T getEntity() {
        if (this.returnType == null) {
            throw new RuntimeException("No type information to extract entity with, use other getEntity() methods");
        }
        return (T)this.getEntity(this.returnType, this.genericReturnType, this.annotations);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type) {
        return this.getEntity(type, null);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType) {
        return this.getEntity(type, genericType, this.getAnnotations(type, genericType));
    }

    private <T2> Annotation[] getAnnotations(Class<T2> type, Type genericType) {
        return this.returnType == type && this.genericReturnType == genericType ? this.annotations : null;
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType, Annotation[] anns) {
        if (this.exception != null) {
            throw new RuntimeException("Unable to unmarshall response for " + this.attributeExceptionsTo, this.exception);
        }
        if (this.unmarshaledEntity != null && !type.isInstance(this.unmarshaledEntity)) {
            throw new RuntimeException("The entity was already read, and it was of type " + this.unmarshaledEntity.getClass());
        }
        if (this.unmarshaledEntity == null) {
            if (this.status == 204) {
                return null;
            }
            this.unmarshaledEntity = this.readFrom(type, genericType, this.getMediaType(), anns);
            if (this.unmarshaledEntity != null && !InputStream.class.isInstance(this.unmarshaledEntity)) {
                this.releaseConnection();
            }
        }
        return (T2)this.unmarshaledEntity;
    }

    protected MediaType getMediaType() {
        String mediaType = this.getResponseHeader("Content-Type");
        if (mediaType == null) {
            mediaType = this.alternateMediaType;
        }
        return mediaType == null ? MediaType.WILDCARD_TYPE : MediaType.valueOf(mediaType);
    }

    protected <T2> Object readFrom(Class<T2> type, Type genericType, MediaType media, Annotation[] annotations) {
        try {
            ReaderUtility reader = new ReaderUtility(this.providerFactory, this.messageBodyReaderInterceptors){

                public RuntimeException createReaderNotFound(Type genericType, MediaType mediaType) {
                    return BaseClientResponse.this.createResponseFailure(String.format("Unable to find a MessageBodyReader of content-type %s and type %s", mediaType, genericType));
                }
            };
            return reader.doRead(type, genericType == null ? type : genericType, media, this.annotations, this.getHeaders(), this.streamFactory.getInputStream());
        }
        catch (IOException e) {
            String msg = "Failure reading from MessageBodyReader for conten-type: %s and type %s";
            throw this.createResponseFailure(String.format(msg, media.toString(), type.getName()), e);
        }
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType) {
        return this.getEntity(genericType.getType(), genericType.getGenericType());
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType, Annotation[] ann) {
        return this.getEntity(genericType.getType(), genericType.getGenericType(), ann);
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void checkFailureStatus() {
        if (this.status > 399 && this.status < 599) {
            throw this.createResponseFailure(String.format("Error status %d %s returned", this.status, this.getResponseStatus()));
        }
    }

    public ClientResponseFailure createResponseFailure(String message) {
        return this.createResponseFailure(message, null);
    }

    public ClientResponseFailure createResponseFailure(String message, Exception e) {
        this.setException(e);
        this.returnType = byte[].class;
        this.genericReturnType = null;
        this.annotations = null;
        return new ClientResponseFailure(message, e, this);
    }

    @Override
    public Response.Status getResponseStatus() {
        return Response.Status.fromStatusCode(this.getStatus());
    }

    public boolean wasReleased() {
        return this.wasReleased;
    }

    @Override
    public final void releaseConnection() {
        if (!this.wasReleased) {
            if (this.streamFactory != null) {
                this.streamFactory.performReleaseConnection();
            }
            this.wasReleased = true;
        }
    }

    protected final void finalize() throws Throwable {
        this.releaseConnection();
    }

    public static interface BaseClientResponseStreamFactory {
        public InputStream getInputStream() throws IOException;

        public void performReleaseConnection();
    }
}

