/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.FileInputStream;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.SMIMESigned;

public class ReadSignedMail {
    private static void verify(SMIMESigned sMIMESigned) throws Exception {
        CertStore certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        for (SignerInformation signerInformation : collection) {
            Collection<? extends Certificate> collection2;
            Iterator<? extends Certificate> iterator;
            X509Certificate x509Certificate;
            if (signerInformation.verify(x509Certificate = (X509Certificate)(iterator = (collection2 = certStore.getCertificates(signerInformation.getSID())).iterator()).next(), "BC")) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance(properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, new FileInputStream("signed.message"));
        if (mimeMessage.isMimeType("multipart/signed")) {
            SMIMESigned sMIMESigned = new SMIMESigned((MimeMultipart)mimeMessage.getContent());
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            } else if (object instanceof Multipart) {
                Multipart multipart = (Multipart)object;
                int n = multipart.getCount();
                for (int i = 0; i < n; ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    Object object2 = bodyPart.getContent();
                    System.out.println("Part " + i);
                    System.out.println("---------------------------");
                    if (object2 instanceof String) {
                        System.out.println((String)object2);
                        continue;
                    }
                    System.out.println("can't print...");
                }
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
        } else if (mimeMessage.isMimeType("application/pkcs7-mime") || mimeMessage.isMimeType("application/x-pkcs7-mime")) {
            SMIMESigned sMIMESigned = new SMIMESigned(mimeMessage);
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
        } else {
            System.err.println("Not a signed message!");
        }
    }
}

