/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class OutlookExtractor
extends AbstractPOIFSExtractor {
    private final MAPIMessage msg;

    public OutlookExtractor(POIFSFileSystem filesystem, ParseContext context) throws TikaException {
        super(context);
        try {
            this.msg = new MAPIMessage(filesystem);
        }
        catch (IOException e) {
            throw new TikaException("Failed to parse Outlook message", e);
        }
    }

    public void parse(XHTMLContentHandler xhtml, Metadata metadata) throws TikaException, SAXException, IOException {
        try {
            String from;
            String subject;
            block19: {
                this.msg.setReturnNullOnMissingChunk(true);
                subject = this.msg.getSubject();
                from = this.msg.getDisplayFrom();
                metadata.set("Author", from);
                metadata.set("Message-From", from);
                metadata.set("Message-To", this.msg.getDisplayTo());
                metadata.set("Message-Cc", this.msg.getDisplayCC());
                metadata.set("Message-Bcc", this.msg.getDisplayBCC());
                metadata.set("title", subject);
                metadata.set("subject", this.msg.getConversationTopic());
                try {
                    for (String recipientAddress : this.msg.getRecipientEmailAddressList()) {
                        if (recipientAddress == null) continue;
                        metadata.add("Message-Recipient-Address", recipientAddress);
                    }
                }
                catch (ChunkNotFoundException he) {
                    // empty catch block
                }
                if (this.msg.getMessageDate() != null) {
                    metadata.set("Edit-Time", this.msg.getMessageDate().getTime().toString());
                    metadata.set("Last-Save-Date", this.msg.getMessageDate().getTime().toString());
                } else {
                    try {
                        String[] headers = this.msg.getHeaders();
                        if (headers == null || headers.length <= 0) break block19;
                        for (String header : headers) {
                            if (!header.toLowerCase().startsWith("date:")) continue;
                            String date = header.substring(header.indexOf(58) + 1);
                            metadata.set("Edit-Time", date);
                            metadata.set("Last-Save-Date", date);
                            break;
                        }
                    }
                    catch (ChunkNotFoundException he) {
                        // empty catch block
                    }
                }
            }
            xhtml.element("h1", subject);
            xhtml.startElement("dl");
            this.header(xhtml, "From", from);
            this.header(xhtml, "To", this.msg.getDisplayTo());
            this.header(xhtml, "Cc", this.msg.getDisplayCC());
            this.header(xhtml, "Bcc", this.msg.getDisplayBCC());
            try {
                this.header(xhtml, "Recipients", this.msg.getRecipientEmailAddress());
            }
            catch (ChunkNotFoundException e) {
                // empty catch block
            }
            xhtml.endElement("dl");
            xhtml.element("p", this.msg.getTextBody());
            for (AttachmentChunks attachment : this.msg.getAttachmentFiles()) {
                xhtml.startElement("div", "class", "attachment-entry");
                String filename = null;
                if (attachment.attachLongFileName != null) {
                    filename = attachment.attachLongFileName.getValue();
                } else if (attachment.attachFileName != null) {
                    filename = attachment.attachFileName.getValue();
                }
                if (filename != null && filename.length() > 0) {
                    xhtml.element("h1", filename);
                }
                if (attachment.attachData != null) {
                    this.handleEmbeddedResource(TikaInputStream.get(attachment.attachData.getValue()), filename, null, xhtml, true);
                }
                if (attachment.attachmentDirectory != null) {
                    this.handleEmbededOfficeDoc(attachment.attachmentDirectory.getDirectory(), xhtml);
                }
                xhtml.endElement("div");
            }
        }
        catch (ChunkNotFoundException e) {
            throw new TikaException("POI MAPIMessage broken - didn't return null on missing chunk", e);
        }
    }

    private void header(XHTMLContentHandler xhtml, String key, String value) throws SAXException {
        if (value.length() > 0) {
            xhtml.element("dt", key);
            xhtml.element("dd", value);
        }
    }
}

