/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.simple;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.server.io.DefaultIOManager;
import org.apache.jackrabbit.server.io.IOHandler;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.PropertyHandler;
import org.apache.jackrabbit.server.io.PropertyManager;
import org.apache.jackrabbit.server.io.PropertyManagerImpl;
import org.apache.jackrabbit.webdav.simple.DefaultItemFilter;
import org.apache.jackrabbit.webdav.simple.ItemFilter;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.tika.detect.Detector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ResourceConfig {
    private static Logger log = LoggerFactory.getLogger(ResourceConfig.class);
    private final Detector detector;
    private ItemFilter itemFilter;
    private IOManager ioManager;
    private PropertyManager propManager;
    private String[] nodetypeNames = new String[0];
    private boolean collectionNames = false;

    public ResourceConfig(Detector detector) {
        this.detector = detector;
    }

    public void parse(URL configURL) {
        try {
            Element iohEl;
            ElementIterator iohElements;
            Object inst;
            InputStream in = configURL.openStream();
            Element config = DomUtil.parseDocument(in).getDocumentElement();
            if (config == null) {
                log.warn("Resource configuration: mandatory 'config' element is missing.");
                return;
            }
            Element el = DomUtil.getChildElement(config, "iomanager", null);
            if (el != null) {
                inst = this.buildClassFromConfig(el);
                if (inst != null && inst instanceof IOManager) {
                    this.ioManager = (IOManager)inst;
                    this.ioManager.setDetector(this.detector);
                    iohElements = DomUtil.getChildren(el, "iohandler", null);
                    while (iohElements.hasNext()) {
                        iohEl = iohElements.nextElement();
                        inst = this.buildClassFromConfig(iohEl);
                        if (inst != null && inst instanceof IOHandler) {
                            this.ioManager.addIOHandler((IOHandler)inst);
                            continue;
                        }
                        log.warn("Resource configuration: the handler is not a valid IOHandler.");
                    }
                } else {
                    log.warn("Resource configuration: 'iomanager' does not define a valid IOManager.");
                }
            } else {
                log.warn("Resource configuration: 'iomanager' element is missing.");
            }
            el = DomUtil.getChildElement(config, "propertymanager", null);
            if (el != null) {
                inst = this.buildClassFromConfig(el);
                if (inst != null && inst instanceof PropertyManager) {
                    this.propManager = (PropertyManager)inst;
                    iohElements = DomUtil.getChildren(el, "propertyhandler", null);
                    while (iohElements.hasNext()) {
                        iohEl = iohElements.nextElement();
                        inst = this.buildClassFromConfig(iohEl);
                        if (inst != null && inst instanceof PropertyHandler) {
                            this.propManager.addPropertyHandler((PropertyHandler)inst);
                            continue;
                        }
                        log.warn("Resource configuration: the handler is not a valid PropertyHandler.");
                    }
                } else {
                    log.warn("Resource configuration: 'propertymanager' does not define a valid PropertyManager.");
                }
            } else {
                log.debug("Resource configuration: 'propertymanager' element is missing.");
            }
            el = DomUtil.getChildElement(config, "collection", null);
            if (el != null) {
                this.nodetypeNames = this.parseNodeTypesEntry(el);
                this.collectionNames = true;
            } else {
                el = DomUtil.getChildElement(config, "noncollection", null);
                if (el != null) {
                    this.nodetypeNames = this.parseNodeTypesEntry(el);
                    this.collectionNames = false;
                }
            }
            el = DomUtil.getChildElement(config, "filter", null);
            if (el != null) {
                inst = this.buildClassFromConfig(el);
                if (inst != null && inst instanceof ItemFilter) {
                    this.itemFilter = (ItemFilter)inst;
                }
                if (this.itemFilter != null) {
                    this.itemFilter.setFilteredNodetypes(this.parseNodeTypesEntry(el));
                    this.parseNamespacesEntry(el);
                }
            } else {
                log.debug("Resource configuration: no 'filter' element specified.");
            }
            el = DomUtil.getChildElement(config, "mimetypeproperties", null);
            if (el != null) {
                log.warn("Ignoring deprecated mimetypeproperties settings: {}", configURL);
            }
        }
        catch (IOException e) {
            log.debug("Invalid resource configuration: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.warn("Failed to parse resource configuration: " + e.getMessage());
        }
        catch (SAXException e) {
            log.warn("Failed to parse resource configuration: " + e.getMessage());
        }
    }

    private Object buildClassFromConfig(Element parent) {
        Object instance = null;
        Element classElem = DomUtil.getChildElement(parent, "class", null);
        if (classElem != null) {
            try {
                String className = DomUtil.getAttribute(classElem, "name", null);
                if (className != null) {
                    Class<?> c = Class.forName(className);
                    instance = c.newInstance();
                } else {
                    log.error("Invalid configuration: missing 'class' element");
                }
            }
            catch (Exception e) {
                log.error("Error while create class instance: " + e.getMessage());
            }
        }
        return instance;
    }

    private void parseNamespacesEntry(Element parent) {
        Element namespaces = DomUtil.getChildElement(parent, "namespaces", null);
        if (namespaces != null) {
            ArrayList<String> l = new ArrayList<String>();
            ElementIterator it = DomUtil.getChildren(namespaces, "prefix", null);
            while (it.hasNext()) {
                Element e = it.nextElement();
                l.add(DomUtil.getText(e));
            }
            String[] prefixes = l.toArray(new String[l.size()]);
            l.clear();
            it = DomUtil.getChildren(namespaces, "uri", null);
            while (it.hasNext()) {
                Element e = it.nextElement();
                l.add(DomUtil.getText(e));
            }
            String[] uris = l.toArray(new String[l.size()]);
            this.itemFilter.setFilteredPrefixes(prefixes);
            this.itemFilter.setFilteredURIs(uris);
        }
    }

    private String[] parseNodeTypesEntry(Element parent) {
        String[] ntNames;
        Element nodetypes = DomUtil.getChildElement(parent, "nodetypes", null);
        if (nodetypes != null) {
            ArrayList<String> l = new ArrayList<String>();
            ElementIterator it = DomUtil.getChildren(nodetypes, "nodetype", null);
            while (it.hasNext()) {
                Element e = it.nextElement();
                l.add(DomUtil.getText(e));
            }
            ntNames = l.toArray(new String[l.size()]);
        } else {
            ntNames = new String[]{};
        }
        return ntNames;
    }

    public IOManager getIOManager() {
        if (this.ioManager == null) {
            log.debug("ResourceConfig: missing io-manager > building DefaultIOManager ");
            this.ioManager = new DefaultIOManager();
            this.ioManager.setDetector(this.detector);
        }
        return this.ioManager;
    }

    public PropertyManager getPropertyManager() {
        if (this.propManager == null) {
            log.debug("ResourceConfig: missing property-manager > building default.");
            this.propManager = PropertyManagerImpl.getDefaultManager();
        }
        return this.propManager;
    }

    public boolean isCollectionResource(Item item) {
        if (item.isNode()) {
            boolean isCollection = true;
            Node n = (Node)item;
            try {
                for (int i = 0; i < this.nodetypeNames.length && isCollection; ++i) {
                    isCollection = this.collectionNames ? n.isNodeType(this.nodetypeNames[i]) : !n.isNodeType(this.nodetypeNames[i]);
                }
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage());
            }
            return isCollection;
        }
        return false;
    }

    public ItemFilter getItemFilter() {
        if (this.itemFilter == null) {
            log.debug("ResourceConfig: missing resource filter > building DefaultItemFilter ");
            this.itemFilter = new DefaultItemFilter();
        }
        return this.itemFilter;
    }

    public Detector getDetector() {
        return this.detector;
    }
}

