/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildrenCollectorFilter
extends TraversingItemVisitor.Default {
    static final char WILDCARD_CHAR = '*';
    static final String OR = "|";
    private final Collection<Item> children;
    private final boolean collectNodes;
    private final boolean collectProperties;
    private final String namePattern;
    private final String[] nameGlobs;

    public ChildrenCollectorFilter(String namePattern, Collection<Item> children, boolean collectNodes, boolean collectProperties, int maxLevel) {
        super(false, maxLevel);
        this.namePattern = namePattern;
        this.nameGlobs = null;
        this.children = children;
        this.collectNodes = collectNodes;
        this.collectProperties = collectProperties;
    }

    public ChildrenCollectorFilter(String[] nameGlobs, Collection<Item> children, boolean collectNodes, boolean collectProperties, int maxLevel) {
        super(false, maxLevel);
        this.nameGlobs = nameGlobs;
        this.namePattern = null;
        this.children = children;
        this.collectNodes = collectNodes;
        this.collectProperties = collectProperties;
    }

    public static NodeIterator collectChildNodes(Node node, String namePattern) throws RepositoryException {
        ArrayList<Item> nodes = new ArrayList<Item>();
        node.accept(new ChildrenCollectorFilter(namePattern, nodes, true, false, 1));
        return new NodeIteratorAdapter(nodes);
    }

    public static NodeIterator collectChildNodes(Node node, String[] nameGlobs) throws RepositoryException {
        ArrayList<Item> nodes = new ArrayList<Item>();
        node.accept(new ChildrenCollectorFilter(nameGlobs, nodes, true, false, 1));
        return new NodeIteratorAdapter(nodes);
    }

    public static PropertyIterator collectProperties(Node node, String namePattern) throws RepositoryException {
        ArrayList<Item> properties = new ArrayList<Item>();
        node.accept(new ChildrenCollectorFilter(namePattern, properties, false, true, 1));
        return new PropertyIteratorAdapter(properties);
    }

    public static PropertyIterator collectProperties(Node node, String[] nameGlobs) throws RepositoryException {
        ArrayList<Item> properties = new ArrayList<Item>();
        node.accept(new ChildrenCollectorFilter(nameGlobs, properties, false, true, 1));
        return new PropertyIteratorAdapter(properties);
    }

    @Override
    protected void entering(Node node, int level) throws RepositoryException {
        if (level > 0 && this.collectNodes) {
            if (this.namePattern != null) {
                if (ChildrenCollectorFilter.matches(node.getName(), this.namePattern)) {
                    this.children.add(node);
                }
            } else if (ChildrenCollectorFilter.matches(node.getName(), this.nameGlobs)) {
                this.children.add(node);
            }
        }
    }

    @Override
    protected void entering(Property property, int level) throws RepositoryException {
        if (level > 0 && this.collectProperties) {
            if (this.namePattern != null) {
                if (ChildrenCollectorFilter.matches(property.getName(), this.namePattern)) {
                    this.children.add(property);
                }
            } else if (ChildrenCollectorFilter.matches(property.getName(), this.nameGlobs)) {
                this.children.add(property);
            }
        }
    }

    public static boolean matches(String name, String pattern) {
        StringTokenizer st = new StringTokenizer(pattern, OR, false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!ChildrenCollectorFilter.internalMatches(name, token, 0, 0)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(String name, String[] nameGlobs) {
        for (int i = 0; i < nameGlobs.length; ++i) {
            if (!ChildrenCollectorFilter.internalMatches(name, nameGlobs[i], 0, 0)) continue;
            return true;
        }
        return false;
    }

    private static boolean internalMatches(String s, String pattern, int sOff, int pOff) {
        int pLen = pattern.length();
        int sLen = s.length();
        while (true) {
            if (pOff >= pLen) {
                if (sOff >= sLen) {
                    return true;
                }
                return s.charAt(sOff) == '[';
            }
            if (sOff >= sLen && pattern.charAt(pOff) != '*') {
                return false;
            }
            if (pattern.charAt(pOff) == '*') {
                if (++pOff >= pLen) {
                    return true;
                }
                while (true) {
                    if (ChildrenCollectorFilter.internalMatches(s, pattern, sOff, pOff)) {
                        return true;
                    }
                    if (sOff >= sLen) {
                        return false;
                    }
                    ++sOff;
                }
            }
            if (pOff < pLen && sOff < sLen && pattern.charAt(pOff) != s.charAt(sOff)) {
                return false;
            }
            ++pOff;
            ++sOff;
        }
    }
}

