/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.persistence.CachingPersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.ItemStateReferenceCache;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateMerger;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.StateChangeDispatcher;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedItemStateManager
implements ItemStateManager,
ItemStateListener {
    private static Logger log = LoggerFactory.getLogger(SharedItemStateManager.class);
    private static final boolean VALIDATE_HIERARCHY = Boolean.getBoolean("org.apache.jackrabbit.core.state.validatehierarchy");
    private final ItemStateCache cache;
    private final PersistenceManager persistMgr;
    private final NodeTypeRegistry ntReg;
    private final boolean usesReferences;
    private boolean checkReferences = true;
    private final NodeId rootNodeId;
    private VirtualItemStateProvider[] virtualProviders = new VirtualItemStateProvider[0];
    private final transient StateChangeDispatcher dispatcher = new StateChangeDispatcher();
    private ISMLocking ismLocking;
    private UpdateEventChannel eventChannel;
    private final Set<ItemId> currentlyLoading = new HashSet<ItemId>();

    public SharedItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg, boolean usesReferences, ItemStateCacheFactory cacheFactory, ISMLocking locking) throws ItemStateException {
        this.cache = new ItemStateReferenceCache(cacheFactory);
        this.persistMgr = persistMgr;
        this.ntReg = ntReg;
        this.usesReferences = usesReferences;
        this.rootNodeId = rootNodeId;
        this.ismLocking = locking;
        if (!this.hasNonVirtualItemState(rootNodeId)) {
            this.createRootNodeState(rootNodeId, ntReg);
        }
        this.ensureActivitiesNode();
    }

    public void setCheckReferences(boolean checkReferences) {
        this.checkReferences = checkReferences;
    }

    public void setEventChannel(UpdateEventChannel eventChannel) {
        this.eventChannel = eventChannel;
    }

    public void setISMLocking(ISMLocking ismLocking) {
        if (ismLocking == null) {
            throw new NullPointerException();
        }
        this.ismLocking = ismLocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        for (VirtualItemStateProvider virtualProvider : this.virtualProviders) {
            if (!virtualProvider.isVirtualRoot(id)) continue;
            return virtualProvider.getItemState(id);
        }
        ISMLocking.ReadLock readLock = this.acquireReadLock(id);
        try {
            ItemState len$ = this.getNonVirtualItemState(id);
            return len$;
        }
        catch (NoSuchItemStateException e) {
        }
        finally {
            readLock.release();
        }
        for (VirtualItemStateProvider virtualProvider : this.virtualProviders) {
            if (!virtualProvider.hasItemState(id)) continue;
            return virtualProvider.getItemState(id);
        }
        throw new NoSuchItemStateException(id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasItemState(ItemId id) {
        ISMLocking.ReadLock readLock;
        for (VirtualItemStateProvider virtualProvider : this.virtualProviders) {
            if (!virtualProvider.isVirtualRoot(id)) continue;
            return true;
        }
        try {
            readLock = this.acquireReadLock(id);
        }
        catch (ItemStateException e) {
            return false;
        }
        try {
            boolean e;
            if (this.cache.isCached(id)) {
                e = true;
                return e;
            }
            if (this.hasNonVirtualItemState(id)) {
                e = true;
                return e;
            }
        }
        finally {
            readLock.release();
        }
        for (VirtualItemStateProvider virtualProvider : this.virtualProviders) {
            if (!virtualProvider.hasItemState(id)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
        ISMLocking.ReadLock readLock = this.acquireReadLock(id);
        try {
            NodeReferences nodeReferences = this.persistMgr.loadReferencesTo(id);
            return nodeReferences;
        }
        catch (NoSuchItemStateException e) {
        }
        finally {
            readLock.release();
        }
        for (VirtualItemStateProvider virtualProvider : this.virtualProviders) {
            try {
                return virtualProvider.getNodeReferences(id);
            }
            catch (NoSuchItemStateException e) {
            }
        }
        throw new NoSuchItemStateException(id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNodeReferences(NodeId id) {
        ISMLocking.ReadLock readLock;
        try {
            readLock = this.acquireReadLock(id);
        }
        catch (ItemStateException e) {
            return false;
        }
        try {
            if (this.persistMgr.existsReferencesTo(id)) {
                boolean e = true;
                readLock.release();
                return e;
            }
        }
        catch (ItemStateException e) {
            // empty catch block
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        VirtualItemStateProvider[] arr$ = this.virtualProviders;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            VirtualItemStateProvider virtualProvider = arr$[i$];
            if (virtualProvider.hasNodeReferences(id)) {
                return true;
            }
            ++i$;
        }
        return false;
    }

    public void stateCreated(ItemState created) {
        if (created.getContainer() == this) {
            this.cache.cache(created);
        }
        this.dispatcher.notifyStateCreated(created);
    }

    public void stateModified(ItemState modified) {
        this.dispatcher.notifyStateModified(modified);
    }

    public void stateDestroyed(ItemState destroyed) {
        if (destroyed.getContainer() == this) {
            this.cache.evict(destroyed.getId());
        }
        this.dispatcher.notifyStateDestroyed(destroyed);
    }

    public void stateDiscarded(ItemState discarded) {
        if (discarded.getContainer() == this) {
            this.cache.evict(discarded.getId());
        }
        this.dispatcher.notifyStateDiscarded(discarded);
    }

    public String toString() {
        return "SharedItemStateManager (" + super.toString() + ")\n" + "[referenceCache]\n" + this.cache;
    }

    public void dispose() {
        for (VirtualItemStateProvider virtualProvider : this.virtualProviders) {
            virtualProvider.removeListener(this);
        }
        this.virtualProviders = new VirtualItemStateProvider[0];
        this.cache.evictAll();
    }

    public void addVirtualItemStateProvider(VirtualItemStateProvider prov) {
        VirtualItemStateProvider[] provs = new VirtualItemStateProvider[this.virtualProviders.length + 1];
        System.arraycopy(this.virtualProviders, 0, provs, 0, this.virtualProviders.length);
        provs[this.virtualProviders.length] = prov;
        this.virtualProviders = provs;
        prov.addListener(this);
    }

    private void validateHierarchy(ChangeLog changeLog) throws ItemStateException, RepositoryException {
        this.validateDeleted(changeLog);
        this.validateAdded(changeLog);
        this.validateModified(changeLog);
    }

    private void validateDeleted(ChangeLog changeLog) throws ItemStateException {
        for (ItemState removedState : changeLog.deletedStates()) {
            boolean addedAndRemoved;
            if (!(removedState instanceof NodeState)) continue;
            NodeState removedNodeState = (NodeState)removedState;
            NodeId id = removedNodeState.getNodeId();
            NodeState overlayedState = (NodeState)removedState.getOverlayedState();
            if (overlayedState == null) {
                String message = "Unable to load persistent state for removed node " + id;
                overlayedState = (NodeState)this.getItemState(id);
                if (overlayedState == null) {
                    log.error(message);
                    throw new ItemStateException(message);
                }
            }
            if (addedAndRemoved = changeLog.has(removedNodeState.getId())) continue;
            NodeId oldParentId = overlayedState.getParentId();
            if (!changeLog.deleted(oldParentId) && !changeLog.isModified(oldParentId)) {
                String message = "Node with id " + id + " has been removed, but the parent node isn't part of the changelog " + oldParentId;
                log.error(message);
                throw new ItemStateException(message);
            }
            for (ChildNodeEntry entry : overlayedState.getChildNodeEntries()) {
                NodeId childId = entry.getId();
                if (changeLog.deleted(childId) || changeLog.isModified(childId)) continue;
                String message = "Node with id " + id + " has been removed, but the old child node isn't part of the changelog " + childId;
                log.error(message);
                throw new ItemStateException(message);
            }
        }
    }

    private void validateAdded(ChangeLog changeLog) throws ItemStateException {
        for (ItemState state : changeLog.addedStates()) {
            if (!(state instanceof NodeState)) continue;
            NodeState addedNodeState = (NodeState)state;
            NodeId id = addedNodeState.getNodeId();
            NodeId parentId = addedNodeState.getParentId();
            if (!changeLog.has(parentId)) {
                String message = "Node with id " + id + " has been added, but the parent node isn't part of the changelog " + parentId;
                log.error(message);
                throw new ItemStateException(message);
            }
            this.checkParent(changeLog, addedNodeState, parentId);
            for (ChildNodeEntry entry : addedNodeState.getChildNodeEntries()) {
                NodeId childId = entry.getId();
                if (changeLog.has(childId)) {
                    NodeState childState = (NodeState)changeLog.get(childId);
                    this.checkParent(changeLog, childState, id);
                    continue;
                }
                String message = "Node with id " + id + " has been added, but the child node isn't part of the changelog " + childId;
                log.error(message);
                throw new ItemStateException(message);
            }
        }
    }

    private void validateModified(ChangeLog changeLog) throws ItemStateException, RepositoryException {
        for (ItemState state : changeLog.modifiedStates()) {
            String message;
            NodeId childId;
            String message2;
            if (!(state instanceof NodeState)) continue;
            NodeState modifiedNodeState = (NodeState)state;
            NodeId id = modifiedNodeState.getNodeId();
            NodeState overlayedState = (NodeState)modifiedNodeState.getOverlayedState();
            if (overlayedState == null) {
                String message3 = "Unable to load persistent state for modified node " + id;
                log.error(message3);
                throw new ItemStateException(message3);
            }
            NodeId parentId = modifiedNodeState.getParentId();
            NodeId oldParentId = overlayedState.getParentId();
            if (parentId != null && changeLog.deleted(parentId)) {
                message2 = "Parent of node with id " + id + " has been deleted";
                log.error(message2);
                throw new ItemStateException(message2);
            }
            if (parentId != null && changeLog.has(parentId)) {
                this.checkParent(changeLog, modifiedNodeState, parentId);
            }
            if (!(parentId == null && oldParentId == null || parentId.equals(oldParentId))) {
                if (changeLog.has(parentId)) {
                    this.checkParent(changeLog, modifiedNodeState, parentId);
                } else if (!this.isShareable(modifiedNodeState)) {
                    message2 = "New parent of node " + id + " is not present in the changelog " + id;
                    log.error(message2);
                    throw new ItemStateException(message2);
                }
                if (!changeLog.isModified(oldParentId) && !changeLog.deleted(oldParentId)) {
                    message2 = "Node with id " + id + " has been move, but the original parent is not part of the changelog: " + oldParentId;
                    log.error(message2);
                    throw new ItemStateException(message2);
                }
            }
            for (ChildNodeEntry entry : modifiedNodeState.getChildNodeEntries()) {
                childId = entry.getId();
                if (changeLog.deleted(childId) && !changeLog.has(childId)) {
                    message = "Node with id " + id + " has a deleted childid: " + childId;
                    log.error(message);
                    throw new ItemStateException(message);
                }
                if (!changeLog.has(childId)) continue;
                NodeState childState = (NodeState)changeLog.get(childId);
                this.checkParent(changeLog, childState, id);
            }
            for (ChildNodeEntry entry : modifiedNodeState.getAddedChildNodeEntries()) {
                childId = entry.getId();
                if (changeLog.has(childId)) continue;
                message = "ChildId " + childId + " has been added to parent " + id + ", but is not present in the changelog";
                log.error(message);
                throw new ItemStateException(message);
            }
            for (ChildNodeEntry entry : modifiedNodeState.getRemovedChildNodeEntries()) {
                childId = entry.getId();
                if (changeLog.isModified(childId) || changeLog.deleted(childId)) continue;
                message = "Child node entry with id " + childId + " has been removed, but is not present in the changelog";
                log.error(message);
                throw new ItemStateException(message);
            }
        }
    }

    void checkParent(ChangeLog changeLog, NodeState childState, NodeId expectedParent) throws ItemStateException {
        NodeId childId;
        NodeId parentId = childState.getParentId();
        if (!parentId.equals(expectedParent)) {
            Set<NodeId> sharedSet = childState.getSharedSet();
            if (sharedSet.contains(expectedParent)) {
                return;
            }
            String message = "Child node has another parent id " + parentId + ", expected " + expectedParent;
            log.error(message);
            throw new ItemStateException(message);
        }
        if (!changeLog.has(parentId)) {
            String message = "Parent not part of changelog";
            log.error(message);
            throw new ItemStateException(message);
        }
        NodeState parent = (NodeState)changeLog.get(parentId);
        ChildNodeEntry childNodeEntry = parent.getChildNodeEntry(childId = childState.getNodeId());
        if (childNodeEntry == null) {
            String message = "Child not present in parent";
            log.error(message);
            throw new ItemStateException(message);
        }
    }

    private boolean isShareable(NodeState state) throws RepositoryException {
        Name primary = state.getNodeTypeName();
        Set<Name> mixins = state.getMixinTypeNames();
        if (mixins.contains(NameConstants.MIX_SHAREABLE)) {
            return true;
        }
        try {
            EffectiveNodeType type = this.ntReg.getEffectiveNodeType(primary, mixins);
            return type.includesNodeType(NameConstants.MIX_SHAREABLE);
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + state.getNodeId();
            log.debug(msg);
            throw new RepositoryException(msg, ntce);
        }
    }

    public Update beginUpdate(ChangeLog local, EventStateCollectionFactory factory, VirtualItemStateProvider virtualProvider) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        Update update = new Update(local, factory, virtualProvider);
        update.begin();
        return update;
    }

    public void update(ChangeLog local, EventStateCollectionFactory factory) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        this.beginUpdate(local, factory, null).end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalUpdate(ChangeLog external, EventStateCollection events) {
        boolean holdingWriteLock = false;
        ISMLocking.WriteLock wLock = null;
        try {
            wLock = this.acquireWriteLock(external);
            holdingWriteLock = true;
            this.doExternalUpdate(external);
        }
        catch (ItemStateException e) {
            String msg = "Unable to acquire write lock.";
            log.error(msg);
        }
        ISMLocking.ReadLock rLock = null;
        try {
            if (wLock != null) {
                rLock = wLock.downgrade();
                holdingWriteLock = false;
                events.dispatch();
            }
        }
        finally {
            if (holdingWriteLock) {
                if (wLock != null) {
                    wLock.release();
                }
            } else if (rLock != null) {
                rLock.release();
            }
        }
    }

    protected void doExternalUpdate(ChangeLog external) {
        if (this.persistMgr instanceof CachingPersistenceManager) {
            ((CachingPersistenceManager)((Object)this.persistMgr)).onExternalUpdate(external);
        }
        ChangeLog shared = new ChangeLog();
        for (ItemState state : external.modifiedStates()) {
            String msg;
            if ((state = this.cache.retrieve(state.getId())) == null) continue;
            try {
                ItemState currentState = this.loadItemState(state.getId());
                state.copy(currentState, true);
                shared.modified(state);
            }
            catch (NoSuchItemStateException e) {
                msg = "Unable to retrieve state: " + state.getId() + ", ignored.";
                log.info(msg);
                state.discard();
            }
            catch (ItemStateException e) {
                msg = "Unable to retrieve state: " + state.getId();
                log.warn(msg);
                state.discard();
            }
        }
        for (ItemState state : external.deletedStates()) {
            if ((state = this.cache.retrieve(state.getId())) == null) continue;
            shared.deleted(state);
        }
        shared.persisted();
    }

    public void addListener(ItemStateListener listener) {
        this.dispatcher.addListener(listener);
    }

    public void removeListener(ItemStateListener listener) {
        this.dispatcher.removeListener(listener);
    }

    private NodeState createInstance(NodeId id, Name nodeTypeName, NodeId parentId) {
        NodeState state = this.persistMgr.createNew(id);
        state.setNodeTypeName(nodeTypeName);
        state.setParentId(parentId);
        state.setStatus(4);
        state.setContainer(this);
        return state;
    }

    private NodeState createRootNodeState(NodeId rootNodeId, NodeTypeRegistry ntReg) throws ItemStateException {
        NodeState rootState = this.createInstance(rootNodeId, NameConstants.REP_ROOT, null);
        NodeState jcrSystemState = this.createInstance(RepositoryImpl.SYSTEM_ROOT_NODE_ID, NameConstants.REP_SYSTEM, rootNodeId);
        rootState.addPropertyName(NameConstants.JCR_PRIMARYTYPE);
        PropertyState prop = this.createInstance(NameConstants.JCR_PRIMARYTYPE, rootNodeId);
        prop.setValues(new InternalValue[]{InternalValue.create(NameConstants.REP_ROOT)});
        prop.setType(7);
        prop.setMultiValued(false);
        jcrSystemState.addPropertyName(NameConstants.JCR_PRIMARYTYPE);
        PropertyState primaryTypeProp = this.createInstance(NameConstants.JCR_PRIMARYTYPE, jcrSystemState.getNodeId());
        primaryTypeProp.setValues(new InternalValue[]{InternalValue.create(NameConstants.REP_SYSTEM)});
        primaryTypeProp.setType(7);
        primaryTypeProp.setMultiValued(false);
        rootState.addChildNodeEntry(NameConstants.JCR_SYSTEM, RepositoryImpl.SYSTEM_ROOT_NODE_ID);
        jcrSystemState.addChildNodeEntry(NameConstants.JCR_VERSIONSTORAGE, RepositoryImpl.VERSION_STORAGE_NODE_ID);
        jcrSystemState.addChildNodeEntry(NameConstants.JCR_ACTIVITIES, RepositoryImpl.ACTIVITIES_NODE_ID);
        jcrSystemState.addChildNodeEntry(NameConstants.JCR_NODETYPES, RepositoryImpl.NODETYPES_NODE_ID);
        ChangeLog changeLog = new ChangeLog();
        changeLog.added(rootState);
        changeLog.added(prop);
        changeLog.added(jcrSystemState);
        changeLog.added(primaryTypeProp);
        this.persistMgr.store(changeLog);
        changeLog.persisted();
        return rootState;
    }

    private void ensureActivitiesNode() throws ItemStateException {
        NodeState jcrSystemState = (NodeState)this.getNonVirtualItemState(RepositoryImpl.SYSTEM_ROOT_NODE_ID);
        if (!jcrSystemState.hasChildNodeEntry(RepositoryImpl.ACTIVITIES_NODE_ID)) {
            jcrSystemState.addChildNodeEntry(NameConstants.JCR_ACTIVITIES, RepositoryImpl.ACTIVITIES_NODE_ID);
            ChangeLog changeLog = new ChangeLog();
            changeLog.modified(jcrSystemState);
            this.persistMgr.store(changeLog);
            changeLog.persisted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemState getNonVirtualItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = this.cache.retrieve(id);
        if (state != null) {
            return state;
        }
        Object object = this;
        synchronized (object) {
            while (this.currentlyLoading.contains(id)) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new ItemStateException("Interrupted while waiting for " + id, e);
                }
            }
            state = this.cache.retrieve(id);
            if (state != null) {
                return state;
            }
            this.currentlyLoading.add(id);
        }
        try {
            state = this.loadItemState(id);
            state.setStatus(1);
            state.setContainer(this);
            this.cache.cache(state);
            object = state;
            return object;
        }
        finally {
            SharedItemStateManager sharedItemStateManager = this;
            synchronized (sharedItemStateManager) {
                this.currentlyLoading.remove(id);
                this.notifyAll();
            }
        }
    }

    protected boolean hasNonVirtualItemState(ItemId id) {
        if (this.cache.isCached(id)) {
            return true;
        }
        try {
            if (id.denotesNode()) {
                return this.persistMgr.exists((NodeId)id);
            }
            return this.persistMgr.exists((PropertyId)id);
        }
        catch (ItemStateException ise) {
            return false;
        }
    }

    private ItemState createInstance(ItemState other) {
        if (other.isNode()) {
            NodeState ns = (NodeState)other;
            return this.createInstance(ns.getNodeId(), ns.getNodeTypeName(), ns.getParentId());
        }
        PropertyState ps = (PropertyState)other;
        return this.createInstance(ps.getName(), ps.getParentId());
    }

    private PropertyState createInstance(Name propName, NodeId parentId) {
        PropertyState state = this.persistMgr.createNew(new PropertyId(parentId, propName));
        state.setStatus(4);
        state.setContainer(this);
        return state;
    }

    private ItemState loadItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = id.denotesNode() ? this.persistMgr.load((NodeId)id) : this.persistMgr.load((PropertyId)id);
        return state;
    }

    private ISMLocking.ReadLock acquireReadLock(ItemId id) throws ItemStateException {
        try {
            return this.ismLocking.acquireReadLock(id);
        }
        catch (InterruptedException e) {
            throw new ItemStateException("Interrupted while acquiring read lock");
        }
    }

    private ISMLocking.WriteLock acquireWriteLock(ChangeLog changeLog) throws ItemStateException {
        try {
            return this.ismLocking.acquireWriteLock(changeLog);
        }
        catch (InterruptedException e) {
            throw new ItemStateException("Interrupted while acquiring write lock");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Update
    implements org.apache.jackrabbit.core.cluster.Update {
        private final ChangeLog local;
        private final EventStateCollectionFactory factory;
        private final VirtualItemStateProvider virtualProvider;
        private ChangeLog shared;
        private ChangeLog[] virtualNodeReferences;
        private EventStateCollection events;
        private ISMLocking.WriteLock writeLock;
        private HashMap<String, Object> attributes;
        private long timestamp = System.currentTimeMillis();

        public Update(ChangeLog local, EventStateCollectionFactory factory, VirtualItemStateProvider virtualProvider) {
            this.local = local;
            this.factory = factory;
            this.virtualProvider = virtualProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void begin() throws ItemStateException, ReferentialIntegrityException {
            this.shared = new ChangeLog();
            this.virtualNodeReferences = new ChangeLog[SharedItemStateManager.this.virtualProviders.length];
            if (SharedItemStateManager.this.eventChannel != null) {
                SharedItemStateManager.this.eventChannel.updateCreated(this);
            }
            try {
                this.writeLock = SharedItemStateManager.this.acquireWriteLock(this.local);
            }
            finally {
                if (this.writeLock == null && SharedItemStateManager.this.eventChannel != null) {
                    SharedItemStateManager.this.eventChannel.updateCancelled(this);
                }
            }
            boolean succeeded = false;
            try {
                if (SharedItemStateManager.this.usesReferences) {
                    this.updateReferences();
                }
                if (SharedItemStateManager.this.checkReferences) {
                    this.checkReferentialIntegrity();
                }
                try {
                    this.events = this.factory.createEventStateCollection();
                }
                catch (RepositoryException e) {
                    String msg = "Unable to create event state collection.";
                    log.error(msg);
                    throw new ItemStateException(msg, e);
                }
                for (ItemState state : this.local.modifiedStates()) {
                    state.connect(SharedItemStateManager.this.getItemState(state.getId()));
                    if (state.isStale()) {
                        boolean merged = false;
                        if (state.isNode()) {
                            NodeStateMerger.MergeContext context = new NodeStateMerger.MergeContext(){

                                public boolean isAdded(ItemId id) {
                                    try {
                                        ItemState is = Update.this.local.get(id);
                                        return is != null && is.getStatus() == 4;
                                    }
                                    catch (NoSuchItemStateException e) {
                                        return false;
                                    }
                                }

                                public boolean isDeleted(ItemId id) {
                                    return Update.this.local.deleted(id);
                                }

                                public boolean isModified(ItemId id) {
                                    return Update.this.local.isModified(id);
                                }

                                public boolean allowsSameNameSiblings(NodeId id) {
                                    try {
                                        NodeState ns = this.getNodeState(id);
                                        NodeState parent = this.getNodeState(ns.getParentId());
                                        Name name = parent.getChildNodeEntry(id).getName();
                                        EffectiveNodeType ent = SharedItemStateManager.this.ntReg.getEffectiveNodeType(parent.getNodeTypeName(), parent.getMixinTypeNames());
                                        QNodeDefinition def = ent.getApplicableChildNodeDef(name, ns.getNodeTypeName(), SharedItemStateManager.this.ntReg);
                                        return def != null ? def.allowsSameNameSiblings() : false;
                                    }
                                    catch (Exception e) {
                                        log.warn("Unable to get node definition", e);
                                        return false;
                                    }
                                }

                                public EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
                                    return SharedItemStateManager.this.ntReg.getEffectiveNodeType(ntName);
                                }

                                protected NodeState getNodeState(NodeId id) throws ItemStateException {
                                    if (Update.this.local.has(id)) {
                                        return (NodeState)Update.this.local.get(id);
                                    }
                                    return (NodeState)SharedItemStateManager.this.getItemState(id);
                                }
                            };
                            merged = NodeStateMerger.merge((NodeState)state, context);
                        }
                        if (!merged) {
                            String msg = state.getId() + " has been modified externally";
                            log.debug(msg);
                            throw new StaleItemStateException(msg);
                        }
                    }
                    state.getOverlayedState().touch();
                    this.shared.modified(state.getOverlayedState());
                }
                for (ItemState state : this.local.deletedStates()) {
                    state.connect(SharedItemStateManager.this.getItemState(state.getId()));
                    if (state.isStale()) {
                        String msg = state.getId() + " has been modified externally";
                        log.debug(msg);
                        throw new StaleItemStateException(msg);
                    }
                    this.shared.deleted(state.getOverlayedState());
                }
                for (ItemState state : this.local.addedStates()) {
                    state.connect(SharedItemStateManager.this.createInstance(state));
                    this.shared.added(state.getOverlayedState());
                }
                for (NodeReferences refs : this.local.modifiedRefs()) {
                    boolean virtual = false;
                    NodeId id = refs.getTargetId();
                    for (int i = 0; i < SharedItemStateManager.this.virtualProviders.length; ++i) {
                        if (!SharedItemStateManager.this.virtualProviders[i].hasItemState(id)) continue;
                        ChangeLog virtualRefs = this.virtualNodeReferences[i];
                        if (virtualRefs == null) {
                            this.virtualNodeReferences[i] = virtualRefs = new ChangeLog();
                        }
                        virtualRefs.modified(refs);
                        virtual = true;
                        break;
                    }
                    if (virtual) continue;
                    this.shared.modified(refs);
                }
                this.checkAddedChildNodes();
                this.events.createEventStates(SharedItemStateManager.this.rootNodeId, this.local, SharedItemStateManager.this);
                if (SharedItemStateManager.this.eventChannel != null) {
                    SharedItemStateManager.this.eventChannel.updatePrepared(this);
                }
                if (VALIDATE_HIERARCHY) {
                    log.info("Validating change-set hierarchy");
                    try {
                        SharedItemStateManager.this.validateHierarchy(this.local);
                    }
                    catch (ItemStateException e) {
                        throw e;
                    }
                    catch (RepositoryException e) {
                        throw new ItemStateException("Invalid hierarchy", e);
                    }
                }
                this.local.push();
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() throws ItemStateException {
            boolean succeeded = false;
            try {
                long t0 = System.currentTimeMillis();
                SharedItemStateManager.this.persistMgr.store(this.shared);
                succeeded = true;
                if (log.isDebugEnabled()) {
                    long t1 = System.currentTimeMillis();
                    log.debug("persisting change log " + this.shared + " took " + (t1 - t0) + "ms");
                }
            }
            finally {
                if (!succeeded) {
                    this.cancel();
                }
            }
            ISMLocking.ReadLock readLock = null;
            try {
                readLock = this.writeLock.downgrade();
                this.writeLock = null;
                this.shared.persisted();
                for (int i = 0; i < this.virtualNodeReferences.length; ++i) {
                    ChangeLog virtualRefs = this.virtualNodeReferences[i];
                    if (virtualRefs == null) continue;
                    SharedItemStateManager.this.virtualProviders[i].setNodeReferences(virtualRefs);
                }
                this.events.dispatch();
                if (SharedItemStateManager.this.eventChannel != null) {
                    String path = this.events.getSession().getUserID() + "@" + this.events.getCommonPath();
                    SharedItemStateManager.this.eventChannel.updateCommitted(this, path);
                }
            }
            finally {
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                } else if (readLock != null) {
                    readLock.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try {
                if (SharedItemStateManager.this.eventChannel != null) {
                    SharedItemStateManager.this.eventChannel.updateCancelled(this);
                }
                this.local.disconnect();
                for (ItemState state : this.shared.modifiedStates()) {
                    try {
                        state.copy(SharedItemStateManager.this.loadItemState(state.getId()), false);
                    }
                    catch (ItemStateException e) {
                        state.discard();
                    }
                }
                for (ItemState state : this.shared.deletedStates()) {
                    try {
                        state.copy(SharedItemStateManager.this.loadItemState(state.getId()), false);
                    }
                    catch (ItemStateException e) {
                        state.discard();
                    }
                }
                for (ItemState state : this.shared.addedStates()) {
                    state.discard();
                }
            }
            finally {
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            }
        }

        @Override
        public void setAttribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(name, value);
        }

        @Override
        public Object getAttribute(String name) {
            if (this.attributes != null) {
                return this.attributes.get(name);
            }
            return null;
        }

        @Override
        public ChangeLog getChanges() {
            return this.local;
        }

        @Override
        public List<EventState> getEvents() {
            return this.events.getEvents();
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public String getUserData() {
            return this.events.getUserData();
        }

        private void updateReferences() throws ItemStateException {
            for (ItemState state : this.local.addedStates()) {
                if (state.isNode()) continue;
                this.addReferences((PropertyState)state);
            }
            for (ItemState state : this.local.modifiedStates()) {
                if (state.isNode()) continue;
                this.removeReferences(SharedItemStateManager.this.getItemState(state.getId()));
                this.addReferences((PropertyState)state);
            }
            for (ItemState state : this.local.deletedStates()) {
                this.removeReferences(state);
            }
        }

        private void addReferences(PropertyState property) throws NoSuchItemStateException, ItemStateException {
            if (property.getType() == 9) {
                InternalValue[] values = property.getValues();
                for (int i = 0; values != null && i < values.length; ++i) {
                    this.addReference(property.getPropertyId(), values[i].getNodeId());
                }
            }
        }

        private void addReference(PropertyId id, NodeId target) throws ItemStateException {
            if (this.virtualProvider == null || !this.virtualProvider.hasNodeReferences(target)) {
                NodeReferences refs = this.local.getReferencesTo(target);
                if (refs == null) {
                    refs = SharedItemStateManager.this.hasNodeReferences(target) ? SharedItemStateManager.this.getNodeReferences(target) : new NodeReferences(target);
                }
                refs.addReference(id);
                this.local.modified(refs);
            }
        }

        private void removeReferences(ItemState state) throws NoSuchItemStateException, ItemStateException {
            PropertyState property;
            if (!state.isNode() && (property = (PropertyState)state).getType() == 9) {
                InternalValue[] values = property.getValues();
                for (int i = 0; values != null && i < values.length; ++i) {
                    this.removeReference(property.getPropertyId(), values[i].getNodeId());
                }
            }
        }

        private void removeReference(PropertyId id, NodeId target) throws ItemStateException {
            if (this.virtualProvider == null || !this.virtualProvider.hasNodeReferences(target)) {
                NodeReferences refs = this.local.getReferencesTo(target);
                if (refs == null && SharedItemStateManager.this.hasNodeReferences(target)) {
                    refs = SharedItemStateManager.this.getNodeReferences(target);
                }
                if (refs != null) {
                    refs.removeReference(id);
                    this.local.modified(refs);
                }
            }
        }

        private void checkAddedChildNodes() throws ItemStateException {
            for (ItemState state : this.local.addedStates()) {
                this.checkAddedChildNode(state);
            }
            for (ItemState state : this.local.modifiedStates()) {
                this.checkAddedChildNode(state);
            }
        }

        private void checkAddedChildNode(ItemState state) throws ItemStateException {
            if (state.isNode()) {
                NodeState node = (NodeState)state;
                for (ChildNodeEntry child : node.getAddedChildNodeEntries()) {
                    NodeId id = child.getId();
                    if (this.local.get(id) != null || id.equals(RepositoryImpl.VERSION_STORAGE_NODE_ID) || id.equals(RepositoryImpl.ACTIVITIES_NODE_ID) || id.equals(RepositoryImpl.NODETYPES_NODE_ID) || SharedItemStateManager.this.cache.isCached(id) || SharedItemStateManager.this.persistMgr.exists(id)) continue;
                    String msg = "Trying to add a non-existing child node: " + id;
                    log.debug(msg);
                    throw new ItemStateException(msg);
                }
            }
        }

        private void checkReferentialIntegrity() throws ReferentialIntegrityException, ItemStateException {
            for (ItemState state : this.local.deletedStates()) {
                NodeState node;
                if (!state.isNode() || !this.isReferenceable(node = (NodeState)state)) continue;
                NodeId targetId = node.getNodeId();
                NodeReferences refs = this.local.getReferencesTo(targetId);
                if (refs == null) {
                    if (!SharedItemStateManager.this.hasNodeReferences(targetId)) continue;
                    refs = SharedItemStateManager.this.getNodeReferences(targetId);
                }
                if (!refs.hasReferences() || this.local.has(targetId)) continue;
                String msg = node.getNodeId() + ": the node cannot be removed because it is still being referenced.";
                log.debug(msg);
                throw new ReferentialIntegrityException(msg);
            }
            for (NodeReferences refs : this.local.modifiedRefs()) {
                NodeId id;
                if (!refs.hasReferences() || this.local.has(id = refs.getTargetId()) || SharedItemStateManager.this.hasItemState(id)) continue;
                String msg = "Target node " + id + " of REFERENCE property does not exist";
                log.debug(msg);
                throw new ReferentialIntegrityException(msg);
            }
        }

        private boolean isReferenceable(NodeState state) throws ItemStateException {
            Name primary = state.getNodeTypeName();
            Set<Name> mixins = state.getMixinTypeNames();
            if (mixins.contains(NameConstants.MIX_REFERENCEABLE) || mixins.contains(NameConstants.MIX_VERSIONABLE) || primary.equals(NameConstants.NT_RESOURCE)) {
                return true;
            }
            try {
                EffectiveNodeType type = SharedItemStateManager.this.ntReg.getEffectiveNodeType(primary, mixins);
                return type.includesNodeType(NameConstants.MIX_REFERENCEABLE);
            }
            catch (NodeTypeConflictException ntce) {
                String msg = "internal error: failed to build effective node type for node " + state.getNodeId();
                log.debug(msg);
                throw new ItemStateException(msg, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = "internal error: failed to build effective node type for node " + state.getNodeId();
                log.debug(msg);
                throw new ItemStateException(msg, nsnte);
            }
        }
    }
}

