/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AbstractACLTemplate;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.GlobPattern;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ACLTemplate
extends AbstractACLTemplate {
    private static Logger log = LoggerFactory.getLogger(ACLTemplate.class);
    static final Name P_NODE_PATH = NameConstants.REP_NODE_PATH;
    private final Principal principal;
    private final List<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
    private final String jcrNodePathName;
    private final String jcrGlobName;
    private final NameResolver resolver;

    ACLTemplate(Principal principal, String path, NamePathResolver resolver, ValueFactory vf) throws RepositoryException {
        this(principal, path, null, resolver, vf);
    }

    ACLTemplate(Principal principal, NodeImpl acNode) throws RepositoryException {
        this(principal, acNode.getPath(), acNode, (SessionImpl)acNode.getSession(), acNode.getSession().getValueFactory());
    }

    private ACLTemplate(Principal principal, String path, NodeImpl acNode, NamePathResolver resolver, ValueFactory vf) throws RepositoryException {
        super(path, vf);
        this.principal = principal;
        this.jcrNodePathName = resolver.getJCRName(P_NODE_PATH);
        this.jcrGlobName = resolver.getJCRName(P_GLOB);
        this.resolver = resolver;
        if (acNode != null && acNode.hasNode(N_POLICY)) {
            NodeImpl aclNode = acNode.getNode(N_POLICY);
            AccessControlManager acMgr = aclNode.getSession().getAccessControlManager();
            NodeIterator aceNodes = aclNode.getNodes();
            while (aceNodes.hasNext()) {
                NodeImpl aceNode = (NodeImpl)aceNodes.nextNode();
                if (aceNode.isNodeType(NT_REP_ACE)) {
                    boolean isAllow = aceNode.isNodeType(NT_REP_GRANT_ACE);
                    Value[] pValues = aceNode.getProperty(P_PRIVILEGES).getValues();
                    Privilege[] privileges = new Privilege[pValues.length];
                    for (int i = 0; i < pValues.length; ++i) {
                        privileges[i] = acMgr.privilegeFromName(pValues[i].getString());
                    }
                    HashMap<String, Value> restrictions = new HashMap<String, Value>(2);
                    PropertyImpl prop = aceNode.getProperty(P_NODE_PATH);
                    restrictions.put(prop.getName(), prop.getValue());
                    if (aceNode.hasProperty(P_GLOB)) {
                        prop = aceNode.getProperty(P_GLOB);
                        restrictions.put(prop.getName(), prop.getValue());
                    }
                    AccessControlEntry entry = this.createEntry(principal, privileges, isAllow, restrictions);
                    this.entries.add(entry);
                    continue;
                }
                log.warn("ACE must be of nodetype rep:ACE -> ignored child-node " + aceNode.getPath());
            }
        }
    }

    AccessControlEntry createEntry(Principal princ, Privilege[] privileges, boolean allow, Map<String, Value> restrictions) throws RepositoryException {
        Map<String, Value> rest = this.adjustRestrictions(restrictions);
        this.checkValidEntry(princ, privileges, allow, rest);
        return new Entry(princ, privileges, allow, rest);
    }

    private Map<String, Value> adjustRestrictions(Map<String, Value> restrictions) throws RepositoryException {
        Value v = restrictions.get(this.jcrNodePathName);
        if (v == null) {
            v = restrictions.get(P_NODE_PATH.toString());
        }
        if (v != null && v.getType() != 8) {
            v = this.valueFactory.createValue(v.getString(), 8);
            restrictions.put(this.jcrNodePathName, v);
        }
        if ((v = restrictions.get(this.jcrGlobName)) == null) {
            v = restrictions.get(P_GLOB.toString());
        }
        if (v != null && v.getType() != 1) {
            v = this.valueFactory.createValue(v.getString(), 1);
            restrictions.put(this.jcrGlobName, v);
        }
        return restrictions;
    }

    @Override
    protected void checkValidEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException {
        if (!((Object)this.principal).equals(principal)) {
            throw new AccessControlException("Invalid principal. Expected: " + principal);
        }
        Set<String> rNames = restrictions.keySet();
        if (!rNames.contains(this.jcrNodePathName) && !rNames.contains(P_NODE_PATH.toString())) {
            throw new AccessControlException("Missing mandatory restriction: " + this.jcrNodePathName);
        }
    }

    @Override
    protected List<AccessControlEntry> getEntries() {
        return this.entries;
    }

    @Override
    public String[] getRestrictionNames() {
        return new String[]{this.jcrNodePathName, this.jcrGlobName};
    }

    @Override
    public int getRestrictionType(String restrictionName) {
        if (this.jcrNodePathName.equals(restrictionName) || P_NODE_PATH.toString().equals(restrictionName)) {
            return 8;
        }
        if (this.jcrGlobName.equals(restrictionName) || P_GLOB.toString().equals(restrictionName)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException, RepositoryException {
        AccessControlEntry entry;
        if (restrictions == null || restrictions.isEmpty()) {
            log.debug("Restrictions missing. Using default: rep:nodePath = " + this.getPath() + "; rep:glob = null.");
            restrictions = Collections.singletonMap(this.jcrNodePathName, this.valueFactory.createValue(this.getPath(), 8));
        }
        if (this.entries.contains(entry = this.createEntry(principal, privileges, isAllow, restrictions))) {
            log.debug("Entry is already contained in policy -> no modification.");
            return false;
        }
        this.entries.add(0, entry);
        return true;
    }

    @Override
    public void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException, RepositoryException {
        if (!(ace instanceof Entry)) {
            throw new AccessControlException("Invalid AccessControlEntry implementation " + ace.getClass().getName() + ".");
        }
        if (!this.entries.remove(ace)) {
            throw new AccessControlException("Cannot remove AccessControlEntry " + ace);
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACLTemplate) {
            ACLTemplate acl = (ACLTemplate)obj;
            return ((Object)this.principal).equals(acl.principal) && this.path.equals(acl.path) && ((Object)this.entries).equals(acl.entries);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    extends AccessControlEntryImpl {
        private final String nodePath;
        private final GlobPattern pattern;

        private Entry(Principal principal, Privilege[] privileges, boolean allow, Map<String, Value> restrictions) throws AccessControlException, RepositoryException {
            super(principal, privileges, allow, restrictions);
            Map<Name, Value> rstr = this.getRestrictions();
            this.nodePath = rstr.get(P_NODE_PATH).getString();
            Value glob = rstr.get(AccessControlConstants.P_GLOB);
            this.pattern = glob != null ? GlobPattern.create(this.nodePath, glob.getString()) : GlobPattern.create(this.nodePath);
        }

        boolean matches(String jcrPath) throws RepositoryException {
            return this.pattern.matches(jcrPath);
        }

        boolean matches(Item item) throws RepositoryException {
            return this.pattern.matches(item);
        }

        boolean matchesNodePath(String jcrPath) {
            return this.nodePath.equals(jcrPath);
        }

        @Override
        protected NameResolver getResolver() {
            return ACLTemplate.this.resolver;
        }

        @Override
        protected ValueFactory getValueFactory() {
            return ACLTemplate.this.valueFactory;
        }
    }
}

