/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAuthContext
implements AuthContext {
    private static final Logger log = LoggerFactory.getLogger(LocalAuthContext.class);
    private Subject subject;
    private LoginModuleConfig config;
    private LoginModule module;
    private final CallbackHandler cbHandler;

    protected LocalAuthContext(LoginModuleConfig config, CallbackHandler cbHandler, Subject subject) {
        this.config = config;
        this.cbHandler = cbHandler;
        this.subject = null == subject ? new Subject() : subject;
    }

    public void login() throws LoginException {
        try {
            this.module = this.config.getLoginModule();
        }
        catch (ConfigurationException e) {
            throw new LoginException(e.getMessage());
        }
        HashMap state = new HashMap();
        HashMap<String, String> options = new HashMap<String, String>();
        Properties parameters = this.config.getParameters();
        Enumeration<?> names = parameters.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            options.put(name, parameters.getProperty(name));
        }
        this.module.initialize(this.subject, this.cbHandler, state, options);
        try {
            if (!this.module.login() || !this.module.commit()) {
                throw new FailedLoginException("LoginModule ignored Credentials");
            }
        }
        catch (LoginException le) {
            this.module.abort();
            throw le;
        }
        catch (Exception e) {
            this.module.abort();
            LoginException le = new LoginException("LoginModule could not perform authentication: " + e.getMessage());
            le.initCause(e);
            log.debug("Login failed to runtime-exception: ", e);
            throw le;
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void logout() throws LoginException {
        if (this.subject != null) {
            this.module.logout();
        }
    }
}

