/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.ArrayList;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.AbstractNodeType;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeImpl
extends AbstractNodeType
implements NodeType,
NodeTypeDefinition {
    private static Logger log = LoggerFactory.getLogger(NodeTypeImpl.class);
    private final EffectiveNodeType ent;
    private final NodeTypeManagerImpl ntMgr;
    private final ValueFactory valueFactory;
    private final DataStore store;

    NodeTypeImpl(EffectiveNodeType ent, QNodeTypeDefinition ntd, NodeTypeManagerImpl ntMgr, NamePathResolver resolver, ValueFactory valueFactory, DataStore store) {
        super(ntd, ntMgr, resolver);
        this.ent = ent;
        this.ntMgr = ntMgr;
        this.valueFactory = valueFactory;
        this.store = store;
    }

    public boolean isNodeType(Name nodeTypeName) {
        return this.ent.includesNodeType(nodeTypeName);
    }

    public boolean isDerivedFrom(Name nodeTypeName) {
        return !nodeTypeName.equals(this.ntd.getName()) && this.ent.includesNodeType(nodeTypeName);
    }

    public NodeDefinition[] getAutoCreatedNodeDefinitions() {
        QNodeDefinition[] cnda = this.ent.getAutoCreateNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i]);
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getAutoCreatedPropertyDefinitions() {
        QPropertyDefinition[] pda = this.ent.getAutoCreatePropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i]);
        }
        return propDefs;
    }

    public PropertyDefinition[] getMandatoryPropertyDefinitions() {
        QPropertyDefinition[] pda = this.ent.getMandatoryPropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i]);
        }
        return propDefs;
    }

    public NodeDefinition[] getMandatoryNodeDefinitions() {
        QNodeDefinition[] cnda = this.ent.getMandatoryNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i]);
        }
        return nodeDefs;
    }

    public Name getQName() {
        return this.ntd.getName();
    }

    public NodeType[] getInheritedSupertypes() {
        Name[] ntNames = this.ntd.getSupertypes();
        HashSet<Name> declared = new HashSet<Name>();
        for (Name ntName : ntNames) {
            declared.add(ntName);
        }
        ntNames = this.ent.getInheritedNodeTypes();
        ArrayList<NodeTypeImpl> inherited = new ArrayList<NodeTypeImpl>();
        for (Name ntName : ntNames) {
            if (declared.contains(ntName)) continue;
            try {
                inherited.add(this.ntMgr.getNodeType(ntName));
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", e);
                return new NodeType[0];
            }
        }
        return inherited.toArray(new NodeType[inherited.size()]);
    }

    public boolean hasOrderableChildNodes() {
        return this.ent.hasOrderableChildNodes();
    }

    public NodeType[] getSupertypes() {
        Name[] ntNames = this.ent.getInheritedNodeTypes();
        NodeType[] supertypes = new NodeType[ntNames.length];
        for (int i = 0; i < ntNames.length; ++i) {
            try {
                supertypes[i] = this.ntMgr.getNodeType(ntNames[i]);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", e);
                return new NodeType[0];
            }
        }
        return supertypes;
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        QNodeDefinition[] cnda = this.ent.getAllNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i]);
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        QPropertyDefinition[] pda = this.ent.getAllPropDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i]);
        }
        return propDefs;
    }

    public boolean canSetProperty(String propertyName, Value value) {
        if (value == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            InternalValue internalValue;
            QPropertyDefinition def;
            Name name = this.resolver.getQName(propertyName);
            try {
                def = this.ent.getApplicablePropertyDef(name, value.getType(), false);
            }
            catch (ConstraintViolationException cve) {
                def = this.ent.getApplicablePropertyDef(name, 0, false);
            }
            if (def.isProtected()) {
                return false;
            }
            if (def.isMultiple()) {
                return false;
            }
            int targetType = def.getRequiredType() != 0 && def.getRequiredType() != value.getType() ? def.getRequiredType() : value.getType();
            if (targetType != value.getType()) {
                Value targetVal = ValueHelper.convert(value, targetType, this.valueFactory);
                internalValue = InternalValue.create(targetVal, this.resolver, this.store);
            } else {
                internalValue = InternalValue.create(value, this.resolver, this.store);
            }
            EffectiveNodeType.checkSetPropertyValueConstraints(def, new InternalValue[]{internalValue});
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        if (values == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            QPropertyDefinition def;
            Name name = this.resolver.getQName(propertyName);
            int type = 0;
            for (Value value : values) {
                if (value == null) continue;
                if (type == 0) {
                    type = value.getType();
                    continue;
                }
                if (type == value.getType()) continue;
                return false;
            }
            try {
                def = this.ent.getApplicablePropertyDef(name, type, true);
            }
            catch (ConstraintViolationException cve) {
                def = this.ent.getApplicablePropertyDef(name, 0, true);
            }
            if (def.isProtected()) {
                return false;
            }
            if (!def.isMultiple()) {
                return false;
            }
            int targetType = def.getRequiredType() != 0 && def.getRequiredType() != type ? def.getRequiredType() : type;
            ArrayList<InternalValue> list = new ArrayList<InternalValue>();
            for (Value value : values) {
                InternalValue internalValue;
                if (value == null) continue;
                if (targetType != type) {
                    Value targetVal = ValueHelper.convert(value, targetType, this.valueFactory);
                    internalValue = InternalValue.create(targetVal, this.resolver, this.store);
                } else {
                    internalValue = InternalValue.create(value, this.resolver, this.store);
                }
                list.add(internalValue);
            }
            InternalValue[] internalValues = list.toArray(new InternalValue[list.size()]);
            EffectiveNodeType.checkSetPropertyValueConstraints(def, internalValues);
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName) {
        try {
            this.ent.checkAddNodeConstraints(this.resolver.getQName(childNodeName));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            this.ent.checkAddNodeConstraints(this.resolver.getQName(childNodeName), this.resolver.getQName(nodeTypeName), this.ntMgr.getNodeTypeRegistry());
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveItem(String itemName) {
        try {
            this.ent.checkRemoveItemConstraints(this.resolver.getQName(itemName));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveNode(String nodeName) {
        try {
            this.ent.checkRemoveNodeConstraints(this.resolver.getQName(nodeName));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveProperty(String propertyName) {
        try {
            this.ent.checkRemovePropertyConstraints(this.resolver.getQName(propertyName));
            return true;
        }
        catch (NameException be) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }
}

