/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectiveNodeType
implements Cloneable {
    private static Logger log = LoggerFactory.getLogger(EffectiveNodeType.class);
    private final TreeSet<Name> mergedNodeTypes = new TreeSet();
    private final TreeSet<Name> inheritedNodeTypes = new TreeSet();
    private final TreeSet<Name> allNodeTypes = new TreeSet();
    private final HashMap<Name, List<QItemDefinition>> namedItemDefs = new HashMap();
    private final ArrayList<QItemDefinition> unnamedItemDefs = new ArrayList();
    private boolean orderableChildNodes = false;
    private Name primaryItemName = null;

    private EffectiveNodeType() {
    }

    static EffectiveNodeType create(QNodeTypeDefinition ntd, EffectiveNodeTypeCache entCache, Map<Name, QNodeTypeDefinition> ntdCache) throws NodeTypeConflictException, NoSuchNodeTypeException {
        QPropertyDefinition[] pda;
        QNodeDefinition[] cnda;
        EffectiveNodeType ent = new EffectiveNodeType();
        Name ntName = ntd.getName();
        ent.mergedNodeTypes.add(ntName);
        ent.allNodeTypes.add(ntName);
        HashSet<QItemDefinition> itemDefs = new HashSet<QItemDefinition>();
        for (QNodeDefinition aCnda : cnda = ntd.getChildNodeDefs()) {
            if (itemDefs.contains(aCnda)) {
                String msg = aCnda.definesResidual() ? ntName + " contains ambiguous residual child node definitions" : ntName + " contains ambiguous definitions for child node named " + aCnda.getName();
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            itemDefs.add(aCnda);
            if (aCnda.definesResidual()) {
                ent.unnamedItemDefs.add(aCnda);
                continue;
            }
            Name name = aCnda.getName();
            List<QItemDefinition> defs = ent.namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<QItemDefinition>();
                ent.namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (QItemDefinition qItemDefinition : defs) {
                    if (!aCnda.isAutoCreated() && !qItemDefinition.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
            }
            defs.add(aCnda);
        }
        for (QPropertyDefinition aPda : pda = ntd.getPropertyDefs()) {
            if (itemDefs.contains(aPda)) {
                String msg = aPda.definesResidual() ? ntName + " contains ambiguous residual property definitions" : ntName + " contains ambiguous definitions for property named " + aPda.getName();
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            itemDefs.add(aPda);
            if (aPda.definesResidual()) {
                ent.unnamedItemDefs.add(aPda);
                continue;
            }
            Name name = aPda.getName();
            List<QItemDefinition> defs = ent.namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<QItemDefinition>();
                ent.namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (QItemDefinition def3 : defs) {
                    if (!aPda.isAutoCreated() && !def3.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
            }
            defs.add(aPda);
        }
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            EffectiveNodeType base = NodeTypeRegistry.getEffectiveNodeType(supertypes, entCache, ntdCache);
            ent.internalMerge(base, true);
        }
        if (ntd.hasOrderableChildNodes()) {
            ent.orderableChildNodes = true;
        } else {
            Name[] nta;
            for (Name aNta : nta = ent.getInheritedNodeTypes()) {
                QNodeTypeDefinition qNodeTypeDefinition = ntdCache.get(aNta);
                if (!qNodeTypeDefinition.hasOrderableChildNodes()) continue;
                ent.orderableChildNodes = true;
                break;
            }
        }
        if (ntd.getPrimaryItemName() != null) {
            ent.primaryItemName = ntd.getPrimaryItemName();
        } else {
            Name[] nta;
            for (Name aNta : nta = ent.getInheritedNodeTypes()) {
                QNodeTypeDefinition qNodeTypeDefinition = ntdCache.get(aNta);
                if (qNodeTypeDefinition.getPrimaryItemName() == null) continue;
                ent.primaryItemName = qNodeTypeDefinition.getPrimaryItemName();
                break;
            }
        }
        return ent;
    }

    static EffectiveNodeType create() {
        return new EffectiveNodeType();
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public Name getPrimaryItemName() {
        return this.primaryItemName;
    }

    public Name[] getMergedNodeTypes() {
        return this.mergedNodeTypes.toArray(new Name[this.mergedNodeTypes.size()]);
    }

    public Name[] getInheritedNodeTypes() {
        return this.inheritedNodeTypes.toArray(new Name[this.inheritedNodeTypes.size()]);
    }

    public Name[] getAllNodeTypes() {
        return this.allNodeTypes.toArray(new Name[this.allNodeTypes.size()]);
    }

    public QItemDefinition[] getAllItemDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        for (List<QItemDefinition> itemDefs : this.namedItemDefs.values()) {
            defs.addAll(itemDefs);
        }
        defs.addAll(this.unnamedItemDefs);
        if (defs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QItemDefinition[defs.size()]);
    }

    public QItemDefinition[] getNamedItemDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> itemDefs : this.namedItemDefs.values()) {
            defs.addAll(itemDefs);
        }
        if (defs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QItemDefinition[defs.size()]);
    }

    public QItemDefinition[] getUnnamedItemDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        return this.unnamedItemDefs.toArray(new QItemDefinition[this.unnamedItemDefs.size()]);
    }

    public boolean hasNamedItemDef(Name name) {
        return this.namedItemDefs.containsKey(name);
    }

    public QItemDefinition[] getNamedItemDefs(Name name) {
        List<QItemDefinition> defs = this.namedItemDefs.get(name);
        if (defs == null || defs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QItemDefinition[defs.size()]);
    }

    public QNodeDefinition[] getAllNodeDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QNodeDefinition> defs = new ArrayList<QNodeDefinition>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        for (QItemDefinition qItemDefinition : this.unnamedItemDefs) {
            if (!qItemDefinition.definesNode()) continue;
            defs.add((QNodeDefinition)qItemDefinition);
        }
        for (List list : this.namedItemDefs.values()) {
            for (QItemDefinition def : list) {
                if (!def.definesNode()) continue;
                defs.add((QNodeDefinition)def);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QNodeDefinition[] getNamedNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QNodeDefinition> defs = new ArrayList<QNodeDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition def : list) {
                if (!def.definesNode()) continue;
                defs.add((QNodeDefinition)def);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QNodeDefinition[] getNamedNodeDefs(Name name) {
        List<QItemDefinition> list = this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QNodeDefinition> defs = new ArrayList<QNodeDefinition>(list.size());
        for (QItemDefinition def : list) {
            if (!def.definesNode()) continue;
            defs.add((QNodeDefinition)def);
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QNodeDefinition[] getUnnamedNodeDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QNodeDefinition> defs = new ArrayList<QNodeDefinition>(this.unnamedItemDefs.size());
        for (QItemDefinition def : this.unnamedItemDefs) {
            if (!def.definesNode()) continue;
            defs.add((QNodeDefinition)def);
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QNodeDefinition[] getAutoCreateNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QNodeDefinition> defs = new ArrayList<QNodeDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition def : list) {
                if (!def.definesNode() || !def.isAutoCreated()) continue;
                defs.add((QNodeDefinition)def);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getAllPropDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QPropertyDefinition> defs = new ArrayList<QPropertyDefinition>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        for (QItemDefinition qItemDefinition : this.unnamedItemDefs) {
            if (qItemDefinition.definesNode()) continue;
            defs.add((QPropertyDefinition)qItemDefinition);
        }
        for (List list : this.namedItemDefs.values()) {
            for (QItemDefinition def : list) {
                if (def.definesNode()) continue;
                defs.add((QPropertyDefinition)def);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getNamedPropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QPropertyDefinition> defs = new ArrayList<QPropertyDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition def : list) {
                if (def.definesNode()) continue;
                defs.add((QPropertyDefinition)def);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getNamedPropDefs(Name name) {
        List<QItemDefinition> list = this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QPropertyDefinition> defs = new ArrayList<QPropertyDefinition>(list.size());
        for (QItemDefinition def : list) {
            if (def.definesNode()) continue;
            defs.add((QPropertyDefinition)def);
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getUnnamedPropDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QPropertyDefinition> defs = new ArrayList<QPropertyDefinition>(this.unnamedItemDefs.size());
        for (QItemDefinition def : this.unnamedItemDefs) {
            if (def.definesNode()) continue;
            defs.add((QPropertyDefinition)def);
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getAutoCreatePropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QPropertyDefinition> defs = new ArrayList<QPropertyDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition def : list) {
                if (def.definesNode() || !def.isAutoCreated()) continue;
                defs.add((QPropertyDefinition)def);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QPropertyDefinition[] getMandatoryPropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QPropertyDefinition> defs = new ArrayList<QPropertyDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition def : list) {
                if (def.definesNode() || !def.isMandatory()) continue;
                defs.add((QPropertyDefinition)def);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    public QNodeDefinition[] getMandatoryNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QNodeDefinition> defs = new ArrayList<QNodeDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition def : list) {
                if (!def.definesNode() || !def.isMandatory()) continue;
                defs.add((QNodeDefinition)def);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    public boolean includesNodeType(Name nodeTypeName) {
        return this.allNodeTypes.contains(nodeTypeName);
    }

    public boolean includesNodeTypes(Name[] nodeTypeNames) {
        return this.allNodeTypes.containsAll(Arrays.asList(nodeTypeNames));
    }

    public static void checkSetPropertyValueConstraints(QPropertyDefinition pd, InternalValue[] values) throws ConstraintViolationException, RepositoryException {
        if (!pd.isMultiple() && values != null && values.length > 1) {
            throw new ConstraintViolationException("the property is not multi-valued");
        }
        QValueConstraint[] constraints = pd.getValueConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        if (values != null && values.length > 0) {
            for (InternalValue value : values) {
                boolean satisfied = false;
                ConstraintViolationException cve = null;
                for (QValueConstraint constraint : constraints) {
                    try {
                        constraint.check(value);
                        satisfied = true;
                        break;
                    }
                    catch (ConstraintViolationException e) {
                        cve = e;
                    }
                }
                if (satisfied) continue;
                throw cve;
            }
        }
    }

    public void checkAddNodeConstraints(Name name) throws ConstraintViolationException {
        try {
            this.getApplicableChildNodeDef(name, null, null);
        }
        catch (NoSuchNodeTypeException nsnte) {
            String msg = "internal eror: inconsistent node type";
            log.debug(msg);
            throw new ConstraintViolationException(msg, nsnte);
        }
    }

    public void checkAddNodeConstraints(Name name, Name nodeTypeName, NodeTypeRegistry ntReg) throws ConstraintViolationException, NoSuchNodeTypeException {
        QNodeDefinition nd;
        if (nodeTypeName != null) {
            QNodeTypeDefinition ntDef = ntReg.getNodeTypeDef(nodeTypeName);
            if (ntDef.isAbstract()) {
                throw new ConstraintViolationException(nodeTypeName + " is abstract.");
            }
            if (ntDef.isMixin()) {
                throw new ConstraintViolationException(nodeTypeName + " is mixin.");
            }
        }
        if ((nd = this.getApplicableChildNodeDef(name, nodeTypeName, ntReg)).isProtected()) {
            throw new ConstraintViolationException(name + " is protected");
        }
        if (nd.isAutoCreated()) {
            throw new ConstraintViolationException(name + " is auto-created and can not be manually added");
        }
    }

    public QNodeDefinition getApplicableChildNodeDef(Name name, Name nodeTypeName, NodeTypeRegistry ntReg) throws NoSuchNodeTypeException, ConstraintViolationException {
        QNodeDefinition[] nda;
        QItemDefinition[] defs;
        EffectiveNodeType entTarget = nodeTypeName != null ? ntReg.getEffectiveNodeType(nodeTypeName) : null;
        for (QItemDefinition def : defs = this.getNamedItemDefs(name)) {
            if (!def.definesNode()) continue;
            QNodeDefinition nd = (QNodeDefinition)def;
            Name[] types = nd.getRequiredPrimaryTypes();
            if (!(entTarget != null && types != null ? entTarget.includesNodeTypes(types) : nd.getDefaultPrimaryType() != null)) continue;
            return nd;
        }
        for (QNodeDefinition nd : nda = this.getUnnamedNodeDefs()) {
            if (entTarget != null && nd.getRequiredPrimaryTypes() != null) {
                if (!entTarget.includesNodeTypes(nd.getRequiredPrimaryTypes())) continue;
                return nd;
            }
            if (nd.getDefaultPrimaryType() == null) continue;
            return nd;
        }
        throw new ConstraintViolationException("no matching child node definition found for " + name);
    }

    public QPropertyDefinition getApplicablePropertyDef(Name name, int type, boolean multiValued) throws ConstraintViolationException {
        QPropertyDefinition match = this.getMatchingPropDef(this.getNamedPropDefs(name), type, multiValued);
        if (match != null) {
            return match;
        }
        match = this.getMatchingPropDef(this.getUnnamedPropDefs(), type, multiValued);
        if (match != null) {
            return match;
        }
        throw new ConstraintViolationException("no matching property definition found for " + name);
    }

    public QPropertyDefinition getApplicablePropertyDef(Name name, int type) throws ConstraintViolationException {
        QPropertyDefinition match = this.getMatchingPropDef(this.getNamedPropDefs(name), type);
        if (match != null) {
            return match;
        }
        match = this.getMatchingPropDef(this.getUnnamedPropDefs(), type);
        if (match != null) {
            return match;
        }
        throw new ConstraintViolationException("no matching property definition found for " + name);
    }

    private QPropertyDefinition getMatchingPropDef(QPropertyDefinition[] defs, int type) {
        QPropertyDefinition match = null;
        for (QPropertyDefinition pd : defs) {
            int reqType = pd.getRequiredType();
            if (reqType != 0 && type != 0 && reqType != type) continue;
            if (match == null) {
                match = pd;
            } else if (match.getRequiredType() != pd.getRequiredType()) {
                if (match.getRequiredType() == 0) {
                    match = pd;
                }
            } else if (match.isMultiple() && !pd.isMultiple()) {
                match = pd;
            }
            if (match.getRequiredType() == 0 || match.isMultiple()) continue;
            return match;
        }
        return match;
    }

    private QPropertyDefinition getMatchingPropDef(QPropertyDefinition[] defs, int type, boolean multiValued) {
        QPropertyDefinition match = null;
        for (QPropertyDefinition pd : defs) {
            int reqType = pd.getRequiredType();
            if (reqType != 0 && type != 0 && reqType != type || multiValued != pd.isMultiple()) continue;
            if (pd.getRequiredType() != 0) {
                return pd;
            }
            if (match != null) continue;
            match = pd;
        }
        return match;
    }

    public void checkRemoveItemConstraints(Name name) throws ConstraintViolationException {
        QItemDefinition[] defs = this.getNamedItemDefs(name);
        if (defs != null) {
            for (QItemDefinition def : defs) {
                if (def.isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory item");
                }
                if (!def.isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected item");
            }
        }
    }

    public void checkRemoveNodeConstraints(Name name) throws ConstraintViolationException {
        QNodeDefinition[] defs = this.getNamedNodeDefs(name);
        if (defs != null) {
            for (QNodeDefinition def : defs) {
                if (def.isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory node");
                }
                if (!def.isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected node");
            }
        }
    }

    public void checkRemovePropertyConstraints(Name name) throws ConstraintViolationException {
        QPropertyDefinition[] defs = this.getNamedPropDefs(name);
        if (defs != null) {
            for (QPropertyDefinition def : defs) {
                if (def.isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory property");
                }
                if (!def.isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected property");
            }
        }
    }

    EffectiveNodeType merge(EffectiveNodeType other) throws NodeTypeConflictException {
        EffectiveNodeType copy = (EffectiveNodeType)this.clone();
        copy.internalMerge(other, false);
        return copy;
    }

    private synchronized void internalMerge(EffectiveNodeType other, boolean supertype) throws NodeTypeConflictException {
        String msg;
        QItemDefinition[] defs;
        Name[] nta = other.getAllNodeTypes();
        int includedCount = 0;
        for (Name aNta : nta) {
            if (!this.includesNodeType(aNta)) continue;
            log.debug("node type '" + aNta + "' is already contained.");
            ++includedCount;
        }
        if (includedCount == nta.length) {
            return;
        }
        for (QItemDefinition def : defs = other.getNamedItemDefs()) {
            if (this.includesNodeType(def.getDeclaringNodeType())) continue;
            Name name = def.getName();
            List<QItemDefinition> existingDefs = this.namedItemDefs.get(name);
            if (existingDefs != null) {
                if (existingDefs.size() > 0) {
                    for (QItemDefinition existingDef : existingDefs) {
                        if (def.isAutoCreated() || existingDef.isAutoCreated()) {
                            msg = "The item definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': name collision with auto-create definition";
                            log.debug(msg);
                            throw new NodeTypeConflictException(msg);
                        }
                        if (def.definesNode() != existingDef.definesNode()) continue;
                        if (!def.definesNode()) {
                            QPropertyDefinition pd = (QPropertyDefinition)def;
                            QPropertyDefinition epd = (QPropertyDefinition)existingDef;
                            if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple()) continue;
                            String msg2 = "The property definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': ambiguous property definition";
                            log.debug(msg2);
                            throw new NodeTypeConflictException(msg2);
                        }
                        msg = "The child node definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': ambiguous child node definition";
                        log.debug(msg);
                        throw new NodeTypeConflictException(msg);
                    }
                }
            } else {
                existingDefs = new ArrayList<QItemDefinition>();
                this.namedItemDefs.put(name, existingDefs);
            }
            existingDefs.add(def);
        }
        for (QItemDefinition def : defs = other.getUnnamedItemDefs()) {
            if (this.includesNodeType(def.getDeclaringNodeType())) continue;
            for (QItemDefinition existing : this.unnamedItemDefs) {
                if (def.definesNode() != existing.definesNode()) continue;
                if (!def.definesNode()) {
                    QPropertyDefinition pd = (QPropertyDefinition)def;
                    QPropertyDefinition epd = (QPropertyDefinition)existing;
                    if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple()) continue;
                    msg = "A property definition in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual property definition";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
                QNodeDefinition nd = (QNodeDefinition)def;
                QNodeDefinition end = (QNodeDefinition)existing;
                if (!Arrays.equals(nd.getRequiredPrimaryTypes(), end.getRequiredPrimaryTypes()) || !(nd.getDefaultPrimaryType() == null ? end.getDefaultPrimaryType() == null : nd.getDefaultPrimaryType().equals(end.getDefaultPrimaryType()))) continue;
                msg = "A child node definition in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual child node definition";
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            this.unnamedItemDefs.add(def);
        }
        this.allNodeTypes.addAll(Arrays.asList(nta));
        if (supertype) {
            nta = other.getMergedNodeTypes();
            this.inheritedNodeTypes.addAll(Arrays.asList(nta));
            nta = other.getInheritedNodeTypes();
            this.inheritedNodeTypes.addAll(Arrays.asList(nta));
        } else {
            nta = other.getMergedNodeTypes();
            this.mergedNodeTypes.addAll(Arrays.asList(nta));
            nta = other.getInheritedNodeTypes();
            this.inheritedNodeTypes.addAll(Arrays.asList(nta));
        }
        if (other.hasOrderableChildNodes()) {
            this.orderableChildNodes = true;
        }
        if (this.primaryItemName == null && other.getPrimaryItemName() != null) {
            this.primaryItemName = other.getPrimaryItemName();
        }
    }

    protected Object clone() {
        EffectiveNodeType clone = new EffectiveNodeType();
        clone.mergedNodeTypes.addAll(this.mergedNodeTypes);
        clone.inheritedNodeTypes.addAll(this.inheritedNodeTypes);
        clone.allNodeTypes.addAll(this.allNodeTypes);
        for (Name name : this.namedItemDefs.keySet()) {
            List<QItemDefinition> list = this.namedItemDefs.get(name);
            clone.namedItemDefs.put(name, new ArrayList<QItemDefinition>(list));
        }
        clone.unnamedItemDefs.addAll(this.unnamedItemDefs);
        clone.orderableChildNodes = this.orderableChildNodes;
        clone.primaryItemName = this.primaryItemName;
        return clone;
    }
}

