/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.typedescriptor;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.DeployItConfiguration;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptorFactory;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptorFactoryHelper;
import com.xebialabs.deployit.reflect.ConfigurationItemProxy;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="descriptorRepository")
public class ConfigurationItemTypeDescriptorRepository
implements ConfigurationItemDescriptorFactoryHelper {
    private Map<String, ConfigurationItemDescriptor> descriptorsByType = new HashMap<String, ConfigurationItemDescriptor>();
    private ListMultimap<String, ConfigurationItemDescriptor> descriptorsBySuperType = LinkedListMultimap.create();
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationItemTypeDescriptorRepository.class);

    @PostConstruct
    public void initialize() {
        new ConfigurationItemDescriptorFactory(this);
    }

    public Collection<ConfigurationItemDescriptor> getDescriptors() {
        return this.descriptorsByType.values();
    }

    public Map<String, ConfigurationItemDescriptor> getDescriptorMap() {
        return Collections.unmodifiableMap(this.descriptorsByType);
    }

    public ConfigurationItemDescriptor getDescriptorByType(String type) {
        return this.descriptorsByType.get(type);
    }

    public ConfigurationItemDescriptor getDescriptorByShortName(final String shortName) {
        return (ConfigurationItemDescriptor)CollectionUtils.find(this.descriptorsByType.values(), new Predicate(){

            @Override
            public boolean evaluate(Object descriptor) {
                return StringUtils.equalsIgnoreCase(((ConfigurationItemDescriptor)descriptor).getSimpleName(), shortName);
            }
        });
    }

    public ConfigurationItemDescriptor getDescriptorByClass(Class<?> clazz) {
        return this.descriptorsByType.get(clazz.getName());
    }

    public List<ConfigurationItemDescriptor> getDescriptorsBySuperType(String supertype) {
        return this.descriptorsBySuperType.get(supertype);
    }

    @Override
    @Deprecated
    public ConfigurationItemDescriptor getDescriptor(Serializable object) {
        return this.getDescriptorForObject(object);
    }

    public ConfigurationItemDescriptor getDescriptorForObject(Serializable object) {
        Serializable ci = object;
        if (ConfigurationItemProxy.class.isInstance(object)) {
            ci = ((ConfigurationItemProxy)((Object)object)).getBackingObject();
        }
        return this.descriptorsByType.get(ci.getClass().getName());
    }

    public void loadConfigurationItems(Collection<Class<?>> configurationItemTypes, List<String> loadingErrors) {
        this.descriptorsByType.clear();
        DeployItConfiguration config = DeployItConfiguration.getInstance();
        for (Class<?> type : Preconditions.checkNotNull(configurationItemTypes)) {
            if (type.isAnnotationPresent(ConfigurationItem.class)) {
                ConfigurationItemDescriptor descriptor = new ConfigurationItemDescriptor(type, config.getDefaults());
                for (String each : descriptor.getSuperClasses()) {
                    this.descriptorsBySuperType.put(each, descriptor);
                }
                for (String each : descriptor.getInterfaces()) {
                    this.descriptorsBySuperType.put(each, descriptor);
                }
                this.descriptorsBySuperType.put(descriptor.getType(), descriptor);
                this.descriptorsByType.put(descriptor.getType(), descriptor);
                continue;
            }
            String errorMessage = type.getName() + " does not have an @" + ConfigurationItem.class.getSimpleName() + " annotation. Ignoring it.";
            logger.error(errorMessage);
            loadingErrors.add(errorMessage);
        }
    }

    public boolean isSimilar(Serializable ci1, Serializable ci2) {
        return ConfigurationItemReflectionUtils.isSimilar(ci1, ci2);
    }

    public boolean isIdentical(Serializable ci1, Serializable ci2) {
        return ConfigurationItemReflectionUtils.isIdentical(ci1, ci2);
    }
}

