/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.typedescriptor;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationItemDescriptorRepositoryHolder {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationItemDescriptorRepositoryHolder.class);
    private static final AtomicReference<ConfigurationItemTypeDescriptorRepository> REFERENCE = new AtomicReference();

    @Autowired
    public ConfigurationItemDescriptorRepositoryHolder(ConfigurationItemTypeDescriptorRepository instance) {
        if (REFERENCE.getAndSet(Preconditions.checkNotNull(instance)) != null) {
            log.warn("Attempted to reinitialize holder with " + instance);
        }
    }

    public static ConfigurationItemTypeDescriptorRepository getDescriptorRepository() {
        return REFERENCE.get();
    }

    public static ConfigurationItemDescriptor getDescriptor(RepositoryObjectEntity entity) {
        return ConfigurationItemDescriptorRepositoryHolder.getDescriptor(entity.getConfigurationItemTypeName());
    }

    public static ConfigurationItemDescriptor getDescriptor(String configurationItemTypeName) {
        ConfigurationItemDescriptor descriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptorRepository().getDescriptorByType(configurationItemTypeName);
        if (descriptor == null) {
            throw new IllegalStateException("Cannot find a descriptor for configuration item type " + configurationItemTypeName);
        }
        return descriptor;
    }
}

