/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.translation;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.Change;
import java.io.Serializable;

public class DefaultChange<T extends Serializable>
implements Change<T> {
    private T oldCI;
    private T newCI;

    public static <C extends Serializable> DefaultChange<C> with(C oldCI, C newCI) {
        return new DefaultChange<C>(oldCI, newCI);
    }

    DefaultChange(T anOldCI, T aNewCI) {
        Preconditions.checkArgument(anOldCI != null || aNewCI != null, "Old and new revision cannot both be null");
        this.oldCI = anOldCI;
        this.newCI = aNewCI;
    }

    @Override
    public Class<T> getConfigurationItemClass() {
        return (this.oldCI == null ? this.newCI : this.oldCI).getClass();
    }

    @Override
    public boolean isAddition() {
        return this.oldCI == null;
    }

    @Override
    public boolean isModification() {
        return this.oldCI != null && this.newCI != null;
    }

    @Override
    public boolean isDeletion() {
        return this.newCI == null;
    }

    @Override
    public T getOldRevision() {
        return this.oldCI;
    }

    @Override
    public T getNewRevision() {
        return this.newCI;
    }
}

