/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.labelparser;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.labelparser.DeploymentTaskLabelParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InitialDeploymentTaskLabelParser
implements DeploymentTaskLabelParser {
    private Matcher matcher;
    private boolean matched;

    public InitialDeploymentTaskLabelParser(String taskLabel) {
        String packageRegex = "^" + Task.DEPLOYMENT_TASK_LABEL_FORMAT.replaceAll("%s", "(.*)") + "$";
        Pattern packagePattern = Pattern.compile(packageRegex);
        this.matcher = packagePattern.matcher(taskLabel);
        this.matched = this.matcher.find();
        Preconditions.checkArgument(this.matched, String.format("task label %s doesn't conform to the standard format %s", taskLabel, Task.DEPLOYMENT_TASK_LABEL_FORMAT));
    }

    @Override
    public String getApplication() {
        if (this.matched && this.matcher.groupCount() > 0) {
            return this.matcher.group(1);
        }
        return "";
    }

    @Override
    public String getVersion() {
        if (this.matched && this.matcher.groupCount() > 1) {
            return this.matcher.group(2);
        }
        return "";
    }

    @Override
    public String getEnvironment() {
        if (this.matched && this.matcher.groupCount() > 2) {
            return this.matcher.group(3);
        }
        return "";
    }
}

