/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.EventCallback;
import com.xebialabs.deployit.plugin.PojoConverter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ArchivingTaskRegistry
implements TaskRegistry {
    @Autowired
    private TaskArchive taskArchive;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private PojoConverter pojoConverter;
    private File recoveryFile;
    private int recoveryFileWritingIntervalMillis;
    private ConcurrentMap<String, Task> registry = new ConcurrentHashMap<String, Task>();
    private EventCallback<Task.TaskStateChangeEvent> taskArchivingCallback;
    private Timer recoveryFileWritingTimer;
    private static final Logger logger = LoggerFactory.getLogger(ArchivingTaskRegistry.class);

    @Required
    public void setRecoveryFile(File recoveryFile) {
        this.recoveryFile = recoveryFile;
    }

    @Required
    public void setRecoveryFileWritingIntervalMillis(int recoveryFileWritingIntervalMillis) {
        this.recoveryFileWritingIntervalMillis = recoveryFileWritingIntervalMillis;
    }

    @Override
    public String registerTask(Task task) {
        String uuid = UUID.randomUUID().toString();
        Preconditions.checkState(this.registry.putIfAbsent(uuid, task) == null);
        task.setId(uuid);
        return uuid;
    }

    @Override
    public Task getTask(String id) {
        Task task = (Task)this.registry.get(id);
        if (task == null) {
            logger.info("Retrieving task {} from archive.", (Object)id);
            task = this.taskArchive.getTask(id);
        }
        return task;
    }

    @Override
    public void cancelTask(String id) {
        Task task = this.getTask(id);
        if (task.isReadyForExecution()) {
            if (task.getState().equals((Object)Task.State.STOPPED)) {
                this.moveTaskFromRegistryToArchive(task);
            }
            task.cancel();
            this.registry.remove(id);
        }
    }

    @Override
    public Collection<Task> getTasks() {
        return this.registry.values();
    }

    @Override
    public Collection<Task> getAllArchivedTasks() {
        return this.taskArchive.getAllTasks();
    }

    @Override
    public List<Task> getIncompleteTasksForUser(String username) {
        ArrayList<Task> myTasks = Lists.newArrayList();
        for (Task eachTask : this.registry.values()) {
            if (!eachTask.getState().equals((Object)Task.State.STOPPED) && !eachTask.getState().equals((Object)Task.State.EXECUTING) || !eachTask.getOwner().equals(username)) continue;
            myTasks.add(eachTask);
        }
        return myTasks;
    }

    @Override
    public void updateTask(String id, Task task) {
        Preconditions.checkState(this.registry.put(id, task) != null);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.loadTasksFromRecoveryFile();
        this.registerTaskArchivingCallback();
        this.startRecoveryFileWritingTimer();
    }

    private void loadTasksFromRecoveryFile() {
        if (this.recoveryFile != null && this.recoveryFile.exists()) {
            try {
                ObjectInputStream recoveryIn = new ObjectInputStream(new FileInputStream(this.recoveryFile));
                Object recoveryObject = recoveryIn.readObject();
                if (recoveryObject instanceof Map) {
                    this.registry = (ConcurrentMap)recoveryObject;
                    this.postprocessTaskRegistryAfterRecovery();
                }
            }
            catch (Exception exc) {
                logger.error("Cannot load tasks from recovery file " + this.recoveryFile, exc);
            }
        }
    }

    private void postprocessTaskRegistryAfterRecovery() {
        Iterator tasksIterator = this.registry.values().iterator();
        if (tasksIterator.hasNext()) {
            logger.info("Recovering tasks after server crash");
            while (tasksIterator.hasNext()) {
                Task nextTask = (Task)tasksIterator.next();
                Task.State taskState = nextTask.getState();
                if (taskState == Task.State.PENDING) {
                    logger.info("Removing {} task {}", (Object)taskState, (Object)nextTask.getId());
                    tasksIterator.remove();
                    continue;
                }
                if (taskState == Task.State.DONE || taskState == Task.State.CANCELLED) {
                    logger.info("Moving {} task {} to task archive", (Object)taskState, (Object)nextTask.getId());
                    this.moveTaskFromRegistryToArchive(nextTask);
                    continue;
                }
                logger.info("Recovering {} task {}", (Object)taskState, (Object)nextTask.getId());
                this.setDepedenciesInTask(nextTask);
                nextTask.processAfterRecovery();
            }
            logger.info("Recovered tasks after server crash");
        }
    }

    private void setDepedenciesInTask(Task eachTask) {
        if (!eachTask.getState().equals((Object)Task.State.PENDING)) {
            DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(eachTask);
            directFieldAccessor.setPropertyValue("repositoryService", this.repositoryService);
            directFieldAccessor.setPropertyValue("pojoConverter", this.pojoConverter);
        }
    }

    @Override
    public void destroy() {
        this.stopRecoveryFileWritingTimer();
        this.writeRecoveryFile();
        this.deregisterTaskArchivingCallback();
    }

    private void registerTaskArchivingCallback() {
        this.taskArchivingCallback = new EventCallback<Task.TaskStateChangeEvent>(){

            @Override
            public void receive(Task.TaskStateChangeEvent event) {
                Task task = event.getTask();
                if (task.getState().equals((Object)Task.State.DONE)) {
                    ArchivingTaskRegistry.this.moveTaskFromRegistryToArchive(task);
                }
            }
        };
        EventBus.registerForEvent(Task.TaskStateChangeEvent.class, this.taskArchivingCallback);
    }

    private void deregisterTaskArchivingCallback() {
        EventBus.deregisterForEvent(Task.TaskStateChangeEvent.class, this.taskArchivingCallback);
    }

    private void startRecoveryFileWritingTimer() {
        this.recoveryFileWritingTimer = new Timer(ArchivingTaskRegistry.class.getName() + "#recoveryFileWritingTimer", true);
        this.recoveryFileWritingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ArchivingTaskRegistry.this.writeRecoveryFile();
            }
        }, this.recoveryFileWritingIntervalMillis, (long)this.recoveryFileWritingIntervalMillis);
    }

    private void stopRecoveryFileWritingTimer() {
        this.recoveryFileWritingTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeRecoveryFile() {
        if (this.recoveryFile != null) {
            try {
                ObjectOutputStream recoveryOut = new ObjectOutputStream(new FileOutputStream(this.recoveryFile));
                try {
                    recoveryOut.writeObject(this.registry);
                }
                finally {
                    recoveryOut.close();
                }
            }
            catch (IOException exc) {
                logger.error("Cannot write task registry recovery file", exc);
            }
        }
    }

    private void moveTaskFromRegistryToArchive(final Task task) {
        Preconditions.checkNotNull(task.getOwnerCredentials(), "Cannot archive task " + task.getId() + " because it has no owner");
        SecurityTemplate.executeAs(task.getOwnerCredentials(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                ArchivingTaskRegistry.this.taskArchive.archiveTask(task);
                ArchivingTaskRegistry.this.registry.remove(task.getId());
                return null;
            }
        });
    }
}

