/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.setup;

import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.setup.SetupContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class Setup {
    private static final int DEFAULT_HTTP_PORT = 4516;
    private static final int DEFAULT_HTTPS_PORT = 4517;
    private static final int DEFAULT_MAX_THREADS = 24;
    private static final int DEFAULT_MIN_THREADS = 3;
    private static final String FILE_URL_PREFIX = "file://";
    private static final String DEFAULT_JCR_REPOSITORY_PATH = "repository";
    private static final String DEFAULT_IMPORTABLE_PACKAGES_PATH = "importablePackages";
    private static final String EXITSETUP_KEYWORD = "exitsetup";

    public static void setup(DeployitOptions deployitOptions) {
        Setup setup = new Setup();
        if (deployitOptions.isReinitialize()) {
            setup.reinitialize();
        } else {
            setup.run();
        }
    }

    private void reinitialize() {
        SetupContext context = new SetupContext();
        this.useDefaultValues(context);
        context.save();
        this.initializeJcrRepository(context);
        this.deleteTaskRecoveryFile();
    }

    private void run() {
        System.out.println("\nWelcome to the Deployit setup.");
        System.out.println("You can always exit by typing 'exitsetup'.");
        System.out.println("To re-run this setup and make changes to the Deployit server configuration you can run deployit.cmd -setup on Windows or deployit.sh -setup on Unix.");
        SetupContext context = new SetupContext();
        boolean editingExistingConfiguration = false;
        if (context.exists() && this.askDoYouWantToEditTheExistingConfiguration(context)) {
            context.load();
            editingExistingConfiguration = true;
        }
        if (this.askDoYouWantToUseTheSimpleSetup()) {
            if (!editingExistingConfiguration) {
                this.useDefaultValues(context);
            } else {
                this.upgradeConfigurationWithDefaultValues(context);
            }
            this.askToInitializeJcr(context);
        } else {
            if (this.askToEnableSsl(context)) {
                if (this.askToGenerateKeys(context)) {
                    this.setDefaultKeyStoreSettings(context);
                } else {
                    this.askKeyStoreSettings(context);
                }
            }
            this.askHttpPortForJetty(context);
            this.askMinumAmountOfThreads(context);
            this.askMaximumAmountOfThreads(context);
            this.askJcrRepositoryPath(context);
            this.askToInitializeJcr(context);
            this.askImprotablePackagesPath(context);
        }
        if (this.reviewAndConfirm(context)) {
            System.out.println("Saving to " + context.getLocation());
            context.save();
            System.out.println("Configuration saved.");
            if (context.isGenerateKeyStore()) {
                this.generateKeyStore(context);
            }
            if (context.isInitializeJcrRepository()) {
                this.initializeJcrRepository(context);
            }
            System.out.println("You can now start your Deployit server by executing the command deployit.cmd on Windows or deployit.sh on Unix.");
            System.out.println("Note: If your Deployit server is running please restart it.");
            System.out.println("Finished setup.");
        } else {
            System.out.println("Aborting setup.");
        }
    }

    private void upgradeConfigurationWithDefaultValues(SetupContext context) {
        if (context.getMinThreads() == 0) {
            context.setMinThreads(3);
        }
        if (context.getMaxThreads() == 0) {
            context.setMaxThreads(24);
        }
        if (context.getImportablePackagesPath() == null) {
            context.setImportablePackagesPath(DEFAULT_IMPORTABLE_PACKAGES_PATH);
        }
    }

    private void askMinumAmountOfThreads(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the minimum number of threads the HTTP server should use (recommended: 3 per client, so 3 for single user usage)");
        int minThreads = 3;
        int suppliedMinThreads = context.getMinThreads() == 0 ? minThreads : context.getMinThreads();
        context.setMinThreads(this.getValidIntegerResponse(suppliedMinThreads));
    }

    private void askMaximumAmountOfThreads(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the maximum number of threads the HTTP server should use (recommended :3 per client, so 24 for 8 concurrent users)");
        int maxThreads = 24;
        int suppliedMaxThreads = context.getMaxThreads() == 0 ? maxThreads : context.getMaxThreads();
        context.setMaxThreads(this.getValidIntegerResponse(suppliedMaxThreads));
    }

    private void useDefaultValues(SetupContext context) {
        context.setJcrRepositoryPath(DEFAULT_JCR_REPOSITORY_PATH);
        context.setHttpPort(4516);
        context.setImportablePackagesPath(DEFAULT_IMPORTABLE_PACKAGES_PATH);
        context.setMinThreads(3);
        context.setMaxThreads(24);
    }

    private boolean askDoYouWantToUseTheSimpleSetup() {
        this.printEmptyLine();
        System.out.println("Do you want to use the simple setup?");
        System.out.println("Default values are used for all properties. To make changes to the default properties, please answer no.");
        System.out.println("Options are yes or no.");
        return this.getBooleanResponse(true);
    }

    private boolean askToEnableSsl(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like to enable SSL?");
        System.out.println("Options are yes or no.");
        boolean suppliedSsl = context.isNewConfiguration() || context.isSsl();
        context.setSsl(this.getBooleanResponse(suppliedSsl));
        return context.isSsl();
    }

    private boolean askToGenerateKeys(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like Deployit to generate a keystore with a self-signed certificate for you?");
        System.out.println("N.B.: Self-signed certificates do not work correctly with some versions of the Flash Player and some browsers!");
        System.out.println("Options are yes or no.");
        boolean suppliedGenerateKeys = context.isNewConfiguration() || context.isGenerateKeyStore();
        context.setGenerateKeyStore(this.getBooleanResponse(suppliedGenerateKeys));
        return context.isGenerateKeyStore();
    }

    private void setDefaultKeyStoreSettings(SetupContext context) {
        context.setKeyStorePath("keystore.jks");
        context.setKeyStorePassword("storesecret");
        context.setKeyStoreKeyPassword("keysecret");
    }

    private void askKeyStoreSettings(SetupContext context) {
        this.printEmptyLine();
        System.out.println("What is the path to the keystore?");
        String suppliedKeyStorePath = context.isNewConfiguration() ? "" : context.getKeyStorePath();
        context.setKeyStorePath(this.getStringResponse(suppliedKeyStorePath));
        this.printEmptyLine();
        System.out.println("What is the password to the keystore?");
        String suppliedKeyStorePassword = context.isNewConfiguration() ? "" : context.getKeyStorePassword();
        context.setKeyStorePassword(this.getStringResponse(suppliedKeyStorePassword));
        this.printEmptyLine();
        System.out.println("What is the password to the key in the keystore?");
        String suppliedKeyStoreKeyPassword = context.isNewConfiguration() ? "" : context.getKeyStoreKeyPassword();
        context.setKeyStoreKeyPassword(this.getStringResponse(suppliedKeyStoreKeyPassword));
    }

    private void askHttpPortForJetty(SetupContext context) {
        this.printEmptyLine();
        System.out.println("What http port number would you like the server to listen on?");
        int defaultPort = context.isSsl() ? 4517 : 4516;
        int suppliedPort = context.getHttpPort() == 0 ? defaultPort : context.getHttpPort();
        context.setHttpPort(this.getValidIntegerResponse(suppliedPort));
    }

    private void askImprotablePackagesPath(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Where would you like Deployit to import packages from?");
        String suppliedApplicationImportPath = context.getImportablePackagesPath() == null ? DEFAULT_IMPORTABLE_PACKAGES_PATH : context.getImportablePackagesPath();
        context.setImportablePackagesPath(this.getValidNotEmptyStringResponse(suppliedApplicationImportPath));
    }

    private boolean askDoYouWantToEditTheExistingConfiguration(SetupContext context) {
        this.printEmptyLine();
        System.out.println("An existing configuration was found. Do you want to edit it?");
        System.out.println("Options are yes or no. (selecting no will create an empty configuration)");
        boolean useOldConfig = this.getBooleanResponse(true);
        if (useOldConfig) {
            System.out.println("Editing the exisiting configuration.");
        } else {
            System.out.println("Starting configuration from scratch.");
        }
        return useOldConfig;
    }

    private void askJcrRepositoryPath(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Where would you like Deployit to store the JCR repository?");
        String path = context.getJcrRepositoryPath() == null ? DEFAULT_JCR_REPOSITORY_PATH : context.getJcrRepositoryPath();
        String userEnteredRepoPath = this.getValidNotEmptyStringResponse(path);
        context.setJcrRepositoryPath(this.convertAbsolutePathToFileUrlIfNeeded(userEnteredRepoPath));
    }

    private String convertAbsolutePathToFileUrlIfNeeded(String path) {
        if (path.startsWith("/")) {
            return FILE_URL_PREFIX + path;
        }
        return path;
    }

    private boolean askToInitializeJcr(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Do you want Deployit to initialize the JCR repository?");
        System.out.println("Options are yes or no.");
        if (context.isNewConfiguration()) {
            context.setInitializeJcrRepository(this.getBooleanResponse(true));
        } else {
            context.setInitializeJcrRepository(this.getBooleanResponse(false));
        }
        if (context.isInitializeJcrRepository()) {
            System.out.println("Deployit will initialize the JCR repository.");
        } else {
            System.out.println("Deployit will NOT initialize the JCR repository.");
        }
        return context.isInitializeJcrRepository();
    }

    private boolean reviewAndConfirm(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Do you agree with the following settings for Deployit and would you like to save them?");
        System.out.println("Changes will be saved in deployit.conf");
        System.out.println("\tSecurity is always enabled");
        System.out.println("\tSSL will be " + (context.isSsl() ? "enabled" : "disabled"));
        if (context.isSsl()) {
            if (context.isGenerateKeyStore()) {
                System.out.println("\tKeystore will be generated");
            } else {
                System.out.println("\tKeystore path is " + context.getKeyStorePath());
                System.out.println("\tKeystore password is " + context.getKeyStorePassword());
                System.out.println("\tKeystore key password is " + context.getKeyStoreKeyPassword());
            }
        }
        System.out.println("\tHTTP port is " + context.getHttpPort());
        System.out.println("\tHTTP server will use a minimum of " + context.getMinThreads() + " and a maximum of " + context.getMaxThreads() + " threads");
        try {
            System.out.println("\tJCR repository home is at " + this.resolveRepositoryHome(context).getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (context.isInitializeJcrRepository()) {
            System.out.println("\tJCR repository will be initialized.");
            System.out.println("\tTask recovery file will deleted");
        }
        System.out.println("\tApplication import location is " + context.getImportablePackagesPath());
        return this.getBooleanResponse(true);
    }

    private void generateKeyStore(SetupContext context) {
        String keyAlgorithm = "RSA";
        String keyStoreKeyAlias = "jetty";
        String dname = "CN=localhost,O=Deployit,C=NL";
        try {
            int exitValue;
            File keyStoreFile = new File(context.getKeyStorePath());
            if (keyStoreFile.exists()) {
                System.out.println("Existing keystore " + context.getKeyStorePath() + " deleted.");
                keyStoreFile.delete();
            }
            System.out.println("Generating keystore...");
            String[] keytoolArgs = new String[]{"keytool", "-genkey", "-keyalg", keyAlgorithm, "-keystore", context.getKeyStorePath(), "-storepass", context.getKeyStorePassword(), "-alias", keyStoreKeyAlias, "-keypass", context.getKeyStoreKeyPassword(), "-validity", "366", "-dname", dname};
            Process p = Runtime.getRuntime().exec(keytoolArgs);
            Thread outputThread = new Thread(new InputStreamToOutputStream(p.getInputStream(), System.out));
            outputThread.start();
            Thread errorThread = new Thread(new InputStreamToOutputStream(p.getErrorStream(), System.err));
            errorThread.start();
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException exc) {
                throw new IOException(exc.toString());
            }
            if (exitValue != 0) {
                throw new IOException("keytool exited with status code " + exitValue);
            }
            System.out.println("Keystore generated.");
        }
        catch (IOException exc) {
            System.err.println("WARNING: Could not generate keystore keystore.jks: " + exc.toString());
        }
    }

    private void initializeJcrRepository(SetupContext context) {
        Resource homeDirResource = this.resolveRepositoryHome(context);
        this.cleanUpAndReinitializeRepositoryHome(homeDirResource);
        JackrabbitRepositoryFactoryBean repositoryFactoryBean = new JackrabbitRepositoryFactoryBean();
        repositoryFactoryBean.setConfiguration(new ClassPathResource("jackrabbit-repository.xml"));
        repositoryFactoryBean.setHomeDir(homeDirResource);
        repositoryFactoryBean.setCreateHomeDirIfNotExists(true);
        try {
            repositoryFactoryBean.afterPropertiesSet();
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot initialize JCR repository", exc);
        }
        repositoryFactoryBean.configureJcrRepositoryForDeployit();
        repositoryFactoryBean.destroy();
        System.out.println("JCR repository initialized.");
        this.deleteTaskRecoveryFile();
    }

    private Resource resolveRepositoryHome(SetupContext context) {
        AbstractResource homeDirResource;
        if (context.getJcrRepositoryPath().startsWith(FILE_URL_PREFIX)) {
            try {
                homeDirResource = new UrlResource(context.getJcrRepositoryPath());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("JCR Repository path is a malformed url. " + context.getJcrRepositoryPath());
            }
        } else {
            homeDirResource = new FileSystemResource(context.getJcrRepositoryPath());
        }
        return homeDirResource;
    }

    private void cleanUpAndReinitializeRepositoryHome(Resource repoHomeResource) {
        File repositoryHome = null;
        try {
            repositoryHome = repoHomeResource.getFile();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Problem resolving absolute path to JCR repository at " + repositoryHome.getAbsolutePath(), e);
        }
        if (repositoryHome.exists()) {
            System.out.println("Deleting JCR repository at " + repositoryHome);
            try {
                FileUtils.deleteDirectory(repositoryHome);
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot delete JCR repository at " + repositoryHome, exc);
            }
        }
        System.out.println("Creating JCR repository at " + repositoryHome);
        repositoryHome.mkdirs();
    }

    private void deleteTaskRecoveryFile() {
        File taskRecoveryFile = new File("recovery.dat");
        if (taskRecoveryFile.exists()) {
            if (taskRecoveryFile.delete()) {
                System.out.println("Task recovery file deleted");
            } else {
                System.err.println("Couldn't delete the task recovery file");
            }
        }
    }

    private void printEmptyLine() {
        System.out.println("");
    }

    private String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String value = stdin.readLine().trim();
            if (EXITSETUP_KEYWORD.equals(value)) {
                System.out.println("Exiting setup.");
                System.exit(1);
            }
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getBooleanResponse(boolean defaultValue) {
        String prompt = this.determinePrompt(defaultValue ? "yes" : "no");
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if (value.equals("")) {
                return defaultValue;
            }
            if (value.equalsIgnoreCase("yes")) {
                return true;
            }
            if (value.equalsIgnoreCase("no")) {
                return false;
            }
            System.out.println("Illegal value specified, type yes or no.");
        }
    }

    private String getValidNotEmptyStringResponse(String defaultValue) {
        String prompt = this.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if (value.equals("") && defaultValue != null) {
                value = defaultValue;
            }
            if (!value.equals("")) {
                return value;
            }
            System.out.println("Value cannot be empty.");
        }
    }

    private String getStringResponse(String defaultValue) {
        String prompt = this.determinePrompt(defaultValue);
        System.out.print(prompt);
        String value = this.read();
        if (value.equals("")) {
            value = defaultValue;
        }
        return value;
    }

    private int getValidIntegerResponse(int defaultValueAsAnInt) {
        String defaultValue = Integer.toString(defaultValueAsAnInt);
        String prompt = this.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if (value.equals("")) {
                value = defaultValue;
            }
            try {
                int returnedValue = Integer.parseInt(value);
                if (returnedValue > 0) {
                    return returnedValue;
                }
                System.out.println("Illegal value specified. Number must be larger then 0.");
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Illegal value specified. Must be a number.");
                continue;
            }
            break;
        }
    }

    private String determinePrompt(String defaultValue) {
        String prompt = defaultValue != null ? "[" + defaultValue + "]: " : ": ";
        return prompt;
    }

    private static class InputStreamToOutputStream
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public InputStreamToOutputStream(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                IOUtils.copy(this.in, this.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

