/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.service.importer.DeployableArtifactImporter;
import com.xebialabs.deployit.service.importer.Imploder;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.PlaceHolderHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderTypeArtifactImporter
extends DeployableArtifactImporter {
    private String[] ALLOWED_FILE_EXTENSIONS = new String[]{".xml", ".properties", ".txt", ".cmd", ".bat", ".sh", ".sql"};
    private static final Logger logger = LoggerFactory.getLogger(FolderTypeArtifactImporter.class);

    @Override
    public boolean canHandle(ConfigurationItemDescriptor typeDescriptor) {
        return typeDescriptor.getSuperClasses().contains(Folder.class.getName());
    }

    @Override
    public void doImport(ArtifactEntity artifact, File artifactFolder) {
        byte[] bytes;
        try {
            bytes = Imploder.implode(artifactFolder);
        }
        catch (IOException e) {
            throw new ImporterException(e, "Could not import folder Artifact: %s", artifactFolder);
        }
        artifact.setData(new ByteArrayInputStream(bytes));
    }

    @Override
    protected Set<String> parsePlaceholders(ArtifactEntity artifact, File toBeParsedFile) {
        HashSet<String> placeholders = Sets.newHashSet();
        this.parseFilesForPlaceholderRecursively(artifact, toBeParsedFile, placeholders);
        return placeholders;
    }

    private void parseFilesForPlaceholderRecursively(ArtifactEntity artifact, File toBeParsedFile, Set<String> placeholders) {
        for (File eachFile : this.getValidFiles(toBeParsedFile)) {
            try {
                if (eachFile.isDirectory()) {
                    this.parseFilesForPlaceholderRecursively(artifact, eachFile, placeholders);
                    continue;
                }
                placeholders.addAll(PlaceHolderHelper.parsePlaceholders(new FileInputStream(eachFile)));
            }
            catch (FileNotFoundException e) {
                logger.warn("Problems found while parsing placeholders in file:" + eachFile.getName());
                logger.warn(e.getMessage());
            }
        }
    }

    protected File[] getValidFiles(File toBeParsedFile) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                int lastIndexOfDot = StringUtils.lastIndexOf(fileName, ".");
                if (lastIndexOfDot == -1) {
                    File f = new File(dir, fileName);
                    return f.isDirectory();
                }
                String extension = fileName.substring(lastIndexOfDot);
                return ArrayUtils.contains(FolderTypeArtifactImporter.this.ALLOWED_FILE_EXTENSIONS, extension);
            }
        };
        return toBeParsedFile.listFiles(filter);
    }
}

