/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import com.xebialabs.deployit.repository.ArchetypeEntity;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.EntityNodeReader;
import com.xebialabs.deployit.repository.EntityNodeWriter;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.VersionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrRepositoryService
implements RepositoryService {
    @Autowired
    private JcrTemplate jcrTemplate;
    @Autowired
    private ConfigurationItemTypeDescriptorRepository descriptorRepository;

    @Override
    public <T extends RepositoryObjectEntity> void create(T ... entities) {
        this.verifyEntitiesMeetCreationPreconditions((RepositoryObjectEntity[])entities);
        this.createEntities((RepositoryObjectEntity[])entities);
    }

    private void verifyEntitiesMeetCreationPreconditions(RepositoryObjectEntity[] entities) {
        for (int i = 0; i < entities.length; ++i) {
            RepositoryObjectEntity entity = entities[i];
            Preconditions.checkNotNull(entity, "entity at index %s is null.", i);
            Preconditions.checkNotNull(entity.getId(), "entity at index %s has null id.", i);
            if (!(entity instanceof ArtifactEntity)) continue;
            Preconditions.checkArgument(((ArtifactEntity)entity).containsData(), "Artifact %s should contain data", entity.getId());
        }
    }

    private <T extends RepositoryObjectEntity> void createEntities(final T[] entities) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                for (RepositoryObjectEntity entity : entities) {
                    JcrRepositoryService.this.createNode(session, entity);
                }
                session.save();
                return null;
            }
        });
    }

    private void createNode(Session session, RepositoryObjectEntity entity) throws RepositoryException {
        this.validateNodeStoredInCorrectPath(session, entity);
        Node node = session.getRootNode().addNode(entity.getId());
        int index = node.getIndex();
        if (index != 1) {
            node.remove();
            throw new ItemAlreadyExistsException("Repository entity with ID [%s] already exists", entity.getId());
        }
        this.setMixins(entity, node);
        new EntityNodeWriter<RepositoryObjectEntity>(session, entity, node).write();
    }

    @Override
    public <T extends RepositoryObjectEntity> T read(String id) {
        Preconditions.checkNotNull(id, "id is null");
        return this.read(id, false);
    }

    @Override
    public <T extends RepositoryObjectEntity> T readFully(String id) {
        Preconditions.checkNotNull(id, "id is null");
        return this.read(id, true);
    }

    private <T extends RepositoryObjectEntity> T read(final String id, final boolean fully) {
        Preconditions.checkNotNull(id, "id is null");
        return (T)((RepositoryObjectEntity)this.jcrTemplate.execute(new JcrCallback<T>(){

            @Override
            public T doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    return new EntityNodeReader(session, node, fully).getEntity();
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException(exc, "Repository entity [%s] not found", id);
                }
            }
        }));
    }

    @Override
    public <T extends RepositoryObjectEntity> void update(final T entity) {
        Preconditions.checkNotNull(entity, "entity is null");
        Preconditions.checkNotNull(entity.getId(), "id is null");
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(entity.getId()));
                    JcrRepositoryService.this.checkpoint(session, node);
                    new EntityNodeWriter<RepositoryObjectEntity>(session, entity, node).write();
                    session.save();
                    return null;
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Repository entity [%s] not found", entity.getId());
                }
            }
        });
    }

    @Override
    public boolean delete(final String id) {
        Preconditions.checkNotNull(id, "id is null");
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    boolean isArchetype = JcrRepositoryService.this.isAnArchetype(node);
                    JcrRepositoryService.this.checkpoint(session, node);
                    try {
                        node.remove();
                        session.save();
                    }
                    catch (ReferentialIntegrityException integrityException) {
                        if (isArchetype) {
                            throw new ItemInUseException("Can't delete archetype [%s] which is in use by any configuration items", id);
                        }
                        throw new ItemInUseException(integrityException, "ConfigurationItem with id [%s] is still referenced, cannot be deleted.", id);
                    }
                }
                catch (PathNotFoundException ignored) {
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public List<String> list(SearchParameters parameters) {
        Preconditions.checkNotNull(parameters);
        List entities = this.listEntities(parameters);
        ArrayList<String> entityIds = Lists.newArrayList();
        for (RepositoryObjectEntity each : entities) {
            entityIds.add(each.getId());
        }
        return entityIds;
    }

    @Override
    public <T extends RepositoryObjectEntity> List<T> listEntities(final SearchParameters parameters) {
        Preconditions.checkNotNull(parameters, "parameters is null");
        return (List)this.jcrTemplate.execute(new JcrCallback<List<T>>(){

            @Override
            public List<T> doInJcr(Session session) throws IOException, RepositoryException {
                Query query = new SearchQueryBuilder(JcrRepositoryService.this.descriptorRepository, parameters).build(session);
                QueryResult queryResult = query.execute();
                LinkedHashMap entities = new LinkedHashMap();
                RowIterator iterator = queryResult.getRows();
                while (iterator.hasNext()) {
                    try {
                        Node each = iterator.nextRow().getNode("ci");
                        Object entity = new EntityNodeReader(session, each, false).getEntity();
                        if (!JcrRepositoryService.this.entityNotFoundYetOrNewerThenEntityAlreadyFound(entities, entity)) continue;
                        entities.put(((RepositoryObjectEntity)entity).getId(), entity);
                    }
                    catch (RepositoryException rre) {}
                }
                return new ArrayList(entities.values());
            }
        });
    }

    private <T extends RepositoryObjectEntity> boolean entityNotFoundYetOrNewerThenEntityAlreadyFound(Map<String, T> entities, T entity) {
        return !entities.containsKey(entity.getId()) || ((RepositoryObjectEntity)entities.get(entity.getId())).getLastModified().before(entity.getLastModified());
    }

    @Override
    public boolean checkNodeExists(final String id) {
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                return session.itemExists(JcrPathHelper.getAbsolutePathFromId(id));
            }
        });
    }

    private <T extends RepositoryObjectEntity> void validateNodeStoredInCorrectPath(Session session, T entity) throws RepositoryException {
        String id = entity.getId();
        String typeName = entity.getConfigurationItemTypeName();
        ConfigurationItemDescriptor desc = this.descriptorRepository.getDescriptorByType(typeName);
        Preconditions.checkNotNull(desc, "Unknown configuration item type %s", typeName);
        String[] pathElements = id.split("/");
        if (entity instanceof ArchetypeEntity) {
            Checks.checkArgument(pathElements.length == 2 && pathElements[0].equals("Archetypes"), "Archetype cannot be stored at %s. It should be stored under Archetypes", id);
        } else if (desc.getRoot() != ConfigurationItemRoot.NESTED) {
            Checks.checkArgument(pathElements.length == 2 && pathElements[0].equals(desc.getRoot().getRootNodeName()), "Configuration item of type %s cannot be stored at %s. It should be stored under %s", typeName, id, desc.getRoot().getRootNodeName());
        } else {
            Checks.checkArgument(pathElements.length >= 3, "Configuration item of type %s cannot be stored at %s. It should be stored under a valid parent node", typeName, id);
            String parentId = id.substring(0, id.lastIndexOf(47));
            Node parentNode = session.getNode(JcrPathHelper.getAbsolutePathFromId(parentId));
            Checks.checkArgument(parentNode != null, "Configuration item of type %s cannot be stored at %s. The parent does not exist", typeName, id);
            Checks.checkArgument(parentNode.isNodeType("deployit:configurationItem"), "Configuration item of type %s cannot be stored at %s. The parent is not a configuration item", typeName, id);
            String parentTypeName = parentNode.getProperty("$configuration.item.type").getString();
            ConfigurationItemDescriptor parentDescriptor = this.descriptorRepository.getDescriptorByType(parentTypeName);
            for (ConfigurationItemPropertyDescriptor aPD : desc.getPropertyDescriptors()) {
                if (aPD.getType() != ConfigurationItemPropertyType.CI || !aPD.asContainment() || !this.matchesType(parentDescriptor, aPD.getPropertyClassname())) continue;
                return;
            }
            for (ConfigurationItemPropertyDescriptor aPD : parentDescriptor.getPropertyDescriptors()) {
                if (aPD.getType() != ConfigurationItemPropertyType.SET_OF_CIS || !aPD.asContainment() || !this.matchesType(desc, aPD.getCollectionMemberClassname())) continue;
                return;
            }
            throw new Checks.IncorrectArgumentException("Configuration item of type %s cannot be stored at %s. The parent cannot contain configuration items of this type", typeName, id);
        }
    }

    private boolean matchesType(ConfigurationItemDescriptor desc, String wantedType) {
        boolean isExactClass = wantedType.equals(desc.getType());
        boolean isSubClass = desc.getSuperClasses().contains(wantedType);
        boolean implementsInterface = desc.getInterfaces().contains(wantedType);
        return isExactClass || isSubClass || implementsInterface;
    }

    private <T extends RepositoryObjectEntity> void setMixins(T entity, Node node) throws RepositoryException {
        if (entity instanceof ArtifactEntity) {
            node.addMixin("deployit:artifact");
            node.addMixin("deployit:configurationItem");
        } else if (entity instanceof ConfigurationItemEntity) {
            node.addMixin("deployit:configurationItem");
        } else if (entity instanceof ArchetypeEntity) {
            node.addMixin("deployit:archetype");
        } else {
            throw new IllegalArgumentException("Not supporting RepositoryEntity type " + entity.getClass().getName());
        }
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
    }

    private boolean isAnArchetype(Node node) throws RepositoryException {
        NodeType[] mixinNodeTypes;
        for (NodeType type : mixinNodeTypes = node.getMixinNodeTypes()) {
            if (!type.getName().equals("deployit:archetype")) continue;
            return true;
        }
        return false;
    }

    private void checkpoint(Session session, Node node) throws RepositoryException {
        VersionManager versionManager = session.getWorkspace().getVersionManager();
        versionManager.checkpoint(node.getPath());
    }

    static String generateJcrPropertyNameForNestedProperty(ConfigurationItemPropertyDescriptor nestedPd) {
        return nestedPd.getOwningPropertyDescriptor().getName() + "_" + nestedPd.getName();
    }
}

