/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.reflect;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptorFactoryHelper;
import com.xebialabs.deployit.reflect.ConfigurationItemProxy;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class ConfigurationItemDescriptorFactory {
    private static AtomicReference<ConfigurationItemDescriptorFactoryHelper> INSTANCE = new AtomicReference();
    private static Map<Class<?>, ConfigurationItemDescriptor> cachedDescriptors = new ConcurrentHashMap();
    private final Logger log = Logger.getLogger(ConfigurationItemDescriptorFactory.class);

    public ConfigurationItemDescriptorFactory(ConfigurationItemDescriptorFactoryHelper instance) {
        if (INSTANCE.getAndSet(Preconditions.checkNotNull(instance)) != null) {
            this.log.warn("Attempted to reinitialize holder with " + instance);
        }
    }

    public static ConfigurationItemDescriptor getDescriptor(Serializable configurationItem) {
        ConfigurationItemDescriptor configurationItemDescriptor;
        if (INSTANCE.get() != null) {
            configurationItemDescriptor = INSTANCE.get().getDescriptor(configurationItem);
        } else {
            Class<?> configurationItemClass = configurationItem instanceof ConfigurationItemProxy ? ((ConfigurationItemProxy)((Object)configurationItem)).getBackingObject().getClass() : configurationItem.getClass();
            if (!cachedDescriptors.containsKey(configurationItemClass) && configurationItemClass.getAnnotation(ConfigurationItem.class) != null) {
                cachedDescriptors.put(configurationItemClass, new ConfigurationItemDescriptor(configurationItemClass, new HashMap<String, String>()));
            }
            configurationItemDescriptor = cachedDescriptors.get(configurationItemClass);
        }
        return configurationItemDescriptor;
    }
}

