/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.security.AuthenticationFailureException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.UsernameAndPasswordCredentials;
import java.io.IOException;
import javax.jcr.AccessDeniedException;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class JcrTemplate {
    private final Repository repository;

    @Autowired
    public JcrTemplate(Repository repository) {
        this.repository = repository;
    }

    public final <T> T executeAsAdmin(JcrCallback<T> callback) {
        return this.execute("admin", "admin", callback);
    }

    public final <T> T execute(JcrCallback<T> callback) {
        SecurityContext context = SecurityContextHolder.getContext();
        UsernameAndPasswordCredentials creds = (UsernameAndPasswordCredentials)context.getAuthentication();
        if (creds == null) {
            throw new AuthenticationFailureException();
        }
        return this.execute(creds.getUsername(), creds.getPassword(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T execute(String username, String password, JcrCallback<T> callback) throws RuntimeIOException, RuntimeRepositoryException {
        try {
            SimpleCredentials creds = new SimpleCredentials(username, password.toCharArray());
            Session session = this.repository.login(creds);
            try {
                T t = callback.doInJcr(session);
                return t;
            }
            finally {
                session.logout();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (AccessDeniedException ade) {
            throw PermissionDeniedException.withMessage("Failed to complete your request.", ade);
        }
        catch (LoginException le) {
            throw new AuthenticationFailureException(le, "Incorrect credentials for user %s", username);
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e.toString(), e);
        }
    }
}

