/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.RepositoryProxy;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class RepositoryResource
extends AbstractSecuredResource
implements RepositoryProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private Validator validator;

    @Override
    public Response create(String id, RepositoryObject dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.setId(id);
        RepositoryObjectEntity entity = this.dtoConverter.fromDto(dto);
        return this.createInternal(entity);
    }

    @Override
    public Response create(String id, ArtifactAndData dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.getArtifact().setId(id);
        ArtifactEntity entity = this.dtoConverter.fromDto(dto);
        return this.createInternal(entity);
    }

    @Override
    public Response createMultiple(RepositoryObjects dto) {
        this.checkPermission(Permission.EDIT_REPO, Lists.newArrayList(Collections2.transform(dto.getObjects(), new Function<RepositoryObject, String>(){

            @Override
            public String apply(RepositoryObject from) {
                return from.getId();
            }
        })));
        Collection<RepositoryObjectEntity> entities = this.dtoConverter.fromDto(dto);
        return this.createInternal(entities);
    }

    @Override
    public Response read(String id) {
        Object entity = this.repositoryService.read(id);
        RepositoryObject dto = this.dtoConverter.toDto((RepositoryObjectEntity)entity);
        return ResponseFactory.status(Response.Status.OK).entity(dto).build();
    }

    @Override
    public Response update(String id, RepositoryObject dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.setId(id);
        RepositoryObjectEntity entity = this.dtoConverter.fromDto(dto);
        return this.updateInternal(entity);
    }

    @Override
    public Response update(String id, ArtifactAndData dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.getArtifact().setId(id);
        ArtifactEntity entity = this.dtoConverter.fromDto(dto);
        return this.updateInternal(entity);
    }

    @Override
    public Response delete(String id) {
        this.checkPermission(Permission.EDIT_REPO, id);
        this.repositoryService.delete(id);
        return ResponseFactory.noContent().build();
    }

    private Response createInternal(RepositoryObjectEntity entity) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(entity);
        if (response != null) {
            return response;
        }
        this.repositoryService.create(new RepositoryObjectEntity[]{entity});
        return this.reloadEntityAndCreateSuccessResponse(entity);
    }

    private Response validateEntityAndCreateErrorResponseIfNeeded(RepositoryObjectEntity ... entities) {
        if (entities.length == 1) {
            RepositoryObjectEntity entity = entities[0];
            Validator.Validations validations = this.validator.validate(entity, new RepositoryObjectEntity[0]);
            if (validations.hasMessages()) {
                return ResponseFactory.status(Response.Status.BAD_REQUEST).entity(this.dtoConverter.toDto(entity, validations)).build();
            }
        } else {
            RepositoryObjects repositoryObjects = new RepositoryObjects();
            boolean allValid = true;
            for (RepositoryObjectEntity entity : entities) {
                Validator.Validations validations = this.validator.validate(entity, entities);
                repositoryObjects.add(this.dtoConverter.toDto(entity, validations));
                allValid = allValid && !validations.hasMessages();
            }
            if (!allValid) {
                return ResponseFactory.status(Response.Status.BAD_REQUEST).entity(repositoryObjects).build();
            }
        }
        return null;
    }

    private Response reloadEntityAndCreateSuccessResponse(RepositoryObjectEntity entity) {
        Object reloaded = this.repositoryService.read(entity.getId());
        return ResponseFactory.created(this.dtoConverter.toDto((RepositoryObjectEntity)reloaded)).build();
    }

    private Response createInternal(Collection<RepositoryObjectEntity> entities) {
        RepositoryObjectEntity[] entitiesArray = entities.toArray(new RepositoryObjectEntity[entities.size()]);
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(entitiesArray);
        if (response != null) {
            return response;
        }
        this.repositoryService.create(entitiesArray);
        return this.reloadEntityAndCreateSuccessResponse(entities);
    }

    private Response reloadEntityAndCreateSuccessResponse(Collection<RepositoryObjectEntity> entities) {
        ArrayList reloadedDtos = Lists.newArrayList();
        for (RepositoryObjectEntity entity : entities) {
            Object reloadedEntity = this.repositoryService.read(entity.getId());
            reloadedDtos.add(reloadedEntity);
        }
        return ResponseFactory.created(this.dtoConverter.toDto(reloadedDtos)).build();
    }

    private Response updateInternal(RepositoryObjectEntity entity) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(entity);
        if (response != null) {
            return response;
        }
        this.repositoryService.update(entity);
        return this.reloadEntityAndCreateSuccessResponse(entity);
    }
}

