/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.jaxb;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.jaxb.CollectionOfMapsMapElement;
import com.xebialabs.deployit.core.api.jaxb.CollectionOfStringsMapElement;
import com.xebialabs.deployit.core.api.jaxb.MapElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapAdapter
extends XmlAdapter<MapElement[], Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(MapAdapter.class);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MapElement[] marshal(Map<String, Object> map) throws Exception {
        ArrayList<MapElement> elements;
        block10: {
            elements = Lists.newArrayList();
            if (map == null) break block10;
            for (Map.Entry<String, Object> each : map.entrySet()) {
                Object mapValue;
                block9: {
                    Object eachValue;
                    block11: {
                        eachValue = each.getValue();
                        if (!(eachValue instanceof Collection)) break block11;
                        Collection c = (Collection)eachValue;
                        if (c.isEmpty()) {
                            mapValue = null;
                            break block9;
                        } else {
                            Object object = c.iterator().next();
                            if (object instanceof String) {
                                mapValue = new CollectionOfStringsMapElement(c);
                                break block9;
                            } else {
                                if (!(object instanceof Map)) {
                                    String message = each.getKey() + " is a collection but the contents " + object + " is not a String or Map";
                                    logger.error(message);
                                    throw new IllegalArgumentException(message);
                                }
                                mapValue = new CollectionOfMapsMapElement(c);
                            }
                        }
                        break block9;
                    }
                    if (eachValue instanceof String) {
                        mapValue = eachValue;
                    } else {
                        if (!(eachValue instanceof RepositoryObject)) {
                            String message = "Property " + each.getKey() + " is not a Collection, String or RepositoryObject, but a " + eachValue;
                            logger.error(message);
                            throw new IllegalArgumentException(message);
                        }
                        mapValue = eachValue;
                    }
                }
                if (mapValue == null) continue;
                elements.add(new MapElement(each.getKey(), mapValue));
            }
        }
        return elements.toArray(new MapElement[elements.size()]);
    }

    @Override
    public Map<String, Object> unmarshal(MapElement[] values) throws Exception {
        HashMap<String, Object> map = Maps.newHashMap();
        for (MapElement each : values) {
            Object mapValue;
            Object eachValue = each.getValue();
            if (eachValue instanceof CollectionOfStringsMapElement) {
                mapValue = ((CollectionOfStringsMapElement)eachValue).getStrings();
            } else if (eachValue instanceof CollectionOfMapsMapElement) {
                mapValue = ((CollectionOfMapsMapElement)eachValue).getMaps();
            } else if (eachValue instanceof String) {
                mapValue = (String)eachValue;
            } else if (eachValue instanceof RepositoryObject) {
                mapValue = (RepositoryObject)eachValue;
            } else {
                String message = "Property " + each.getKey() + " is not of a recognized type but it is: " + eachValue;
                logger.error(message);
                throw new IllegalArgumentException(message);
            }
            map.put(each.getKey(), mapValue);
        }
        return map;
    }
}

