/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyWasServerStep
extends WasStepBase {
    protected static final String MODIFY_SERVER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/configure-server.py";
    protected WasManagedServer server;

    public ModifyWasServerStep(WasManagedServer server) {
        super(server.getCell());
        this.server = server;
        this.setDescription("Configure server " + server + " on node " + server.getNode() + " in cell " + this.cell);
    }

    public boolean execute(StepExecutionContext ctx) {
        return this.executeWsadminJythonScriptResource(ctx, MODIFY_SERVER_SCRIPT_RESOURCE_PATH, this.getArgs(this.server.getNode().getName(), this.server.getName()).toArray(new String[0])) == 0;
    }

    private List<String> getArgs(String nodeName, String serverName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.cell.getCellName());
        args.add(nodeName);
        args.add(serverName);
        ModifyWasServerStep.addConfigureServerArgument("classpath", this.server.getClasspath(), args);
        ModifyWasServerStep.addConfigureServerArgument("bootclasspath", this.server.getBootClasspath(), args);
        ModifyWasServerStep.addConfigureServerArgument("initheapsize", this.server.getInitHeapSize(), args);
        ModifyWasServerStep.addConfigureServerArgument("maxheapsize", this.server.getMaxHeapSize(), args);
        ModifyWasServerStep.addConfigureServerArgument("jvmargs", this.server.getJvmArguments(), args);
        ModifyWasServerStep.addConfigureServerArgument("disablejit", Boolean.toString(this.server.getDisableJit()), args);
        if (this.server.getApplicationClassLoaderPolicyAndMode() != null) {
            switch (this.server.getApplicationClassLoaderPolicyAndMode()) {
                case MULTIPLE: {
                    args.add("applicationclassloaderpolicy");
                    args.add("MULTIPLE");
                    break;
                }
                case SINGLE_PARENT_FIRST: {
                    args.add("applicationclassloaderpolicy");
                    args.add("SINGLE");
                    args.add("applicationclassloadingmode");
                    args.add("PARENT_FIRST");
                    break;
                }
                case SINGLE_PARENT_LAST: {
                    args.add("applicationclassloaderpolicy");
                    args.add("SINGLE");
                    args.add("applicationclassloadingmode");
                    args.add("PARENT_LAST");
                }
            }
        }
        ModifyWasServerStep.addConfigureServerArgument("workdir", this.server.getWorkingDir(), args);
        ModifyWasServerStep.addConfigureServerArgument("umask", this.server.getUmask(), args);
        ModifyWasServerStep.addConfigureServerArgument("stdoutlog", ModifyWasServerStep.getLogPathForMember(serverName, this.server.getStdOut()), args);
        ModifyWasServerStep.addConfigureServerArgument("stderrlog", ModifyWasServerStep.getLogPathForMember(serverName, this.server.getStdErr()), args);
        ModifyWasServerStep.addConfigureServerArgument("jvmstdoutlog", ModifyWasServerStep.getLogPathForMember(serverName, this.server.getJvmStdOut()), args);
        ModifyWasServerStep.addConfigureServerArgument("jvmstderrlog", ModifyWasServerStep.getLogPathForMember(serverName, this.server.getJvmStdErr()), args);
        ModifyWasServerStep.addConfigureServerArgument("servletcaching", Boolean.toString(this.server.getServletCaching()), args);
        ModifyWasServerStep.addConfigureServerArgument("sessmaxinmem", this.server.getMaximumSessionsInMemory(), args);
        ModifyWasServerStep.addConfigureServerArgument("sesstimeout", this.server.getSessionTimeout(), args);
        ModifyWasServerStep.addConfigureServerArgument("sesscookieenabled", Boolean.toString(this.server.getEnableSessionCookies()), args);
        if (StringUtils.isNotBlank((String)this.server.getCookieName())) {
            args.add("sesscookie");
            args.add(StringUtils.defaultIfEmpty((String)this.server.getCookieName(), (String)"JSESSIONID"));
            args.add(StringUtils.defaultString((String)this.server.getCookieDomain()));
            args.add(StringUtils.defaultIfEmpty((String)this.server.getCookiePath(), (String)"/"));
        }
        for (KeyValuePair pair : this.server.getEnvironmentEntries()) {
            this.addConfigureServerArgument("environment", pair, args);
        }
        return args;
    }

    private void addConfigureServerArgument(String propname, KeyValuePair pair, List<String> args) {
        args.add(propname + "_" + pair.getKey());
        args.add(pair.getValue());
    }

    private static String getLogPathForMember(String serverName, String logPrefix) {
        if (StringUtils.isBlank((String)logPrefix)) {
            return logPrefix;
        }
        return logPrefix + serverName + ".txt";
    }

    private static void addConfigureServerArgument(String propname, String propvalue, String suffix, List<String> args) {
        if (StringUtils.isNotBlank((String)propvalue)) {
            args.add(propname);
            if (suffix != null) {
                args.add(propvalue + suffix);
            } else {
                args.add(propvalue);
            }
        }
    }

    private static void addConfigureServerArgument(String propname, String propvalue, List<String> args) {
        ModifyWasServerStep.addConfigureServerArgument(propname, propvalue, null, args);
    }

    private static void addConfigureServerArgument(String propname, int propvalue, List<String> args) {
        if (propvalue != 0) {
            args.add(propname);
            args.add(Integer.toString(propvalue));
        }
    }
}

