/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;
import com.xebialabs.deployit.plugin.was.step.AddSingleWasClusterMemberStep;
import com.xebialabs.deployit.plugin.was.step.CreateWasClusterStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasClusterStep;
import com.xebialabs.deployit.plugin.was.step.ModifyWasServerStep;
import com.xebialabs.deployit.plugin.was.step.RemoveWasClusterMemberStep;
import com.xebialabs.deployit.plugin.was.step.StartWasManagedServerStep;
import com.xebialabs.deployit.plugin.was.step.StopWasClusterStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasClusterRunBook
extends SingleTypeHandlingRunBook<WasCluster>
implements RunBook {
    public WasClusterRunBook() {
        super(WasCluster.class);
    }

    public void resolve(Change<WasCluster> change, ChangePlan changePlan, List<Step> steps) {
        WasCluster newCluster;
        WasCluster oldCluster = (WasCluster)change.getOldRevision();
        boolean identical = ConfigurationItemReflectionUtils.isIdentical((Serializable)oldCluster, (Serializable)(newCluster = (WasCluster)change.getNewRevision()));
        if (!identical && !this.changeWillBeHandledByWasDeploymentRunBook(change, changePlan)) {
            WasCluster cluster;
            if (change.isModification()) {
                this.getStepsForModifiedCluster(steps, oldCluster, newCluster, changePlan);
            }
            if (change.isDeletion()) {
                cluster = (WasCluster)change.getOldRevision();
                steps.add(new StopWasClusterStep(cluster, false));
                steps.add(new DestroyWasClusterStep(cluster));
            }
            if (change.isAddition()) {
                cluster = (WasCluster)change.getNewRevision();
                steps.add(new CreateWasClusterStep(cluster));
                for (WasManagedServer eachServer : cluster.getServers()) {
                    steps.add(new AddSingleWasClusterMemberStep(cluster, eachServer));
                    steps.add(new SynchronizeWasNodeStep(eachServer.getNode()));
                    steps.add(new StartWasManagedServerStep(eachServer));
                }
            }
        }
    }

    public void getStepsForModifiedCluster(List<Step> steps, WasCluster oldCluster, WasCluster newCluster, ChangePlan changePlan) {
        steps.add(new StopWasClusterStep(oldCluster, false));
        HashSet<WasNodeAgent> nodesToSynchronize = new HashSet<WasNodeAgent>();
        Collection serversToBeRemoved = CollectionUtils.subtract(oldCluster.getServers(), newCluster.getServers());
        for (WasManagedServer serverToBeRemoved : serversToBeRemoved) {
            steps.add(new RemoveWasClusterMemberStep(oldCluster, serverToBeRemoved));
            nodesToSynchronize.add(serverToBeRemoved.getNode());
        }
        Collection<Change<WasManagedServer>> modifiedServerChanges = this.findWasServersToBeModified(changePlan, newCluster);
        for (Change<WasManagedServer> modifiedServerChange : modifiedServerChanges) {
            steps.add(new ModifyWasServerStep((WasManagedServer)modifiedServerChange.getNewRevision()));
        }
        Collection serversToBeAdded = CollectionUtils.subtract(newCluster.getServers(), oldCluster.getServers());
        for (WasManagedServer serverToBeAdded : serversToBeAdded) {
            steps.add(new AddSingleWasClusterMemberStep(oldCluster, serverToBeAdded));
            nodesToSynchronize.add(serverToBeAdded.getNode());
        }
        for (WasNodeAgent node : nodesToSynchronize) {
            steps.add(new SynchronizeWasNodeStep(node));
        }
        for (WasManagedServer serverToBeStarted : newCluster.getServers()) {
            steps.add(new StartWasManagedServerStep(serverToBeStarted));
        }
    }

    private Collection<Change<WasManagedServer>> findWasServersToBeModified(ChangePlan changePlan, WasCluster newCluster) {
        ArrayList<Change<WasManagedServer>> wasServersToBeModified = new ArrayList<Change<WasManagedServer>>();
        for (Change change : changePlan.getChanges()) {
            if (change.getConfigurationItemClass() != WasManagedServer.class || !change.isModification() || !newCluster.getServers().contains(change.getNewRevision())) continue;
            wasServersToBeModified.add((Change<WasManagedServer>)change);
        }
        return wasServersToBeModified;
    }

    private boolean changeWillBeHandledByWasDeploymentRunBook(Change<WasCluster> clusterChange, ChangePlan changePlan) {
        Change<Deployment> deploymentChange = this.findChangeForDeploymentToClusterChange(clusterChange, changePlan);
        return deploymentChange != null;
    }

    private Change<Deployment> findChangeForDeploymentToClusterChange(Change<WasCluster> clusterChange, ChangePlan changePlan) {
        for (Change change : changePlan.getChanges()) {
            if (change.getConfigurationItemClass() != Deployment.class) continue;
            WasCluster oldCluster = (WasCluster)clusterChange.getOldRevision();
            WasCluster newCluster = (WasCluster)clusterChange.getNewRevision();
            Deployment oldDeployment = (Deployment)change.getOldRevision();
            Deployment newDeployment = (Deployment)change.getNewRevision();
            if (oldDeployment != null) {
                if (oldCluster != null && oldDeployment.getTarget().getMembersOfType(WasCluster.class).contains(oldCluster)) {
                    return change;
                }
                if (newCluster != null && oldDeployment.getTarget().getMembersOfType(WasCluster.class).contains(newCluster)) {
                    return change;
                }
            }
            if (newDeployment == null) continue;
            if (oldCluster != null && newDeployment.getTarget().getMembersOfType(WasCluster.class).contains(oldCluster)) {
                return change;
            }
            if (newCluster == null || !newDeployment.getTarget().getMembersOfType(WasCluster.class).contains(newCluster)) continue;
            return change;
        }
        return null;
    }
}

