/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.ListenServer;
import com.xebialabs.deployit.ci.LoadBalancedServerAware;
import com.xebialabs.deployit.ci.LoadBalancingProtocol;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasPath;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasStartMode;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasVersion;
import com.xebialabs.deployit.plugin.jbossas.step.CheckAjpPortStep;
import com.xebialabs.deployit.plugin.jbossas.step.CheckJbossasDeployDirPath;
import com.xebialabs.deployit.plugin.jbossas.step.CheckJbossasServerVersionStep;
import com.xebialabs.deployit.plugin.jbossas.step.CheckNamingPortStep;
import com.xebialabs.deployit.step.CheckDirExistsStep;
import com.xebialabs.deployit.step.CheckFileExistenceStep;
import com.xebialabs.deployit.step.HostConnectionStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="JBoss Application Server instance", discoverable=true, category="middleware")
public class JbossasServer
extends BaseConfigurationItem
implements Discoverable<JbossasServer>,
LoadBalancedServerAware {
    private static final int DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS = 10000;
    public static final ArrayList<LoadBalancingProtocol> SUPPORTED_PROTOCOLS = Lists.newArrayList((Object[])new LoadBalancingProtocol[]{LoadBalancingProtocol.AJP});
    @ConfigurationItemProperty(required=true, label="JBoss version", description="Version of the JBoss server.")
    private JbossasVersion version = JbossasVersion.JBOSSAS_UNKNOWN;
    @ConfigurationItemProperty(required=true, asContainment=true, label="JBoss server host", description="Host on which the JBoss server is running.")
    private Host host;
    @ConfigurationItemProperty(required=true, discoveryParam=true, size=ConfigurationItemProperty.Size.LARGE, label="JBoss installation location", description="Place where JBoss is installed such as /usr/local/jboss-5.1.0.GA.")
    private String home;
    @ConfigurationItemProperty(required=true, discoveryParam=true, label="JBoss instance name", description="Name of the JBoss server instance, e.g. default or minimal.")
    private String name;
    @ConfigurationItemProperty(required=true, size=ConfigurationItemProperty.Size.LARGE, label="JBoss start command", description="Path to the script that should be executed to start the JBoss server in the background")
    private String startCommand;
    @ConfigurationItemProperty(required=false, size=ConfigurationItemProperty.Size.LARGE, label="JBoss stop command", description="Command that should be executed to stop the JBoss server.")
    private String stopCommand;
    @ConfigurationItemProperty(required=false, size=ConfigurationItemProperty.Size.LARGE, label="JBoss restart command", description="Command that should be executed to restart the JBoss server.")
    private String restartCommand;
    @ConfigurationItemProperty(required=false)
    private JbossasStartMode strategy = JbossasStartMode.RESTART;
    @ConfigurationItemProperty(required=false, description="Estimated time in miliseconds to wait for the deployment completion.")
    private int deploymentCompletionWaitTime = 10000;
    @ConfigurationItemProperty(required=false, description="AJP Port for the JBoss Server, default is 8009")
    private int ajpPort = 8009;
    @ConfigurationItemProperty(required=false, label="control Port", description="ControlPort of the JBoss Server, default is 1099 for JBoss 5, 1090 for JBoss 6+")
    private int controlPort = 1099;
    @ConfigurationItemProperty
    private List<JbossasPath> deployDirectories = Lists.newArrayList();

    public HostSession connectToAdminHost() {
        return this.getHost().getHostSession();
    }

    public String getRunJarFilePath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "bin" + fileSep + "run.jar";
    }

    public String getInstanceDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "server" + fileSep + this.getName();
    }

    public String getDeployDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        String directory = this.deployDirectories.isEmpty() ? "deploy" : this.deployDirectories.iterator().next().getName();
        return this.getInstanceDirPath() + fileSep + directory;
    }

    public String getShutdownCommand() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "bin" + fileSep + "shutdown" + this.getHost().getOperatingSystemFamily().getScriptExtension();
    }

    public JbossasVersion getVersion() {
        return this.version;
    }

    public void setVersion(JbossasVersion version) {
        this.version = version;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRestartCommand() {
        return this.restartCommand;
    }

    public void setRestartCommand(String restartCommand) {
        this.restartCommand = restartCommand;
    }

    public String getTmpDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getInstanceDirPath() + fileSep + "tmp";
    }

    public int getAjpPort() {
        return this.ajpPort;
    }

    public void setAjpPort(int ajpPort) {
        this.ajpPort = ajpPort;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(int controlPort) {
        this.controlPort = controlPort;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public void setStopCommand(String stopCommand) {
        this.stopCommand = stopCommand;
    }

    public int getDeploymentCompletionWaitTime() {
        return this.deploymentCompletionWaitTime;
    }

    public void setDeploymentCompletionWaitTime(int deploymentCompletionWaitTime) {
        this.deploymentCompletionWaitTime = deploymentCompletionWaitTime;
    }

    public JbossasStartMode getStartMode() {
        return this.strategy;
    }

    public void setStartMode(JbossasStartMode strategy) {
        this.strategy = strategy;
    }

    public List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add((Step)new HostConnectionStep(this.getHost()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getHome()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getInstanceDirPath()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getDeployDirPath()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getTmpDirPath()));
        steps.add(new CheckJbossasServerVersionStep(this));
        if (StringUtils.isNotEmpty((String)this.getRestartCommand())) {
            steps.add((Step)new CheckFileExistenceStep(this.getHost(), this.getRestartCommand(), true, false, true));
        }
        steps.add(new CheckJbossasDeployDirPath(this));
        steps.add(new CheckNamingPortStep(this));
        steps.add(new CheckAjpPortStep(this));
        return steps;
    }

    public JbossasServer discover(Map<String, Object> info, ChangePlan cp) {
        List<Step> steps = this.getCheckSteps();
        cp.addSteps(steps);
        cp.execute(info);
        return this;
    }

    public JbossasServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return null;
    }

    public String getTwiddleFilePath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "bin" + fileSep + "twiddle" + this.getHost().getScriptExtension();
    }

    public void addDeployDir(String path) {
        this.deployDirectories.add(new JbossasPath(path));
    }

    public List<LoadBalancingProtocol> getSupportedProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public List<ListenServer> getLoadBalancedServers(LoadBalancingProtocol protocol) {
        switch (protocol) {
            case AJP: {
                ListenServer server = new ListenServer();
                server.setLabel(this.getLabel());
                server.setHost(this.getHost());
                server.setListenPort(this.getAjpPort());
                return Lists.newArrayList((Object[])new ListenServer[]{server});
            }
        }
        return Lists.newArrayList();
    }
}

