/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipDir;

public class ZipFile
implements Vfs.File {
    private final ZipDir dir;
    private final ZipEntry entry;

    public ZipFile(ZipDir dir, ZipEntry entry) {
        this.dir = dir;
        this.entry = entry;
    }

    public String getFullPath() {
        return this.dir.getPath() + "/" + this.entry.getName();
    }

    public String getName() {
        String name = this.entry.getName();
        return name.substring(name.lastIndexOf("/") + 1);
    }

    public String getPath() {
        return this.dir.getPath();
    }

    public String getRelativePath() {
        return this.entry.getName();
    }

    public InputStream getInputStream() throws IOException {
        return this.dir.zipFile.getInputStream(this.entry);
    }

    public String toString() {
        return this.dir.getPath() + "!" + File.separatorChar + this.entry.toString();
    }
}

