/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.ByteArrayUtil;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamEncoder<E>
extends EncoderBase<E> {
    public static int START_PEBBLE = 1853421169;
    public static int STOP_PEBBLE = 640373619;
    private int MAX_BUFFER_SIZE = 100;
    List<E> bufferList = new ArrayList(this.MAX_BUFFER_SIZE);

    @Override
    public void doEncode(E event) throws IOException {
        this.bufferList.add(event);
        if (this.bufferList.size() == this.MAX_BUFFER_SIZE) {
            this.writeBuffer();
        }
    }

    void writeHeader(ByteArrayOutputStream baos, int bufferSize) {
        ByteArrayUtil.writeInt(baos, START_PEBBLE);
        ByteArrayUtil.writeInt(baos, bufferSize);
        ByteArrayUtil.writeInt(baos, 0);
        ByteArrayUtil.writeInt(baos, START_PEBBLE ^ bufferSize);
    }

    void writeFooter(ByteArrayOutputStream baos, int bufferSize) {
        ByteArrayUtil.writeInt(baos, STOP_PEBBLE);
        ByteArrayUtil.writeInt(baos, STOP_PEBBLE ^ bufferSize);
    }

    void writeBuffer() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
        int size = this.bufferList.size();
        this.writeHeader(baos, size);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        for (E e : this.bufferList) {
            oos.writeObject(e);
        }
        this.bufferList.clear();
        oos.flush();
        this.writeFooter(baos, size);
        byte[] byteArray = baos.toByteArray();
        oos.close();
        this.writeEndPosition(byteArray);
        this.outputStream.write(byteArray);
    }

    void writeEndPosition(byte[] byteArray) {
        int offset = 2 * CoreConstants.BYTES_PER_INT;
        ByteArrayUtil.writeInt(byteArray, offset, byteArray.length - offset);
    }

    @Override
    public void init(OutputStream os2) throws IOException {
        super.init(os2);
        this.bufferList.clear();
    }

    @Override
    public void close() throws IOException {
        this.writeBuffer();
    }
}

