/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibraryJar;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibraryJarMapping;
import com.xebialabs.deployit.plugin.wls.mapper.WlsArtifactDeployer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WlsSharedLibraryJarToWlsClusterMapper
extends Mapper<WlsSharedLibraryJar, WlsSharedLibraryJarMapping, WlsCluster> {
    public WlsSharedLibraryJarToWlsClusterMapper(Change<Deployment> change) {
        super(change);
    }

    public void generateUndeploySteps(List<Step> steps) {
        ArrayList mappings = Lists.newArrayList((Iterable)this.getDeletedMappings());
        mappings.addAll(Lists.transform((List)this.getModifiedMappings(), (Function)this.FIRST_MAPPING));
        steps.addAll(new WlsArtifactDeployer().generateUndeploysSteps(this.filterWls8Domain(mappings)));
    }

    public void generateDeploySteps(List<Step> steps) {
        ArrayList mappings = Lists.newArrayList();
        mappings.addAll(Lists.transform((List)this.getModifiedMappings(), (Function)this.SECOND_MAPPING));
        mappings.addAll(this.getAddedMappings());
        steps.addAll(new WlsArtifactDeployer().generateDeploySteps(this.filterWls8Domain(mappings)));
    }

    public void generateStartSteps(List<Step> steps) {
        ArrayList mappings = Lists.newArrayList();
        mappings.addAll(Lists.transform((List)this.getModifiedMappings(), (Function)this.SECOND_MAPPING));
        mappings.addAll(this.getAddedMappings());
        steps.addAll(new WlsArtifactDeployer().generateStartSteps(this.filterWls8Domain(mappings)));
    }

    private List<WlsArtifactMapping> filterWls8Domain(List<? extends WlsArtifactMapping> mappings) {
        ArrayList filtered = Lists.newArrayList();
        for (WlsArtifactMapping wlsArtifactMapping : mappings) {
            if (!wlsArtifactMapping.getTarget().isRunningVersionGreaterThan9()) continue;
            filtered.add(wlsArtifactMapping);
        }
        return filtered;
    }
}

