/*
 * Decompiled with CFR 0.152.
 */
package com.qrmedia.commons.lang.model;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementUtils {
    private static final Set<ElementType> DEFAULT_TARGET = ElementUtils.asUnmodifiableSet(ElementType.values());
    private static final RetentionPolicy DEFAULT_RETENTION = RetentionPolicy.CLASS;

    private static <E> Set<E> asUnmodifiableSet(E ... objs) {
        return Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(objs)));
    }

    public static boolean isOfKind(Element element, ElementKind kind) {
        return element != null && kind != null && element.getKind().equals((Object)kind);
    }

    public static boolean isAnnotation(Element element) {
        return ElementUtils.isOfKind(element, ElementKind.ANNOTATION_TYPE);
    }

    public static boolean isConstructor(Element element) {
        return ElementUtils.isOfKind(element, ElementKind.CONSTRUCTOR);
    }

    public static boolean isMethod(Element element) {
        return ElementUtils.isOfKind(element, ElementKind.METHOD);
    }

    public static Set<ElementType> getTarget(Element element) {
        if (element == null || !ElementUtils.isAnnotation(element)) {
            return null;
        }
        Target targetAnnotation = element.getAnnotation(Target.class);
        return targetAnnotation != null ? ElementUtils.asUnmodifiableSet(targetAnnotation.value()) : DEFAULT_TARGET;
    }

    public static RetentionPolicy getRetention(Element element) {
        if (element == null || !ElementUtils.isAnnotation(element)) {
            return null;
        }
        Retention retentionAnnotation = element.getAnnotation(Retention.class);
        return retentionAnnotation != null ? retentionAnnotation.value() : DEFAULT_RETENTION;
    }

    public static boolean hasPublicNoargConstructor(Element element) {
        if (element == null) {
            return false;
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (!ElementUtils.isConstructor(element2) || !element2.getModifiers().contains((Object)Modifier.PUBLIC) || !((ExecutableElement)element2).getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static AnnotationMirror getAnnotationMirror(Element element, TypeElement annotationElement) {
        if (element == null || annotationElement == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!((Object)annotationMirror.getAnnotationType().asElement()).equals(annotationElement)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static Element getEnclosedElement(Element element, String enclosedElementName) {
        if (element == null || enclosedElementName == null) {
            return null;
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (!element2.getSimpleName().contentEquals(enclosedElementName)) continue;
            return element2;
        }
        return null;
    }

    public static List<Element> getAnnotatedEnclosedElements(Element element, Class<? extends Annotation> annotationType) {
        if (element == null || annotationType == null) {
            return new ArrayList<Element>(0);
        }
        ArrayList<Element> annotatedEnclosedElements = new ArrayList<Element>();
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getAnnotation(annotationType) == null) continue;
            annotatedEnclosedElements.add(element2);
        }
        return annotatedEnclosedElements;
    }

    public static List<DeclaredType> getAnnotationTypes(Element element) {
        if (element == null) {
            return new ArrayList<DeclaredType>(0);
        }
        ArrayList<DeclaredType> annotationTypes = new ArrayList<DeclaredType>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            annotationTypes.add(annotationMirror.getAnnotationType());
        }
        return annotationTypes;
    }
}

