/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.security.AccessControlService;
import com.xebialabs.deployit.security.JcrAccessControlEntry;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="accessControlService")
public class JcrAccessControlService
implements AccessControlService {
    JcrTemplate jcrTemplate;
    private static final Logger logger = LoggerFactory.getLogger(JcrAccessControlService.class);

    @Autowired
    public JcrAccessControlService(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public Collection<JcrAccessControlEntry> getAccessControlEntries(final String id) {
        return this.jcrTemplate.execute(new JcrCallback<Collection<JcrAccessControlEntry>>(){

            @Override
            public Collection<JcrAccessControlEntry> doInJcr(Session session) throws IOException, RepositoryException {
                AccessControlManager acm = session.getAccessControlManager();
                ArrayList entries = Lists.newArrayList();
                for (AccessControlPolicy eachPolicy : acm.getPolicies(JcrPathHelper.getAbsolutePathFromId(id))) {
                    if (!(eachPolicy instanceof JackrabbitAccessControlList)) continue;
                    JackrabbitAccessControlList acl = (JackrabbitAccessControlList)eachPolicy;
                    for (AccessControlEntry eachEntry : acl.getAccessControlEntries()) {
                        JackrabbitAccessControlEntry entry = (JackrabbitAccessControlEntry)eachEntry;
                        ArrayList permissions = Lists.newArrayList();
                        for (Privilege eachPrivilege : entry.getPrivileges()) {
                            permissions.add(eachPrivilege.getName());
                        }
                        boolean isTransitive = true;
                        if (((JackrabbitAccessControlEntry)eachEntry).getRestriction("rep:glob") != null) {
                            isTransitive = false;
                        }
                        entries.add(new JcrAccessControlEntry(entry.getPrincipal().getName(), entry.isAllow(), permissions, isTransitive));
                    }
                }
                return entries;
            }
        });
    }

    @Override
    public void setAccessControlEntries(final String id, final JcrAccessControlEntry ... entries) {
        final String path = JcrPathHelper.getAbsolutePathFromId(id);
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                AccessControlManager acm = session.getAccessControlManager();
                boolean accessControlPolicyHasBeenSet = false;
                for (AccessControlPolicy eachPolicy : acm.getPolicies(path)) {
                    if (!JcrAccessControlService.this.tryAndSetAccessControlPolicy(path, session, eachPolicy, entries)) continue;
                    accessControlPolicyHasBeenSet = true;
                }
                if (!accessControlPolicyHasBeenSet) {
                    AccessControlPolicyIterator applicablePolicies = acm.getApplicablePolicies(path);
                    while (applicablePolicies.hasNext()) {
                        AccessControlPolicy eachPolicy = applicablePolicies.nextAccessControlPolicy();
                        if (!JcrAccessControlService.this.tryAndSetAccessControlPolicy(path, session, eachPolicy, entries)) continue;
                        accessControlPolicyHasBeenSet = true;
                    }
                }
                if (!accessControlPolicyHasBeenSet) {
                    throw new IllegalStateException("Unable to set access control entries on " + id);
                }
                session.save();
                return null;
            }
        });
    }

    @Override
    public boolean hasPrivilege(final String id, final String privilege) {
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                AccessControlManager acm = session.getAccessControlManager();
                Privilege aPrivilege = acm.privilegeFromName(privilege);
                return acm.hasPrivileges(JcrPathHelper.getAbsolutePathFromId(id), new Privilege[]{aPrivilege});
            }
        });
    }

    private boolean tryAndSetAccessControlPolicy(String path, Session session, AccessControlPolicy policy, JcrAccessControlEntry ... entries) throws RepositoryException {
        if (!(policy instanceof JackrabbitAccessControlList)) {
            return false;
        }
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acl = (JackrabbitAccessControlList)policy;
        String[] strings = acl.getRestrictionNames();
        for (AccessControlEntry accessControlEntry : acl.getAccessControlEntries()) {
            acl.removeAccessControlEntry(accessControlEntry);
        }
        for (JcrAccessControlEntry jcrAccessControlEntry : entries) {
            String principalName = jcrAccessControlEntry.getPrincipalName();
            if (((JackrabbitSession)session).getPrincipalManager().hasPrincipal(principalName)) {
                PrincipalImpl principal = new PrincipalImpl(principalName);
                ArrayList privilegeList = Lists.newArrayList();
                for (String eachPrivilege : jcrAccessControlEntry.getPrivileges()) {
                    privilegeList.add(acm.privilegeFromName(eachPrivilege));
                }
                Privilege[] privileges = (Privilege[])Iterables.toArray((Iterable)privilegeList, Privilege.class);
                if (logger.isDebugEnabled()) {
                    for (Privilege privilege : privileges) {
                        logger.debug("{} {} for {} on {}", new Object[]{jcrAccessControlEntry.isAllow() ? "Adding" : "Denying", privilege.getName(), principalName, path});
                    }
                }
                if (privileges.length <= 0) continue;
                if (jcrAccessControlEntry.isTransitive()) {
                    acl.addEntry((Principal)principal, privileges, jcrAccessControlEntry.isAllow());
                    continue;
                }
                HashMap restrictions = Maps.newHashMap();
                restrictions.put("rep:glob", ValueFactoryImpl.getInstance().createValue(""));
                acl.addEntry((Principal)principal, privileges, jcrAccessControlEntry.isAllow(), (Map)restrictions);
                continue;
            }
            logger.warn("Skipping {} because {} is not known.", (Object)jcrAccessControlEntry, (Object)principalName);
        }
        acm.setPolicy(path, (AccessControlPolicy)acl);
        return true;
    }
}

