/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.repository.ArchetypeEntity;
import com.xebialabs.deployit.repository.ArtifactEntity;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.spi.commons.value.QValueValue;

class EntityNodeReader {
    private Session session;
    private Node node;
    private boolean readFully;

    public EntityNodeReader(Session session, Node node, boolean readFully) {
        this.session = session;
        this.node = node;
        this.readFully = readFully;
    }

    public <T extends RepositoryObjectEntity> T getEntity() throws RepositoryException, IOException {
        RepositoryObjectEntity entity = this.instantiateEntity();
        this.copyEntityMetadata(entity);
        if (this.readFully) {
            this.copyData(entity);
        }
        this.copyValuesIntoEntity(entity);
        return (T)entity;
    }

    private void copyEntityMetadata(RepositoryObjectEntity entity) throws RepositoryException {
        entity.setId(this.node.getProperty("$id").getString());
        entity.setLastModified(this.node.getProperty("$lastModified").getDate());
        if (this.node.hasProperty("$creatingTaskId")) {
            entity.setCreatingTaskId(this.node.getProperty("$creatingTaskId").getString());
        }
    }

    private void copyData(RepositoryObjectEntity entity) throws RepositoryException, IOException {
        if (entity instanceof ArtifactEntity) {
            ArtifactEntity artifact = (ArtifactEntity)entity;
            InputStream binaryStream = this.node.getProperty("$data").getBinary().getStream();
            byte[] binaryData = IOUtils.toByteArray((InputStream)binaryStream);
            ByteArrayInputStream copiedBinaryStream = new ByteArrayInputStream(binaryData);
            artifact.setData(copiedBinaryStream);
        }
    }

    private void copyValuesIntoEntity(RepositoryObjectEntity entity) throws RepositoryException {
        ConfigurationItemDescriptor ciDescriptor = ConfigurationItemDescriptorRepositoryHolder.getDescriptor(entity);
        block7: for (ConfigurationItemPropertyDescriptor pd : ciDescriptor.getPropertyDescriptors()) {
            if (!this.node.hasProperty(pd.getName()) && !pd.asContainment()) continue;
            switch (pd.getType()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.copyPrimitivePropertyFromNode(entity, pd);
                    continue block7;
                }
                case LIST_OF_OBJECTS: {
                    this.copyListOfObjectsPropertyFromNode(entity, pd);
                    continue block7;
                }
                case SET_OF_STRINGS: {
                    this.copySetOfStringsPropertyFromNode(entity, pd);
                    continue block7;
                }
                case CI: {
                    this.copyConfigurationItemPropertyFromNode(entity, pd);
                    continue block7;
                }
                case SET_OF_CIS: {
                    this.copySetOfConfigurationItemsPropertyFromNode(entity, pd);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Cannot convert property " + pd.getName() + " because it is of unsupported type " + pd.getType());
                }
            }
        }
    }

    private RepositoryObjectEntity instantiateEntity() throws RepositoryException, IOException {
        String configurationItemTypeName = this.node.getProperty("$configuration.item.type").getString();
        Collection<String> mixinNodeTypeNames = this.getMixinNodeTypeNames();
        if (mixinNodeTypeNames.contains("deployit:archetype")) {
            if (this.node.hasProperty("$archetype")) {
                return new ArchetypeEntity(this.readArchetype());
            }
            return new ArchetypeEntity(configurationItemTypeName);
        }
        if (mixinNodeTypeNames.contains("deployit:artifact")) {
            if (this.node.hasProperty("$archetype")) {
                return new ArtifactEntity(this.readArchetype());
            }
            return new ArtifactEntity(configurationItemTypeName);
        }
        if (mixinNodeTypeNames.contains("deployit:configurationItem")) {
            if (this.node.hasProperty("$archetype")) {
                return new ConfigurationItemEntity(this.readArchetype());
            }
            return new ConfigurationItemEntity(configurationItemTypeName);
        }
        throw new IllegalArgumentException("Cannot determine whether JCR node " + JcrPathHelper.getIdFromAbsolutePath(this.node.getPath()) + " is a configuration item or an archetype");
    }

    protected Collection<String> getMixinNodeTypeNames() throws RepositoryException {
        if (this.nodeIsFrozen()) {
            return this.getMixinNodeTypeNamesFromFrozenNode();
        }
        return this.getMixinNodeTypeNamesFromRegularNode();
    }

    protected Collection<String> getMixinNodeTypeNamesFromFrozenNode() throws RepositoryException {
        Property property = this.node.getProperty("jcr:frozenMixinTypes");
        ArrayList frozenMixinTypes = Lists.newArrayList((Object[])property.getValues());
        return Collections2.transform((Collection)frozenMixinTypes, (Function)new Function<Value, String>(){

            public String apply(Value from) {
                try {
                    return from.getString();
                }
                catch (RepositoryException e) {
                    throw new RuntimeRepositoryException("Cannot convert Value into String", e);
                }
            }
        });
    }

    protected Collection<String> getMixinNodeTypeNamesFromRegularNode() throws RepositoryException {
        ArrayList mixinNodeTypes = Lists.newArrayList((Object[])this.node.getMixinNodeTypes());
        return Collections2.transform((Collection)mixinNodeTypes, (Function)new Function<NodeType, String>(){

            public String apply(NodeType from) {
                return from.getName();
            }
        });
    }

    private ArchetypeEntity readArchetype() throws RepositoryException, IOException {
        Node archetypeNode = this.node.getProperty("$archetype").getNode();
        return (ArchetypeEntity)new EntityNodeReader(this.session, archetypeNode, false).getEntity();
    }

    private void copyPrimitivePropertyFromNode(RepositoryObjectEntity entity, ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        entity.addValue(pd.getName(), this.node.getProperty(pd.getName()).getString());
    }

    private void copyListOfObjectsPropertyFromNode(RepositoryObjectEntity entity, ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        ArrayList listOfObjects = null;
        for (ConfigurationItemPropertyDescriptor eachNestedPd : pd.getPropertyDescriptors()) {
            int i;
            Value[] values = this.node.getProperty(JcrRepositoryService.generateJcrPropertyNameForNestedProperty(eachNestedPd)).getValues();
            if (listOfObjects == null) {
                listOfObjects = new ArrayList();
                for (i = 0; i < values.length; ++i) {
                    listOfObjects.add(new HashMap());
                }
            }
            for (i = 0; i < values.length; ++i) {
                ((Map)listOfObjects.get(i)).put(eachNestedPd.getName(), values[i].getString());
            }
        }
        entity.addValue(pd.getName(), listOfObjects);
    }

    private void copySetOfStringsPropertyFromNode(RepositoryObjectEntity entity, ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        HashSet setOfStrings = Sets.newHashSet();
        for (Value each : this.node.getProperty(pd.getName()).getValues()) {
            setOfStrings.add(each.getString());
        }
        entity.addValue(pd.getName(), setOfStrings);
    }

    private void copyConfigurationItemPropertyFromNode(RepositoryObjectEntity entity, ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        if (pd.asContainment()) {
            entity.addValue(pd.getName(), JcrPathHelper.getIdFromAbsolutePath(this.node.getParent().getPath()));
        } else {
            Value value = this.node.getProperty(pd.getName()).getValue();
            entity.addValue(pd.getName(), this.getReferencedCiId(value));
        }
    }

    private void copySetOfConfigurationItemsPropertyFromNode(RepositoryObjectEntity entity, ConfigurationItemPropertyDescriptor pd) throws RepositoryException {
        HashSet referencedCiIds = Sets.newHashSet();
        if (pd.asContainment()) {
            SearchParameters params = new SearchParameters().setParent(entity.getId()).setConfigurationItemType(pd.getCollectionMemberClassname());
            SearchQueryBuilder builder = new SearchQueryBuilder(ConfigurationItemDescriptorRepositoryHolder.getDescriptorRepository(), params);
            Query query = builder.build(this.session);
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                referencedCiIds.add(JcrPathHelper.getIdFromAbsolutePath(iterator.nextNode().getPath()));
            }
        } else {
            for (Value each : this.node.getProperty(pd.getName()).getValues()) {
                referencedCiIds.add(this.getReferencedCiId(each));
            }
        }
        entity.addValue(pd.getName(), referencedCiIds);
    }

    private String getReferencedCiId(Value value) throws RepositoryException {
        String referencedCiUuid = ((QValueValue)value).getQValue().getString();
        Node referencedCi = this.getNodeByUuid(referencedCiUuid);
        return JcrPathHelper.getIdFromAbsolutePath(referencedCi.getPath());
    }

    protected Node getNodeByUuid(String referencedCiUuid) throws RepositoryException {
        try {
            return this.session.getNodeByIdentifier(referencedCiUuid);
        }
        catch (ItemNotFoundException exc) {
            Node frozenNode;
            if (this.nodeIsFrozen() && (frozenNode = this.getFrozenNodeByUuid(referencedCiUuid)) != null) {
                return frozenNode;
            }
            throw exc;
        }
    }

    private Node getFrozenNodeByUuid(String referencedCiUuid) throws RepositoryException {
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = this.session.getValueFactory();
        Query query = queryManager.createQuery("SELECT * FROM [{http://www.jcp.org/jcr/nt/1.0}frozenNode] WHERE [jcr:frozenUuid] = $uuid", "JCR-SQL2");
        query.bindValue("uuid", valueFactory.createValue(referencedCiUuid));
        QueryResult result = query.execute();
        NodeIterator resultNodes = result.getNodes();
        if (resultNodes.hasNext()) {
            return resultNodes.nextNode();
        }
        return null;
    }

    private boolean nodeIsFrozen() throws RepositoryException {
        return this.node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode");
    }
}

