/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.artifact;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.Folder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="Folder in the Application Package containing sql files. Might contain sub folders")
public class SqlFolder
extends Folder {
    @ConfigurationItemProperty(required=false, description="Default is .sql")
    private String filter = ".sql";
    private final transient FilenameFilter sqlFilenameFilter = new FilenameFilter(){

        public boolean accept(File file, String name) {
            return name.toLowerCase().endsWith(SqlFolder.this.filter);
        }
    };
    private final transient FilenameFilter directoryOnly = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return new File(dir, name).isDirectory();
        }
    };

    @Override
    public List<File> getFiles() {
        List<File> allfiles = this.getSqlFiles(new File(this.getLocation()));
        Collections.sort(allfiles);
        return allfiles;
    }

    private List<File> getSqlFiles(File folder) {
        ArrayList allfiles = Lists.newArrayList((Object[])folder.listFiles(this.sqlFilenameFilter));
        for (File file : folder.listFiles(this.directoryOnly)) {
            allfiles.addAll(this.getSqlFiles(file));
        }
        return allfiles;
    }
}

