/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections
extends ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(Reflections.class);
    private final transient Configuration configuration;
    private Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store();
        for (Scanner scanner : configuration.getScanners()) {
            scanner.setConfiguration(configuration);
            scanner.setStore(this.store.get(scanner.getClass()));
        }
        this.scan();
    }

    public Reflections(final String prefix, final Scanner ... scanners) {
        this(new ConfigurationBuilder(){
            final Predicate<String> filter;
            {
                this.filter = new FilterBuilder.Include(FilterBuilder.prefix(prefix));
                this.filterInputsBy(this.filter);
                this.setUrls(ClasspathHelper.getUrlsForPackagePrefix(prefix));
                if (scanners == null || scanners.length == 0) {
                    this.setScanners(new TypeAnnotationsScanner().filterResultsBy(this.filter), new SubTypesScanner().filterResultsBy(this.filter));
                } else {
                    this.setScanners(scanners);
                }
            }
        });
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan() {
        if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
            log.error("given scan urls are empty. set urls in the configuration");
            return;
        }
        long time = System.currentTimeMillis();
        ExecutorService executorService = (ExecutorService)this.configuration.getExecutorServiceSupplier().get();
        ArrayList futures = Lists.newArrayList();
        try {
            for (URL url : this.configuration.getUrls()) {
                Iterable<Vfs.File> files;
                try {
                    files = Vfs.fromURL(url).getFiles();
                }
                catch (ReflectionsException e) {
                    log.error("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
                    continue;
                }
                for (final Vfs.File file : files) {
                    Future<?> future = executorService.submit(new Runnable(){

                        public void run() {
                            String input = file.getRelativePath().replace('/', '.');
                            if (Reflections.this.configuration.acceptsInput(input)) {
                                for (Scanner scanner : Reflections.this.configuration.getScanners()) {
                                    if (!scanner.acceptsInput(input)) continue;
                                    scanner.scan(file);
                                }
                            }
                        }
                    });
                    futures.add(future);
                }
            }
        }
        finally {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            executorService.shutdown();
        }
        time = System.currentTimeMillis() - time;
        Integer keys = this.store.getKeysCount();
        Integer values = this.store.getValuesCount();
        log.info(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", time, this.configuration.getUrls().size(), keys, values, executorService instanceof ThreadPoolExecutor ? String.format("[using %d cores]", ((ThreadPoolExecutor)executorService).getMaximumPoolSize()) : ""));
    }

    public static Reflections collect() {
        return new Reflections().collect("META-INF/reflections", new FilterBuilder().include(".*-reflections.xml"));
    }

    public Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter) {
        return this.collect(packagePrefix, resourceNameFilter, this.configuration.getSerializer());
    }

    public Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter, Serializer serializer) {
        for (Vfs.File file : Vfs.findFiles(ClasspathHelper.getUrlsForPackagePrefix(packagePrefix), packagePrefix, resourceNameFilter)) {
            try {
                this.merge(serializer.read(file.getInputStream()));
                log.info("Reflections collected metadata from " + file + " using serializer " + serializer.getClass().getName());
            }
            catch (IOException e) {
                throw new ReflectionsException("could not merge " + file, e);
            }
        }
        return this;
    }

    public Reflections collect(InputStream inputStream) {
        try {
            this.merge(this.configuration.getSerializer().read(inputStream));
            log.info("Reflections collected metadata from input stream using serializer " + this.configuration.getSerializer().getClass().getName());
        }
        catch (Exception ex) {
            throw new ReflectionsException("could not merge input stream", ex);
        }
        return this;
    }

    public Reflections collect(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Reflections reflections = this.collect(inputStream);
            return reflections;
        }
        catch (FileNotFoundException e) {
            throw new ReflectionsException("could not obtain input stream from file " + file, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Reflections merge(Reflections reflections) {
        this.store.merge(reflections.store);
        return this;
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set<String> subTypes = this.store.getSubTypesOf(type.getName());
        return ImmutableSet.copyOf(Utils.forNames(subTypes));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> typesAnnotatedWith = this.store.getTypesAnnotatedWith(annotation.getName());
        return ImmutableSet.copyOf(Utils.forNames(typesAnnotatedWith));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        Set<String> typesAnnotatedWith = this.store.getTypesAnnotatedWith(annotation.getName(), honorInherited);
        return ImmutableSet.copyOf(Utils.forNames(typesAnnotatedWith));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.getTypesAnnotatedWith(annotation, true);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        return Reflections.getMatchingAnnotations(this.getTypesAnnotatedWith(annotation.annotationType(), honorInherited), annotation);
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> annotatedWith = this.store.getMethodsAnnotatedWith(annotation.getName());
        HashSet result = Sets.newHashSet();
        for (String annotated : annotatedWith) {
            result.add(Utils.getMethodFromDescriptor(annotated));
        }
        return result;
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        return Reflections.getMatchingAnnotations(this.getMethodsAnnotatedWith(annotation.annotationType()), annotation);
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        HashSet result = Sets.newHashSet();
        Set<String> annotatedWith = this.store.getFieldsAnnotatedWith(annotation.getName());
        for (String annotated : annotatedWith) {
            result.add(Utils.getFieldFromString(annotated));
        }
        return result;
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        return Reflections.getMatchingAnnotations(this.getFieldsAnnotatedWith(annotation.annotationType()), annotation);
    }

    public Set<Method> getConverters(Class<?> from, Class<?> to) {
        HashSet result = Sets.newHashSet();
        Set<String> converters = this.store.getConverters(from.getName(), to.getName());
        for (String converter : converters) {
            result.add(Utils.getMethodFromDescriptor(converter));
        }
        return result;
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        return this.store.getResources(namePredicate);
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            public boolean apply(String input) {
                return pattern.matcher(input).matches();
            }
        });
    }

    public Store getStore() {
        return this.store;
    }

    public File save(String filename) {
        return this.save(filename, this.configuration.getSerializer());
    }

    public File save(String filename, Serializer serializer) {
        File file = serializer.save(this, filename);
        log.info("Reflections successfully saved in " + file + " using " + serializer.getClass().getSimpleName());
        return file;
    }
}

