/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

/**
 * <h2>The <a href="http://www.xebialabs.com/deployit-automated-deployment-java-applications">Deployit</a> plugin for Oracle Service Bus.</h2>
 * 
 * This is the standard Deployit plugin for functionality related to Oracle Service Bus
 * (further referenced in this documentation as OSB). It provides support 
 * for WebLogic OSB-specific components and allows users to import and customize  
 * OSB resources to a WebLogic Deployment environment.
 * 
 * <h3>Supported middleware</h3>
 * 
 * This plugin supports Oracle Service Bus (OSB) version 3.0
 * 
 <h3>Requirements</h3>
 * 
 * The plugin executes its import and customization tasks by connecting to the
 * target systems and executing WLST commands there. This implies that the following
 * must be possible:
 * 
 * <ul>
 * <li>creating a connection to the host on which the admin server(s) of the OSB(which is also a WLS domain)
 * Domain(s) being administered are running, using the {@link com.xebialabs.deployit.ci.Host Host's} 
 * specified connection methods
 * <li>starting WLST on the target admin server under the user Deployit uses to connect to
 * the host (or the SUDO user, if specified)
 * </ul>
 * 
 * In addition, if the plugin is being used in an Apache/WLS environment in order to configure the
 * Apache WebLogic plugin:
 * 
 * <ul>
 * <li>the Apache server must have the correct version of the WebLogic plugin installed
 * and activated
 * <li>Apache must be configured to include all {@code *.conf} files in a certain directory
 * in its configuration
 * <li>it must be possible to create a connection from the Deployit server to the Apache
 * server(s) being administered
 * <li>the user under which Deployit connects to the Apache servers (or the SUDO user, if
 * specified) must be able to create, modify and delete files in the Apache configuration
 * directory referred to above
 * <li>this user must also be able to stop, start and restart Apache
 * </ul>
 * 
 * <h3>Components</h3>
 * 
 * OSB middleware environments are modelled on the basis of the following Configuration
 * Items (CIs):
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.osb.ci.OsbDomain Osb Domain}
 * <li>{@link com.xebialabs.deployit.plugin.osb.ci.OsbJar Osb Jar}
 * <li>{@link com.xebialabs.deployit.plugin.osb.ci.OsbJarMapping Osb Jar Mapping}
 * <li>{@link com.xebialabs.deployit.plugin.osb.ci.OsbCustomizationFile Osb Customization File}
 * </ul>
 * 
 * <h3>Supported scenarios</h3>
 * 
 * The plugin supports all the standard {@link com.xebialabs.deployit.plugin.wls WLS scenarios}, and the following ones in addition to that: 
 * 
 * <ul>
 * <li>importing of the OSB jar(the deployment step), deletion of the imported OSB jar(the undeployment step) and customization of resources 
 * present in the OSB jar via the {@link com.xebialabs.deployit.plugin.wls.runbook.OsbDeploymentRunBook OSB Deployment RunBook}
 * </ul>
 * 
 * For details of the exact components supported, sequence in which steps are carried out, limitations
 * etc. please consult the documentation for the appropriate runbook.
 * 
 * <h4>Mapping</h4>
 * 
 * The plugin supports all the standard {@link com.xebialabs.deployit.plugin.wls WLS mappings}. In addition to that {@link com.xebialabs.deployit.plugin.osb.ci.OsbJar} in a deployment package can be mapped to:
 * 
 * <ul>
 * <li>a specified OSB domain in the target environment
 * </ul>
 * 
 * <h3>Known limitations</h3>
 * 
 * In addition to the limitations known for the {@link com.xebialabs.deployit.plugin.wls WLS limitations}, the following limitation applies for OSB plugin:
 * 
 * <ul>
 * <li>it does not currently support modification or deletion of OSB domains
 * <li>since the import or customization of the OSB jar is done after the deployments of other packages present in the same deployment package, 
 *      there might be a time-window when certain OSB-dependent package (already deployed successfully in previous steps) doesn't work. Once 
 *      import/customization of the OSB jar is complete, these OSB dependent deployed packages should start to work again.
 * </ul>
 * 
 * If you have questions, comments or feedback please <a href="mailto:deployit-dev@xebialabs.com">contact</a>
 * the Oracle Service Bus development team at XebiaLabs.
 * 
 * @version 1.2
 */
package com.xebialabs.deployit.plugin.osb;