/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.osb.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.osb.ci.OsbVersion;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@ConfigurationItem(description="Oracle Service Bus Domain", category="middleware")
public class OsbDomain
extends WlsDomain {
    static final String OSB_WLST_PACKAGE = "com/xebialabs/deployit/plugin/osb";
    @ConfigurationItemProperty(required=true, description="The location of the Oracle Service Bus.", size=ConfigurationItemProperty.Size.LARGE)
    private String osbHome;
    @ConfigurationItemProperty
    private OsbVersion version = OsbVersion.OSB_3_0;
    private static Logger logger = Logger.getLogger(OsbDomain.class);

    public String getOsbHome() {
        return this.osbHome;
    }

    public void setOsbHome(String osbHome) {
        this.osbHome = osbHome;
    }

    public OsbVersion getVersion() {
        return this.version;
    }

    public void setVersion(OsbVersion version) {
        this.version = version;
    }

    public int executeWlstJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, String ... args) {
        ArrayList<String> cmd = new ArrayList<String>();
        switch (this.getActiveHost().getOperatingSystemFamily()) {
            case UNIX: {
                logger.info((Object)"Uploading wlst.sh from Deployit distribution to add required libraries to the classpath.");
                HostFile uploadedWlstSh = s.copyToTemporaryFile((Resource)this.getWlstScript());
                cmd.add("/bin/sh");
                cmd.add(uploadedWlstSh.getPath());
                cmd.add(this.getWlHome());
                cmd.add(this.getOsbHome());
                break;
            }
            case WINDOWS: {
                logger.info((Object)"Uploading wlst.cmd from Deployit distribution to add required libraries to the classpath.");
                HostFile uploadedWlstCmd = s.copyToTemporaryFile((Resource)this.getWlstScript());
                cmd.add(uploadedWlstCmd.getPath());
                cmd.add(this.getWlHome());
                cmd.add(this.getOsbHome());
            }
        }
        cmd.add("-i");
        cmd.add(scriptPath);
        for (String arg : args) {
            cmd.add(arg);
        }
        String[] cmdArray = cmd.toArray(new String[cmd.size()]);
        return s.execute(handler, cmdArray);
    }

    private ClassPathResource getWlstScript() {
        String shellName = "";
        switch (this.getActiveHost().getOperatingSystemFamily()) {
            case UNIX: {
                shellName = "wlst.sh";
                break;
            }
            case WINDOWS: {
                shellName = "wlst.cmd";
            }
        }
        String packageName = OSB_WLST_PACKAGE;
        switch (this.version) {
            case OSB_3_0: {
                packageName = packageName + "/osb30/";
                break;
            }
            case OSB_11g: {
                packageName = packageName + "/osb11g/";
            }
        }
        return new ClassPathResource(packageName + shellName);
    }
}

