import sys, traceback
from java.io import File
from java.io import FileOutputStream
from java.util import Collections
from com.bea.wli.config import Ref


def deleteProject():
    try:
        
        sys.argv.pop(0)
    
        user = sys.argv.pop(0)
        password = sys.argv.pop(0)
        url = sys.argv.pop(0)
        project = sys.argv.pop(0)
        
        if project == None :
            print "Project is None!"
            raise
        
        connectToServer(user, password, url)
        print 'connected'
        
        sessionName = createSessionName(project)
        print 'Created session', sessionName
        
        SessionMBean = getSessionMBean(sessionName)
        print 'SessionMBean started session'

        ALSBConfigurationMBean = findService(String("ALSBConfiguration.").concat(sessionName), "com.bea.wli.sb.management.configuration.ALSBConfigurationMBean")
        print "ALSBConfiguration MBean found", ALSBConfigurationMBean
        
        ref = Ref.makeProjectRef(project);
        print "Delete the project", project
        collection = Collections.singleton(ref)
        ALSBConfigurationMBean.delete(collection)
        
        print "Activating session %s" % (sessionName)
        SessionMBean.activateSession(sessionName, user)
        print "ALSB project "+ project + " has been deleted"

    except:
        print "->deleteProject Unexpected error"
        exceptionType, exceptionValue, exceptionTraceback = sys.exc_info()
        print exceptionValue
        traceback.print_tb(exceptionTraceback, limit=1, file=sys.stdout)
        print "<-deleteProject Unexpected error"
        if SessionMBean != None:
            print "Discard Session %s" % (sessionName)
            SessionMBean.discardSession(sessionName)
        raise
        
#=======================================================================================
# Connect to the Admin Server
#=======================================================================================

def connectToServer(username, password, url):
    connect(username, password, url)
    domainRuntime()
    
#=======================================================================================
# Utility function to create an arbitrary session name
#=======================================================================================
def createSessionName(project):
    sessionName = String("DeployIt-Delete-"+str(project)+"-"+Long(System.currentTimeMillis()).toString())
    return sessionName

#=======================================================================================
# Utility function to load a session MBeans
#=======================================================================================
def getSessionMBean(sessionName):
    SessionMBean = findService("SessionManagement","com.bea.wli.sb.management.configuration.SessionManagementMBean")
    SessionMBean.createSession(sessionName)
    return SessionMBean


# EXPORT script init
try:
    deleteProject()

except:
    print "Main Unexpected error: ", sys.exc_info()[0]
    dumpStack()
    disconnect()
    exit()
    raise

disconnect()
exit()
